/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.kymographtracker.spline;

import java.util.ArrayList;

public class CubicSpline {
    private double s = 1.0E-16;
    private double[][] input;
    private double[] a;
    private double[] b;
    private double[] c;
    private double[] d;

    public CubicSpline(double[][] input, double smoothingFactor) {
        this.s = smoothingFactor;
    }

    private void smooth() {
        double h;
        int N = this.input.length;
        boolean n1 = true;
        int n2 = N;
        double[] x = new double[N + 1];
        double[] y = new double[N + 1];
        double dy = 1.0;
        int i = 1;
        while (i < N + 1) {
            x[i] = this.input[i][0];
            y[i] = this.input[i][1];
            ++i;
        }
        this.a = new double[N += 2];
        this.b = new double[N];
        this.c = new double[N];
        this.d = new double[N];
        double[] r = new double[N];
        double[] r1 = new double[N];
        double[] r2 = new double[N];
        double[] t = new double[N];
        double[] t1 = new double[N];
        double[] u = new double[N];
        double[] v = new double[N];
        int m1 = 0;
        int m2 = n2 + 1;
        double p = 0.0;
        u[m2] = 0.0;
        u[n2] = 0.0;
        u[1] = 0.0;
        u[m1] = 0.0;
        r2[m2] = 0.0;
        r2[n2] = 0.0;
        r1[n2] = 0.0;
        r[1] = 0.0;
        r[m1] = 0.0;
        m1 = 2;
        m2 = n2 - 1;
        double g = h = (double)(m1 - 1);
        double f = (y[m1] - y[1]) / h;
        int i2 = m1;
        while (i2 <= m2) {
            g = h;
            h = 1.0;
            double e = f;
            f = y[i2 + 1] - y[i2];
            this.a[i2] = f - e;
            t[i2] = 2.0 * (g + h) / 3.0;
            t1[i2] = h / 3.0;
            r2[i2] = 1.0 / g;
            r[i2] = 1.0;
            r1[i2] = -1.0 / g - 1.0;
            ++i2;
        }
        i2 = m1;
        while (i2 <= m2) {
            this.b[i2] = r[i2] * r[i2] + r1[i2] * r1[i2] + r2[i2] * r2[i2];
            this.c[i2] = r[i2] * r1[i2 + 1] + r1[i2] * r2[i2 + 1];
            this.d[i2] = r[i2] * r2[i2 + 2];
            ++i2;
        }
        double f2 = -this.s;
        while (true) {
            i2 = m1;
            while (i2 <= m2) {
                r1[i2 - 1] = f * r[i2 - 1];
                r2[i2 - 2] = g * r[i2 - 2];
                r[i2] = 1.0 / (p * this.b[i2] + t[i2] - f * r1[i2 - 1] - g * r2[i2 - 2]);
                u[i2] = this.a[i2] - r1[i2 - 1] * u[i2 - 1] - r2[i2 - 2] * u[i2 - 2];
                f = p * this.c[i2] + t1[i2] - h * r1[i2 - 1];
                g = h;
                h = this.d[i2] * p;
                ++i2;
            }
            i2 = m2;
            while (i2 >= m1) {
                u[i2] = r[i2] * u[i2] - r1[i2] * u[i2 + 1] - r2[i2] * u[i2 + 2];
                --i2;
            }
            h = 0.0;
            double e = 0.0;
            i2 = 1;
            while (i2 <= m2) {
                g = h;
                h = u[i2 + 1] - u[i2];
                v[i2] = (h - g) * 1.0 * 1.0;
                e += v[i2] * (h - g);
                ++i2;
            }
            g = v[n2] = -h * 1.0 * 1.0;
            e -= g * h;
            g = f2;
            f2 = e * p * p;
            if (f2 >= this.s || f2 <= g) break;
            f = 0.0;
            h = (v[m1] - v[1]) / (double)(m1 - 1);
            i2 = m1;
            while (i2 <= m2) {
                g = h;
                h = v[i2 + 1] - v[i2];
                g = h - g - r1[i2 - 1] * r[i2 - 1] - r2[i2 - 2] * r[i2 - 2];
                f += g * r[i2] * g;
                r[i2] = g;
                ++i2;
            }
            h = e - p * f;
            if (h <= 0.0) break;
            p += (this.s - f2) / ((Math.sqrt(this.s / e) + p) / h);
        }
        i2 = 1;
        while (i2 <= n2) {
            this.a[i2] = y[i2] - p * v[i2];
            this.c[i2] = u[i2];
            ++i2;
        }
        i2 = 1;
        while (i2 <= m2) {
            h = 1.0;
            this.d[i2] = (this.c[i2 + 1] - this.c[i2]) / (3.0 * h);
            this.b[i2] = (this.a[i2 + 1] - this.a[i2]) / h - (h * this.d[i2] + this.c[i2]) * h;
            ++i2;
        }
    }

    public void index() {
        this.smooth();
        int n = this.input.length;
        ArrayList<Double> output = new ArrayList<Double>(n);
        int i = 0;
        while (i < n) {
            double y = this.d[i] + this.c[i] + this.b[i] + this.a[i];
            output.add(new Double(y));
            ++i;
        }
        double y2 = ((Number)output.get(2)).doubleValue();
        double y1 = ((Number)output.get(1)).doubleValue();
        double y0 = y1 - (y2 - y1);
        output.set(0, new Double(y0));
    }
}

