/*
 * Copyright 2010, 2011 Institut Pasteur.
 * 
 * This file is part of ICY.
 * 
 * ICY is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * ICY is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ICY. If not, see <http://www.gnu.org/licenses/>.
 */
package plugins.tutorial.vtk;

import icy.painter.Overlay;
import icy.painter.VtkPainter;
import vtk.vtkProp;
import vtk.vtkTextActor;
import vtk.vtkTextProperty;

/**
 * This class shows how to use VTK to render a simple 2D text as 3D painter
 * 
 * @author Stephane
 */
public class VtkText2DPainter extends Overlay implements VtkPainter
{
    // vtk object
    private vtkTextActor textActor;

    public VtkText2DPainter()
    {
        super("VTK 2D text");

        init();
    }

    // init vtk objects
    private void init()
    {
        // VTK 2D text object
        textActor = new vtkTextActor();
        textActor.SetInput("VTK text test");

        final vtkTextProperty textProperty = textActor.GetTextProperty();

        // change text properties
        textProperty.SetFontFamilyToArial();
        textProperty.BoldOn();
        textProperty.ShadowOn();
        textProperty.SetFontSize(30);
        textProperty.SetColor(0.5, 0.5, 0.5);
        textProperty.SetShadowOffset(2, 2);

        // set text position
        textActor.SetPosition(100, 300);
    }

    @Override
    public vtkProp[] getProps()
    {
        return new vtkProp[] {textActor};
    }
}
