package plugins.ylemontag.sequencecomparator.comparators;

import icy.sequence.Sequence;
import plugins.ylemontag.sequencecomparator.ErrorMeasure;

/**
 * 
 * @author Yoann Le Montagner
 *
 */
public class GlobalMSE extends GlobalSquaredErrorBased
{
	/**
	 * Constructor
	 */
	public GlobalMSE(String distanceName)
	{
		super(distanceName);
	}
	
	@Override
	protected void normalizeErrorMeasure(ErrorMeasure retVal, Sequence seq)
	{
		int sizeXY = seq.getSizeX() * seq.getSizeY();
		int sizeZ = seq.getSizeZ();
		int sizeT = seq.getSizeT();
		int sizeC = seq.getSizeC();
		retVal.errorAll = retVal.errorAll / (sizeC*sizeT*sizeZ*sizeXY);
		arrayNormalization(retVal.errorZ, sizeC*sizeT*sizeXY);
		arrayNormalization(retVal.errorT, sizeC*sizeZ*sizeXY);
		arrayNormalization(retVal.errorC, sizeT*sizeZ*sizeXY);
	}
	
	/**
	 * Divide all the elements in the array by 'divisor'
	 */
	private static void arrayNormalization(double[] array, double divisor)
	{
		for(int k=0; k<array.length; ++k) {
			array[k] = array[k] / divisor;
		}
	}
}
