package plugins.ylemontag.ssim;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Compute the SSIM between two sequences with the same size
 */
public class SSIMBlock extends Plugin implements Block, PluginBundled
{
	// BlockInfo (name): "SSIM"
	// BlockInfo (desc): "Compute the structured similarity index (SSIM) between two sequences"
	
	// Input
	private VarSequence         _seq1       = new VarSequence("Sequence 1", null);
	private VarSequence         _seq2       = new VarSequence("Sequence 2", null);
	private Var<SSIMCalculator> _calculator = new Var<SSIMCalculator>("SSIM calculator",
		SSIMCalculator.class, null);
	
	// Output
	private VarSequence _outMap  = new VarSequence("SSIM map" , null);
	private VarDouble   _outMean = new VarDouble  ("SSIM mean", 0.0 );

	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add(_seq1      );
		inputMap.add(_seq2      );
		inputMap.add(_calculator);
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add(_outMap );
		outputMap.add(_outMean);
	}
	
	@Override
	public String getMainPluginClassName()
	{
		return SSIMPlugin.class.getName();
	}
	
	@Override
	public void run()
	{
		// Retrieve the parameters
		SSIMCalculator calculator = _calculator.getValue(true);
		Sequence       seq1       = _seq1      .getValue(true);
		Sequence       seq2       = _seq2      .getValue(true);
		if(!SSIMCalculator.haveSameSize(seq1, seq2)) {
			throw new VarException(
				"All the sequences involved in a SSIM computation must have the same size."
			);
		}
		
		// Core computation
		SSIMCalculator.Result result = calculator.compute(seq1, seq2);
		_outMap .setValue(result.map );
		_outMean.setValue(result.mean);
	}
}
