package plugins.fab.challengescoring;

import icy.gui.frame.progress.TaskFrame;
import icy.gui.util.GuiUtil;
import icy.system.thread.ThreadUtil;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.Timer;

public class ChronoFrame extends TaskFrame implements ActionListener {

	Timer timer = new Timer( 1000 , this );
    long startTimeInNs;

    JLabel textLabel ; 
    JLabel timeLabel ; 
	
	public ChronoFrame( final String message) {
		super(message);

		ThreadUtil.invokeNow( new Runnable() {
			
			@Override
			public void run() {

				mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.PAGE_AXIS) );

				textLabel = new JLabel( message );
				mainPanel.add( GuiUtil.createLineBoxPanel( textLabel ) );

				timeLabel = new JLabel("0 seconds");
				mainPanel.add( GuiUtil.createLineBoxPanel( timeLabel ) );
				
				
				stateChanged();
				
			}
		});
		
		startTimeInNs = System.nanoTime();
		timer.start();
		
	}

	@Override
	public void actionPerformed(ActionEvent e) {

		timeLabel.setText( getSeconds() + " seconds" );
	
	}
	
	@Override
	public void close() {
	
	 if (timer != null)
         timer.stop();
		timer = null;
		
		super.close();
	}
	
    private long getSeconds()
    {
        return (long) (( System.nanoTime() - startTimeInNs) / 1000000000f );
    }
    
    
    
    
}
