package plugins.fab.challengescoring;

import icy.util.XMLUtil;

import java.io.File;
import java.util.ArrayList;

import org.w3c.dom.Document;

import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.trackprocessorchallengetracksimporter.TrackExportAndImportUtilities;

public class ChallengeDocument {	
	
	File sourceFile;
	
	Document document;
	
	int snr;
	Density density;
	Scenario scenario;
	
	public File getSourceFile() {
		return sourceFile;
	}
	
	public ChallengeDocument( File file ) {
		
		System.out.println("Loading and checking " + file );
		
		this.sourceFile = file;
		document = XMLUtil.loadDocument( file );
		snr = Util.getSNR( document );
		density = Util.getDensity( document );
		scenario = Util.getScenario( document );
				
		System.out.println ( this );
		document = null; // release document.
		
	}
	
	
	@Override
	public String toString() {

		String info = "File: " + sourceFile + " scenario: " + scenario + " density: " + density + " snr: " + snr ;
		return info;

	}


	public boolean asSameParametersAs(ChallengeDocument document ) {
		
		if ( document.density == density  && document.snr == snr  && document.scenario == scenario ) 
			return true;
		
		return false;
	}


	public ArrayList<TrackSegment> getTrackSegmentList() {

		return TrackExportAndImportUtilities.importTracksFile( sourceFile );
		
	}
	
	
	
}
