/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.rieszwavelets;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.type.collection.array.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import plugins.nchenouard.isotropicwavelets.IsotropicWaveletType;
import plugins.nchenouard.isotropicwavelets.WaveletConfigPanel;
import plugins.nchenouard.isotropicwavelets.WaveletFilterSet;
import plugins.tinevez.rieszwavelets.AngleSequence;
import plugins.tinevez.rieszwavelets.CoefficientSelectionPanel;
import plugins.tinevez.rieszwavelets.CustomChooser;
import plugins.tinevez.rieszwavelets.HarmonicTypes;
import plugins.tinevez.rieszwavelets.RieszConfigurationPanel;
import plugins.tinevez.rieszwavelets.RieszGeneralization;
import plugins.tinevez.rieszwavelets.RieszWaveletCoefficients;
import plugins.tinevez.rieszwavelets.RieszWaveletConfig;
import plugins.tinevez.rieszwavelets.SequenceAnalysisResults;
import plugins.tinevez.rieszwavelets.StandardRieszFrames;

public class RieszWavelets
extends PluginActionable {
    IcyFrame mainFrame;
    JTabbedPane mainPanel;
    String computeWavCoeffString = "Compute coefficients from focused image";
    String selectWavCoeffString = "Select existing wavelet coefficients";
    JComboBox<String> waveletSelectionBox = new JComboBox<String>(new String[]{this.computeWavCoeffString, this.selectWavCoeffString});
    JPanel waveletPanel;
    CardLayout wavCoeffCards = new CardLayout();
    CoefficientSelectionPanel wavCoeffSelectionPanel;
    WaveletConfigPanel wavCoeffConfigPanel;
    RieszConfigurationPanel rieszConfigPanel;
    CoefficientSelectionPanel coefficientSelectionPanel;
    JButton processImageButton;
    JButton processSequenceButton;
    JCheckBox displayCoefficientsBox;
    JButton displayCoefficientsButton;
    JButton reconstructButton;
    JButton steerCoefficientsButton;
    JButton steerCoefficientsBackButton;
    CoefficientSelectionPanel steeringCoefficientSelectionPanel;
    SpinnerNumberModel monogenicRegularizationModel;
    CustomChooser angleChooser;
    AnnounceFrame announceFrame;
    Thread runningThread;

    public void run() {
        this.generateGUI();
    }

    private void generateGUI() {
        this.mainFrame = new IcyFrame("Riesz-wavelets", true, true, false, true);
        JTabbedPane mainPanel = new JTabbedPane();
        this.mainFrame.setContentPane((Container)mainPanel);
        JPanel analysisPanel = new JPanel(new GridBagLayout());
        JPanel analysisPanel2 = new JPanel(new BorderLayout());
        analysisPanel2.add((Component)analysisPanel, "Center");
        mainPanel.addTab("Wavelet Analysis", analysisPanel2);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel waveletPanel = new JPanel(new BorderLayout());
        analysisPanel.add((Component)waveletPanel, c);
        JPanel northPanel = new JPanel(new GridBagLayout());
        waveletPanel.add((Component)northPanel, "North");
        c.gridy = 0;
        northPanel.add((Component)new JLabel("Wavelet coefficients source"), c);
        ++c.gridy;
        northPanel.add(this.waveletSelectionBox, c);
        final JPanel centerPanel = new JPanel(this.wavCoeffCards);
        waveletPanel.add((Component)centerPanel, "Center");
        this.wavCoeffSelectionPanel = new CoefficientSelectionPanel();
        this.wavCoeffSelectionPanel.setBorder(new TitledBorder("Wavelet coefficients selection"));
        centerPanel.add((Component)this.wavCoeffSelectionPanel, this.selectWavCoeffString);
        this.wavCoeffConfigPanel = new WaveletConfigPanel();
        this.wavCoeffConfigPanel.setBorder((Border)new TitledBorder("Wavelet analysis configuration"));
        centerPanel.add((Component)this.wavCoeffConfigPanel, this.computeWavCoeffString);
        this.waveletSelectionBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                RieszWavelets.this.wavCoeffCards.show(centerPanel, RieszWavelets.this.waveletSelectionBox.getSelectedItem().toString());
            }
        });
        this.wavCoeffCards.show(centerPanel, this.waveletSelectionBox.getSelectedItem().toString());
        this.rieszConfigPanel = new RieszConfigurationPanel();
        analysisPanel.add((Component)this.rieszConfigPanel, c);
        ++c.gridy;
        JPanel actionPanel = new JPanel(new GridLayout(3, 1));
        analysisPanel2.add((Component)actionPanel, "South");
        this.displayCoefficientsBox = new JCheckBox("Display coefficients");
        this.displayCoefficientsBox.setSelected(true);
        actionPanel.add(this.displayCoefficientsBox);
        this.processImageButton = new JButton("Process the focused image");
        this.processImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RieszWavelets.this.processImage();
            }
        });
        actionPanel.add(this.processImageButton);
        this.processSequenceButton = new JButton("Process the whole sequence");
        actionPanel.add(this.processSequenceButton);
        this.processSequenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RieszWavelets.this.processSequence();
            }
        });
        JPanel reconstructionPanel = new JPanel(new BorderLayout());
        this.coefficientSelectionPanel = new CoefficientSelectionPanel();
        reconstructionPanel.add((Component)this.coefficientSelectionPanel, "Center");
        JPanel reconstructionSouthPanel = new JPanel(new GridLayout(2, 1));
        this.displayCoefficientsButton = new JButton("Display Coefficients");
        this.displayCoefficientsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RieszWavelets.this.displayCurrentCoefficients();
            }
        });
        reconstructionSouthPanel.add(this.displayCoefficientsButton);
        this.reconstructButton = new JButton("Reconstruct image");
        this.reconstructButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RieszWavelets.this.reconstructCurrentCoefficients();
            }
        });
        reconstructionSouthPanel.add(this.reconstructButton);
        reconstructionPanel.add((Component)reconstructionSouthPanel, "South");
        mainPanel.addTab("Reconstruction", reconstructionPanel);
        JPanel steeringPanel = new JPanel(new BorderLayout());
        mainPanel.addTab("Coefficient steering", steeringPanel);
        JPanel steeringCenterPanel = new JPanel(new GridLayout(2, 1));
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(2, 2, 2, 2);
        steeringPanel.add((Component)steeringCenterPanel, "Center");
        this.steeringCoefficientSelectionPanel = new CoefficientSelectionPanel();
        this.steeringCoefficientSelectionPanel.setBorder(new TitledBorder("Riesz-wavelet coefficient selection"));
        steeringCenterPanel.add(this.steeringCoefficientSelectionPanel);
        ++c.gridy;
        JPanel anglePanel = new JPanel(new BorderLayout());
        anglePanel.setBorder(new TitledBorder("Rotation angle selection"));
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridheight = 1;
        c2.gridwidth = 1;
        c2.gridx = 0;
        c2.gridy = 0;
        c2.fill = 2;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        c2.insets = new Insets(2, 2, 2, 2);
        JPanel angleSelectionCardPanel = new JPanel(new GridBagLayout());
        c2.gridy = 0;
        angleSelectionCardPanel.add((Component)new JLabel("Use existing angles"), c2);
        ++c2.gridy;
        this.angleChooser = new CustomChooser(AngleSequence.class);
        angleSelectionCardPanel.add((Component)this.angleChooser, c2);
        ++c2.gridy;
        angleSelectionCardPanel.add((Component)new JLabel("Use the Monogenic Analysis plugin if empty."), c2);
        anglePanel.setLayout(new BorderLayout());
        anglePanel.add((Component)angleSelectionCardPanel, "Center");
        steeringCenterPanel.add(anglePanel);
        ++c.gridy;
        JPanel steeringSouthPanel = new JPanel(new GridLayout(2, 1));
        steeringPanel.add((Component)steeringSouthPanel, "South");
        this.steerCoefficientsButton = new JButton("Steer coefficients");
        this.steerCoefficientsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RieszWavelets.this.steerCoefficients(true);
            }
        });
        this.steerCoefficientsBackButton = new JButton("Steer coefficients back");
        this.steerCoefficientsBackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RieszWavelets.this.steerCoefficients(false);
            }
        });
        steeringSouthPanel.add(this.steerCoefficientsButton);
        steeringSouthPanel.add(this.steerCoefficientsBackButton);
        this.mainFrame.setPreferredSize(new Dimension(400, 500));
        this.mainFrame.pack();
        this.addIcyFrame(this.mainFrame);
        this.mainFrame.setVisible(true);
    }

    private void steerCoefficients(final boolean forward) {
        Object selectedItem = this.steeringCoefficientSelectionPanel.resultsBox.getSelectedItem();
        if (selectedItem != null) {
            final SequenceAnalysisResults results = (SequenceAnalysisResults)((SwimmingObject)selectedItem).getObject();
            final AngleSequence sequenceAngles = (AngleSequence)this.angleChooser.getSelectedObject();
            if (sequenceAngles == null) {
                return;
            }
            this.computationStarted();
            this.runningThread = new Thread(){

                @Override
                public void run() {
                    ArrayList<Integer> analyzedTimes = results.getAllAnalyzedTimesResults();
                    for (int t : analyzedTimes) {
                        RieszWaveletCoefficients coefficients = results.getResult(t);
                        ArrayList<double[]> angleList = sequenceAngles.getAngles(t);
                        coefficients.getConfig().steerCoefficients(coefficients, angleList, forward);
                    }
                    RieszWavelets.this.displayCoefficients(results);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RieszWavelets.this.computationEnded();
                        }
                    });
                }
            };
            this.runningThread.start();
        }
    }

    private void reconstructCurrentCoefficients() {
        Object selectedItem = this.coefficientSelectionPanel.resultsBox.getSelectedItem();
        if (selectedItem != null) {
            final SequenceAnalysisResults results = (SequenceAnalysisResults)((SwimmingObject)selectedItem).getObject();
            this.computationStarted();
            this.runningThread = new Thread(){

                @Override
                public void run() {
                    ArrayList<RieszWaveletCoefficients> coeffList = results.getAllResults();
                    ArrayList<Integer> timeList = results.getAllAnalyzedTimesResults();
                    if (coeffList.isEmpty()) {
                        return;
                    }
                    final HashMap<RieszWaveletCoefficients, Integer> mapResTime = new HashMap<RieszWaveletCoefficients, Integer>();
                    int cnt = 0;
                    while (cnt < coeffList.size()) {
                        mapResTime.put(coeffList.get(cnt), timeList.get(cnt));
                        ++cnt;
                    }
                    Collections.sort(coeffList, new Comparator<RieszWaveletCoefficients>(){

                        @Override
                        public int compare(RieszWaveletCoefficients o1, RieszWaveletCoefficients o2) {
                            return ((Integer)mapResTime.get(o1)).compareTo((Integer)mapResTime.get(o2));
                        }
                    });
                    Sequence reconstructedSeq = new Sequence("Reconstructed Riesz-wavelet image");
                    int i = 0;
                    while (i < coeffList.size()) {
                        RieszWaveletCoefficients coeffs = coeffList.get(i);
                        RieszWaveletConfig config = coeffs.getConfig();
                        int width = config.getWaveletFilterSet().getWidth();
                        int height = config.getWaveletFilterSet().getHeight();
                        double[] reconstructedImage = config.multiscaleRieszSynthesisInFourier(coeffs, width, height);
                        reconstructedSeq.addImage(i, (BufferedImage)new IcyBufferedImage(width, height, (Object)reconstructedImage));
                        ++i;
                    }
                    Icy.getMainInterface().addSequence(reconstructedSeq);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RieszWavelets.this.computationEnded();
                        }
                    });
                }
            };
            this.runningThread.start();
        }
    }

    private void displayCurrentCoefficients() {
        Object selectedItem = this.coefficientSelectionPanel.resultsBox.getSelectedItem();
        if (selectedItem != null) {
            final SequenceAnalysisResults results = (SequenceAnalysisResults)((SwimmingObject)selectedItem).getObject();
            this.computationStarted();
            this.runningThread = new Thread(){

                @Override
                public void run() {
                    RieszWavelets.this.displayCoefficients(results);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RieszWavelets.this.computationEnded();
                        }
                    });
                }
            };
            this.runningThread.start();
        }
    }

    private void processImage() {
        final Sequence seq = this.getActiveSequence();
        if (seq != null) {
            final int t = seq.getFirstViewer().getPositionT();
            final int width = seq.getSizeX();
            final int height = seq.getSizeY();
            final int numScales = this.wavCoeffConfigPanel.getNumScales();
            final boolean prefilter = this.wavCoeffConfigPanel.isPrefilter();
            final IsotropicWaveletType waveletType = this.wavCoeffConfigPanel.getWaveletType();
            final boolean isotropicPadding = this.wavCoeffConfigPanel.isIsotropicPadding();
            final int order = this.rieszConfigPanel.getOrder();
            final HarmonicTypes harmonicType = this.rieszConfigPanel.getHarmonicType();
            boolean prepareRieszFilters = true;
            boolean isReal = true;
            final StandardRieszFrames rieszFrame = this.rieszConfigPanel.getStandardRiezGeneralization();
            final boolean isDisplayCoefficients = this.displayCoefficientsBox.isSelected();
            this.computationStarted();
            this.runningThread = new Thread(){

                @Override
                public void run() {
                    RieszWaveletConfig config = new RieszWaveletConfig(width, height, true, numScales, waveletType, prefilter, true, order, harmonicType, isotropicPadding);
                    ArrayList<RieszGeneralization> generalizationList = new ArrayList<RieszGeneralization>();
                    int i = 0;
                    while (i < config.rieszConfigList.size()) {
                        RieszGeneralization rieszGeneralization = new RieszGeneralization(rieszFrame, config.rieszConfigList.get(i));
                        generalizationList.add(rieszGeneralization);
                        ++i;
                    }
                    double[] image = (double[])ArrayUtil.arrayToDoubleArray((Object)seq.getImage(t, 0, 0).getDataXY(0), (boolean)seq.isSignedDataType());
                    RieszWaveletCoefficients coefficients = config.multiscaleRieszAnalysisInFourier(image, width, height, generalizationList);
                    SequenceAnalysisResults results = new SequenceAnalysisResults(seq.getName());
                    results.setResult(t, coefficients);
                    Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject((Object)results, "Riesz-wavelet coefficients for frame of " + results.getSequenceName()));
                    if (isDisplayCoefficients) {
                        int n = 0;
                        while (n < numScales) {
                            coefficients.displayCoefficients(n);
                            ++n;
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RieszWavelets.this.computationEnded();
                        }
                    });
                }
            };
            this.runningThread.start();
        }
    }

    private void processSequence() {
        final Sequence seq = this.getActiveSequence();
        if (seq != null) {
            final int width = seq.getSizeX();
            final int height = seq.getSizeY();
            final int numScales = this.wavCoeffConfigPanel.getNumScales();
            final boolean prefilter = this.wavCoeffConfigPanel.isPrefilter();
            final IsotropicWaveletType waveletType = this.wavCoeffConfigPanel.getWaveletType();
            final boolean isotropicPadding = this.wavCoeffConfigPanel.isIsotropicPadding();
            final int order = this.rieszConfigPanel.getOrder();
            final HarmonicTypes harmonicType = this.rieszConfigPanel.getHarmonicType();
            boolean prepareRieszFilters = true;
            boolean isReal = true;
            final StandardRieszFrames rieszFrame = this.rieszConfigPanel.getStandardRiezGeneralization();
            final boolean isDisplayCoefficients = this.displayCoefficientsBox.isSelected();
            this.computationStarted();
            this.runningThread = new Thread(){

                @Override
                public void run() {
                    RieszWaveletConfig config = new RieszWaveletConfig(width, height, true, numScales, waveletType, prefilter, true, order, harmonicType, isotropicPadding);
                    ArrayList<RieszGeneralization> generalizationList = new ArrayList<RieszGeneralization>();
                    int i = 0;
                    while (i < config.rieszConfigList.size()) {
                        RieszGeneralization rieszGeneralization = new RieszGeneralization(rieszFrame, config.rieszConfigList.get(i));
                        generalizationList.add(rieszGeneralization);
                        ++i;
                    }
                    SequenceAnalysisResults results = new SequenceAnalysisResults(seq.getName());
                    int t = 0;
                    while (t < seq.getSizeT()) {
                        double[] image = (double[])ArrayUtil.arrayToDoubleArray((Object)seq.getImage(t, 0, 0).getDataXY(0), (boolean)seq.isSignedDataType());
                        RieszWaveletCoefficients coefficients = config.multiscaleRieszAnalysisInFourier(image, width, height, generalizationList);
                        results.setResult(t, coefficients);
                        ++t;
                    }
                    Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject((Object)results, "Riesz-wavelet coefficients for " + results.getSequenceName()));
                    if (isDisplayCoefficients) {
                        RieszWavelets.this.displayCoefficients(results);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RieszWavelets.this.computationEnded();
                        }
                    });
                }
            };
            this.runningThread.start();
        }
    }

    private void computationStarted() {
        this.processImageButton.setEnabled(false);
        this.processSequenceButton.setEnabled(false);
        this.displayCoefficientsButton.setEnabled(false);
        this.reconstructButton.setEnabled(false);
        this.announceFrame = new AnnounceFrame("Computation started");
    }

    private void computationEnded() {
        this.processImageButton.setEnabled(true);
        this.processSequenceButton.setEnabled(true);
        this.displayCoefficientsButton.setEnabled(true);
        this.reconstructButton.setEnabled(true);
        this.announceFrame.close();
    }

    private static void testTransform() {
        Sequence seq = Icy.getMainInterface().getActiveSequence();
        if (seq == null) {
            return;
        }
        int height = seq.getSizeY();
        int width = seq.getSizeX();
        boolean isRealImage = true;
        int numScales = 4;
        boolean prefilter = true;
        IsotropicWaveletType waveletType = IsotropicWaveletType.Simoncelli;
        int order = 3;
        HarmonicTypes harmonicType = HarmonicTypes.odd;
        boolean prepareRieszFilters = true;
        RieszWaveletConfig config = new RieszWaveletConfig(width, height, isRealImage, numScales, waveletType, prefilter, prepareRieszFilters, order, harmonicType);
        config.displayRieszFilters(0);
        ArrayList<RieszGeneralization> generalizationList = new ArrayList<RieszGeneralization>();
        int i = 0;
        while (i < config.rieszConfigList.size()) {
            RieszGeneralization rieszGeneralization = new RieszGeneralization(StandardRieszFrames.CircularHarmonics, config.rieszConfigList.get(i));
            generalizationList.add(rieszGeneralization);
            ++i;
        }
        double[] image = (double[])ArrayUtil.arrayToDoubleArray((Object)seq.getImage(0, 0, 0).getDataXY(0), (boolean)seq.isSignedDataType());
        RieszWaveletCoefficients coefficients = config.multiscaleRieszAnalysisInFourier(image, width, height, generalizationList);
        coefficients.displayCoefficients(0);
        double[] reconstructedImage = config.multiscaleRieszSynthesisInFourier(coefficients, width, height);
        Sequence reconstructedSeq = new Sequence("Reconstructed Riesz-wavelet image");
        reconstructedSeq.addImage(0, (BufferedImage)new IcyBufferedImage(width, height, (Object)reconstructedImage));
        Icy.getMainInterface().addSequence(reconstructedSeq);
    }

    public void displayCoefficients(SequenceAnalysisResults results) {
        ArrayList<RieszWaveletCoefficients> coeffList = results.getAllResults();
        ArrayList<Integer> timeList = results.getAllAnalyzedTimesResults();
        if (coeffList.isEmpty()) {
            return;
        }
        int numScales = coeffList.get(0).getNumScales();
        final HashMap<RieszWaveletCoefficients, Integer> mapResTime = new HashMap<RieszWaveletCoefficients, Integer>();
        int cnt = 0;
        while (cnt < coeffList.size()) {
            mapResTime.put(coeffList.get(cnt), timeList.get(cnt));
            ++cnt;
        }
        Collections.sort(coeffList, new Comparator<RieszWaveletCoefficients>(){

            @Override
            public int compare(RieszWaveletCoefficients o1, RieszWaveletCoefficients o2) {
                return ((Integer)mapResTime.get(o1)).compareTo((Integer)mapResTime.get(o2));
            }
        });
        ArrayList<Sequence> waveletBandsSequenceList = new ArrayList<Sequence>(numScales);
        int scale = 0;
        while (scale < numScales) {
            Sequence scaleSeq = new Sequence();
            scaleSeq.setName("scale " + scale);
            waveletBandsSequenceList.add(scaleSeq);
            Icy.getMainInterface().addSequence(scaleSeq);
            ++scale;
        }
        int t = 0;
        while (t < coeffList.size()) {
            RieszWaveletCoefficients coefficients = coeffList.get(t);
            WaveletFilterSet waveletConfig = coefficients.getConfig().getWaveletFilterSet();
            int scale2 = 0;
            while (scale2 < numScales) {
                double[][] dataTab = coefficients.getRieszBandsAtScale(scale2);
                int k = 0;
                while (k < dataTab.length) {
                    IcyBufferedImage bandImage = new IcyBufferedImage(waveletConfig.getScaleWidth(scale2), waveletConfig.getScaleHeight(scale2), (Object)dataTab[k]);
                    Sequence scaleSeq = (Sequence)waveletBandsSequenceList.get(scale2);
                    scaleSeq.setImage(t, k, (BufferedImage)bandImage);
                    ++k;
                }
                ++scale2;
            }
            ++t;
        }
    }
}

