/*
 *  This file is part of the StereoViewer plug-in for ICY.
 *  Copyright (C) 2012 Ricard Delgado-Gonzalo
 *  
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package plugins.rdelgado.stereoviewer;

import plugins.rdelgado.stereoviewer.utils.ScreenUtils;
import icy.gui.frame.progress.AnnounceFrame;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;

/**
 * Stereo displayer plug-in main class.
 * 
 * @version February 8, 2012
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class StereoViewer extends PluginActionable
{
	/** Focused sequence. */
	private Sequence focusedSequence_ = null;

	// ============================================================================
	// PUBLIC METHODS

	/** Main method of the plug-in. */
	@Override
	public void run ()
	{
		if(ScreenUtils.getNDisplays()<2)
		{
			new AnnounceFrame("This plugin requires at least two screens.");
			return;
		}
		else
		{
			focusedSequence_ = getFocusedSequence();
			if (focusedSequence_==null)
			{
				new AnnounceFrame("This plugin requires a 3D stack.");
				return;
			}
			else if (focusedSequence_.getSizeZ()<=1)
			{
				new AnnounceFrame("This plugin requires a 3D stack.");
				return;
			}

			StereoViewDisplayer stereoViewDisplayer = new StereoViewDisplayer(focusedSequence_);
			stereoViewDisplayer.display();
		}
	}
}