import linecache
import os.path
from java.io import File
import inspect

class JavaInspect:
	def __init__(self, classloader):
		self.classloader = classloader
	
	# this function extends inspect.getsource(module) to handle the case where
	# the module is loaded from Icy classloader instead of being loaded as
	# usual by python
	# Note: this is possible because Icy classloader has a method to retrieve
	# the resource for a given object, that turns out to work great for Python
	# files
	def getsource(self, module):
		try:
			return inspect.getsource(module)
		except IOError:
			moduleName = module.__name__
			
			#inspect.getsource could not find the file
			#it surely means that the code is not inside a regular .py file loaded from disk by python
			#it may be a .py file loaded by a Java classloader
			#or even a .py inside a jar
			
			# go from Python module name to path and file name
			moduleName = moduleName.split('.')
			moduleName = os.path.join(*moduleName)
			moduleName += ".py"
			
			resourceURL = self.classloader.getResource(moduleName)
			if resourceURL <> None:
				protocol = resourceURL.getProtocol()
				
				if protocol == "jar":
					jarFile = resourceURL.openConnection().getJarFile()
					jarEntry = resourceURL.openConnection().getJarEntry()
					inputStream = jarFile.getInputStream(jarEntry)
			
					from org.python.core.util import FileUtil
					f = FileUtil.wrap(inputStream)
					return f.read(-1) # read until EOF
				elif protocol == "file":
					fileName = resourceURL.getFile()
					return "".join(linecache.getlines(fileName))
				else:
					raise IOError("Cannot load module %s whose resource %s is not a file nor a jar" %(moduleName, resourceURL))
			else:
				raise IOError("Cannot load module %s: not found by inspect module, and not found in java classloader" %(moduleName))


# this function extends inspect.getsource(module) to handle the case where
# the module is loaded from Icy classloader instead of being loaded as
# usual by python
# Note: this is possible because Icy classloader has a method to retrieve
# the resource for a given object, that turns out to work great for Python
# files
def getsource(module):
	from icy.plugin import PluginLoader
	return JavaInspect(PluginLoader.getLoader()).getsource(module)
