/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.pathtracing;

import icy.gui.component.sequence.SequenceChooser;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.image.IcyBufferedImage;
import icy.painter.Painter;
import icy.plugin.abstract_.PluginActionable;
import icy.roi.ROI;
import icy.roi.ROI2DPolyLine;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import plugins.tinevez.pathtracing.InteractiveMultipleDjikstraTracing;

public class MultiplePathsKymographCalculator
extends PluginActionable {
    private SequenceChooser sequenceChooser = new SequenceChooser();
    IcyFrame mainFrame;
    double alpha = 0.001;
    Thread projectionThread;
    ArrayList<Sequence[]> projSeqList = new ArrayList();

    public void run() {
        this.mainFrame = new IcyFrame("Multiple path tracking", true, true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        mainPanel.add((Component)this.sequenceChooser, c);
        ++c.gridy;
        JButton maxProjectionButton = new JButton("Max projection");
        maxProjectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiplePathsKymographCalculator.this.projectionThread = new Thread(){

                    @Override
                    public void run() {
                        MultiplePathsKymographCalculator.this.projectSequence(MultiplePathsKymographCalculator.this.sequenceChooser.getSelectedSequence());
                    }
                };
                MultiplePathsKymographCalculator.this.projectionThread.start();
            }
        });
        mainPanel.add((Component)maxProjectionButton, c);
        ++c.gridy;
        JButton addPathButton = new JButton("Add new path");
        addPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiplePathsKymographCalculator.this.addPath();
            }
        });
        mainPanel.add((Component)addPathButton, c);
        ++c.gridy;
        JButton convertToROIButton = new JButton("ConvertToROIButton");
        convertToROIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiplePathsKymographCalculator.this.convertPathToROI();
            }
        });
        mainPanel.add((Component)convertToROIButton, c);
        ++c.gridy;
        this.mainFrame.setContentPane((Container)mainPanel);
        this.mainFrame.pack();
        this.mainFrame.addToMainDesktopPane();
        this.mainFrame.center();
        this.mainFrame.setVisible(true);
        this.mainFrame.requestFocus();
        this.mainFrame.addFrameListener(new IcyFrameListener(){

            public void icyFrameOpened(IcyFrameEvent e) {
            }

            public void icyFrameClosing(IcyFrameEvent e) {
            }

            public void icyFrameClosed(IcyFrameEvent e) {
                for (Sequence seq : MultiplePathsKymographCalculator.this.getSequences()) {
                    for (Painter tracer : seq.getPainters(InteractiveMultipleDjikstraTracing.class)) {
                        seq.removePainter(tracer);
                    }
                }
            }

            public void icyFrameIconified(IcyFrameEvent e) {
            }

            public void icyFrameDeiconified(IcyFrameEvent e) {
            }

            public void icyFrameActivated(IcyFrameEvent e) {
            }

            public void icyFrameDeactivated(IcyFrameEvent e) {
            }

            public void icyFrameInternalized(IcyFrameEvent e) {
            }

            public void icyFrameExternalized(IcyFrameEvent e) {
            }
        });
    }

    private void addPath() {
        Sequence seq = this.sequenceChooser.getSelectedSequence();
        if (seq != null && seq.getPainters(InteractiveMultipleDjikstraTracing.class).isEmpty()) {
            InteractiveMultipleDjikstraTracing tracer = new InteractiveMultipleDjikstraTracing(seq, this.alpha, false);
            seq.addPainter((Painter)tracer);
        }
    }

    private void convertPathToROI() {
        Sequence seq = this.sequenceChooser.getSelectedSequence();
        if (seq != null) {
            int cntROI = seq.getROICount(ROI2DPolyLine.class);
            for (Painter tracer : seq.getPainters(InteractiveMultipleDjikstraTracing.class)) {
                ArrayList<double[][]> pathList = ((InteractiveMultipleDjikstraTracing)tracer).getOptimalPathCopy();
                double prevLastPosX = -1.0;
                double prevLastPosY = -1.0;
                ROI2DPolyLine polylineROI = null;
                if (!pathList.isEmpty()) {
                    for (double[][] path : pathList) {
                        int i;
                        if (path[0][0] == prevLastPosX && path[0][1] == prevLastPosY) {
                            i = 1;
                            while (i < path.length) {
                                polylineROI.addPointAt((Point2D)new Point2D.Double(path[i][0], path[i][1]), false);
                                ++i;
                            }
                        } else {
                            polylineROI = new ROI2DPolyLine((Point2D)new Point2D.Double(path[0][0], path[0][1]));
                            polylineROI.setName("axon " + ++cntROI);
                            for (Sequence[] seqPair : this.projSeqList) {
                                if (seqPair[0] == seq) {
                                    seqPair[1].addROI((ROI)polylineROI);
                                }
                                if (seqPair[1] != seq) continue;
                                seqPair[0].addROI((ROI)polylineROI);
                            }
                            seq.addROI((ROI)polylineROI);
                            i = 1;
                            while (i < path.length) {
                                polylineROI.addPointAt((Point2D)new Point2D.Double(path[i][0], path[i][1]), false);
                                ++i;
                            }
                        }
                        prevLastPosX = path[path.length - 1][0];
                        prevLastPosY = path[path.length - 1][1];
                    }
                }
                seq.removePainter(tracer);
            }
        }
    }

    private void projectSequence(Sequence seq) {
        if (seq != null) {
            Sequence projectionSequence = new Sequence("Sum " + seq.getName());
            projectionSequence.setImage(0, 0, (BufferedImage)new IcyBufferedImage(seq.getSizeX(), seq.getSizeY(), 1, DataType.DOUBLE));
            double[] tabValues = projectionSequence.getImage(0, 0, 0).getDataXYAsDouble(0);
            int y = 0;
            while (y < seq.getSizeY()) {
                int x = 0;
                while (x < seq.getSizeX()) {
                    double maxVal = seq.getData(0, 0, 0, y, x);
                    int t = 1;
                    while (t < seq.getSizeT()) {
                        if (maxVal < seq.getData(t, 0, 0, y, x)) {
                            maxVal = seq.getData(t, 0, 0, y, x);
                        }
                        ++t;
                    }
                    tabValues[x + y * seq.getWidth()] = maxVal;
                    ++x;
                }
                ++y;
            }
            projectionSequence.dataChanged();
            this.addSequence(projectionSequence);
            this.projSeqList.add(new Sequence[]{seq, projectionSequence});
        }
    }
}

