package plugins.tpecot.gcops;

import icy.gui.dialog.MessageDialog;
import icy.plugin.abstract_.PluginActionable;
import java.io.File;
import java.util.Arrays;

import icy.file.FileUtil;
import icy.gui.dialog.MessageDialog;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.Array2DUtil;
import icy.system.IcyHandledException;
import icy.util.XLSUtil;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import plugins.adufour.ezplug.*;
import plugins.adufour.filtering.*;
import plugins.adufour.blocks.*;
import plugins.adufour.blocks.util.VarList;
import plugins.mitiv.JTransforms3;
import org.jtransforms.fft.FloatFFT_2D;
import org.jtransforms.fft.FloatFFT_3D;


public class GcoPS extends EzPlug implements EzStoppable {

	public class Semaphore {

		private int evolution=0,totalEvolution=0;

		Semaphore (int e,int t) {
			evolution=e;totalEvolution=t;
		}

		Semaphore () {
			evolution=0;totalEvolution=1;
		}

		public void init(int e,int t) {
			evolution=e;totalEvolution=t;
		}

		public boolean unfinished() {
			if(this.evolution<this.totalEvolution){return true;}
			else{return false;}
		}

		public float getProgress() {
			synchronized (this) {
				return (float)this.evolution/(float)this.totalEvolution;
			}
		}

		public float getEvolution() {
			synchronized (this) {
				return (float)this.evolution;
			}
		}

		public void progress() {
			synchronized (this) {
				evolution++;
				this.notify ();
			}
		}
	}

	EzVarInteger channel1,channel2,randomizationWindowWidth,randomizationWindowHeight,randomizationWindowDepth,denseWindowWidth,denseWindowHeight,denseWindowDepth,maxShift; 
	EzVarSequence input1,input2,cellMask;
	EzVarFile exportExcelFileStatisticalTest,exportExcelFileRandomization,exportExcelFileTemporalProfile;
	EzVarText mode,randomizationProportion;

	// parameters for progress bar
	Semaphore autocorrelationSemaphore = new Semaphore(),processingSemaphore = new Semaphore();
	boolean stopRunningBgProcess=false;

	// average blurring
	void average(float[][][] input,int width,int height,int depth,int nbFrames){
		float[][] output = new float[depth][width*height];
		for(int t=0;t<nbFrames;t++){
			for(int z=0;z<depth;z++){
				for(int y=0;y<height;y++){
					for(int x=0;x<width;x++){
						for(int j=-4;j<=4;j++){
							for(int i=-4;i<=4;i++){
								if(((x+i)>=0)&&((x+i)<width)&&((y+j)>=0)&&((y+j)<height)){
									output[z][y*width+x] += input[t][z][(y+j)*width+x+i];
								}
							}
						}
					}
				}
			}
			for(int z=0;z<depth;z++){
				for(int y=0;y<height;y++){
					for(int x=0;x<width;x++){
						input[t][z][y*width+x] = output[z][y*width+x]/81;
					}
				}
			}
		}
	}
	
	// Gaussian blurring
	void gaussianBlurring(float[][][] input,int width,int height,int depth,int nbFrames){
		float[][] output = new float[depth][width*height];
		float variance=16;
		for(int t=0;t<nbFrames;t++){
			for(int z=0;z<depth;z++){
				for(int y=0;y<height;y++){
					for(int x=0;x<width;x++){
						for(int j=-10;j<=10;j++){
							for(int i=-10;i<=10;i++){
								if(((x+i)>=0)&&((x+i)<width)&&((y+j)>=0)&&((y+j)<height)){
									output[z][y*width+x] += (1/Math.sqrt(2*Math.PI*variance))*Math.exp(-(Math.pow(i,2)+Math.pow(j,2))/(2*variance))*input[t][z][(y+j)*width+x+i];
								}
							}
						}
					}
				}
			}
			for(int z=0;z<depth;z++){
				for(int y=0;y<height;y++){
					for(int x=0;x<width;x++){
						input[t][z][y*width+x] = output[z][y*width+x];
					}
				}
			}
		}
	}

	// p-value computation
	static float CND(float d)
	{
		double       A1 = 0.31938153;
		double       A2 = -0.356563782;
		double       A3 = 1.781477937;
		double       A4 = -1.821255978;
		double       A5 = 1.330274429;
		double RSQRT2PI = 0.39894228040143267793994605993438;

		double
		K = 1.0 / (1.0 + 0.2316419 * Math.abs(d));

		double
		cnd = RSQRT2PI * Math.exp(- 0.5 * d * d) *
		(K * (A1 + K * (A2 + K * (A3 + K * (A4 + K * A5)))));

		if (d > 0)
			cnd = 1.0 - cnd;

		return (float)cnd;
	}


	// 2D autocorrelation via FFT
	float[] fftAutoCorrelation(float [] x, int w,int h) {
		int newW = 2*w+1,newH = 2*h+1;
		float[] xCopy = new float[newW*2*newH];
		for (int j = 0; j < h; j++) {
			for (int i = 0; i < w; i++) {
				xCopy[i*2*newH+2*j] = x[j*w+i];
				xCopy[i*2*newH+2*j+1] = 0;
			}
		}
		FloatFFT_2D fft = new FloatFFT_2D(newW,newH);
		fft.complexForward(xCopy);
		float[] complexConjugate = complex_conjugate(xCopy, newW, newH);
		
		float[] complexMultiplication = complex_mul(xCopy, complexConjugate, newW, newH);
		FloatFFT_2D fft2 = new FloatFFT_2D(newW, newH);
		fft2.complexInverse(complexMultiplication, true);
		float[] shifted = shift(complexMultiplication, newW, newH);
		float[] output = new float[newW*newH];
		for (int j = 0; j < newH; j++) {
			for (int i = 0; i < newW; i++) {
				output[j*newW+i] = shifted[i*2*newH+2*j]/(w*h);
			}
		}
		return output;
	}

	// 2D complex conjugate computation
	float[] complex_conjugate(float[] z,int w,int h){
		float[] dest = new float[2*w*h];
		for (int j = 0; j < h; j++) {
			for (int i = 0; i < w; i++) {
				dest[i*2*h+2*j] = z[i*2*h+2*j];
				dest[i*2*h+2*j+1] = -z[i*2*h+2*j+1];
			}
		}
		return dest;
	}

	// 2D complex multiplication
	float[] complex_mul(float[] z1,float[] z2,int w,int h){
		float[] dest = new float[2*w*h];
		for (int j = 0; j < h; j++) {
			for (int i = 0; i < w; i++) {
				float a = z1[i*2*h+2*j], b = z1[i*2*h+2*j+1], c = z2[i*2*h+2*j], d = z2[i*2*h+2*j+1];
				dest[i*2*h+2*j] = a * c - b * d;
				dest[i*2*h+2*j+1] = b * c + a * d;
			}
		}
		return dest;
	}

	// 2D shift
	float[] shift(float[] z,int w,int h){
		float[] dest = new float[w*2*h];
		for (int j = 0; j < h; j++) {
			for (int i = 0; i < w; i++) {
				int newIdX = i-w/2-1,newIdY=j-h/2-1;
				if(newIdX<0){newIdX+=w;}
				if(newIdY<0){newIdY+=h;}
				dest[newIdX*2*h+2*newIdY] = z[i*2*h+2*j];
				dest[newIdX*2*h+2*newIdY+1] = z[i*2*h+2*j+1];
			}
		}
		return dest;
	}


	// 3D autocorrelation computation via FFT
	float[][] fftAutoCorrelation(float [][] x, int w,int h,int d) {
		int newW = 2*w+1,newH = 2*h+1,newD = 2*d+1;
		float[] xCopy = new float[newD*newW*2*newH];
		//float[][] realFFT = new float[newD][newW*newH],imaginaryFFT = new float[newD][newW*newH];
		for (int k = 0; k < d; k++) {
			for (int j = 0; j < h; j++) {
				for (int i = 0; i < w; i++) {
					xCopy[k*newW*2*newH+i*2*newH+2*j] = x[k][j*w+i];
					xCopy[k*newW*2*newH+i*2*newH+2*j+1] = 0;
				}
			}
		}
		FloatFFT_3D fft = new FloatFFT_3D(newD,newW,newH);
		fft.complexForward(xCopy);
		/*for (int k = 0; k < newD; k++) {
				for (int j = 0; j < newH; j++) {
					for (int i = 0; i < newW; i++) {
						realFFT[k][j*newW+i] = xCopy[k*newW*2*newH+i*2*newH+2*j];
						imaginaryFFT[k][j*newW+i] = xCopy[k*newW*2*newH+i*2*newH+2*j+1];
					}
				}
			}
	        visualizeImage(realFFT, newW, newH, newD, 0,"real fft");
	        visualizeImage(imaginaryFFT, newW, newH, newD, 0, "imaginary fft");*/
		/*FloatFFT_3D fftS2 = new FloatFFT_3D(newW, newH, newD);
			fftS2.complexInverse(xCopy, true);
			for (int k = 0; k < newD; k++) {
				for (int j = 0; j < newH; j++) {
					for (int i = 0; i < newW; i++) {
						realFFT[k][j*newW+i] = xCopy[k*newW*2*newH+i*2*newH+2*j];
						imaginaryFFT[k][j*newW+i] = xCopy[k*newW*2*newH+i*2*newH+2*j+1];
					}
				}
			}
			visualizeImage(realFFT, newW, newH, newD, 0,"real fft inverse");
	        visualizeImage(imaginaryFFT, newW, newH, newD, 0, "imaginary fft inverse");*/


		float[] complexConjugate = complex_conjugate(xCopy, newW, newH,newD);
		/*FloatFFT_3D fftS = new FloatFFT_3D(newD,newW,newH);
			fftS.complexInverse(complexConjugate, true);
			for (int k = 0; k < newD; k++) {
				for (int j = 0; j < newH; j++) {
					for (int i = 0; i < newW; i++) {
						realFFT[k][j*newW+i] = complexConjugate[k*newW*2*newH+i*2*newH+2*j];
						imaginaryFFT[k][j*newW+i] = complexConjugate[k*newW*2*newH+i*2*newH+2*j+1];
					}
				}
			}
			visualizeImage(realFFT, newW, newH, newD, 0,"real complex conjugate inverse");
	        visualizeImage(imaginaryFFT, newW, newH, newD, 0, "imaginary complex conjugate inverse");*/
		/*for (int k = 0; k < newD; k++) {
				for (int j = 0; j < newH; j++) {
					for (int i = 0; i < newW; i++) {
						realFFT[k][j*newW+i] = complexConjugate[k*newW*2*newH+i*2*newH+2*j];
						imaginaryFFT[k][j*newW+i] = complexConjugate[k*newW*2*newH+i*2*newH+2*j+1];
					}
				}
			}
			visualizeImage(realFFT, newW, newH, newD, 0,"complex conjugate real");
			visualizeImage(imaginaryFFT, newW, newH, newD, 0, "complex conjugate imaginary");*/
		float[] complexMultiplication = complex_mul(xCopy, complexConjugate, newW, newH, newD);
		/*for (int k = 0; k < newD; k++) {
				for (int j = 0; j < newH; j++) {
					for (int i = 0; i < newW; i++) {
						realFFT[k][j*newW+i] = complexMultiplication[k*newW*2*newH+i*2*newH+2*j];
						imaginaryFFT[k][j*newW+i] = complexMultiplication[k*newW*2*newH+i*2*newH+2*j+1];
					}
				}
			}
			visualizeImage(realFFT, newW, newH, newD, 0,"complex multiplication real");
			visualizeImage(imaginaryFFT, newW, newH, newD, 0, "complex multiplication imaginary");*/
		FloatFFT_3D fft2 = new FloatFFT_3D(newD, newW, newH);
		fft2.complexInverse(complexMultiplication, true);
		/*for (int k = 0; k < newD; k++) {
				for (int j = 0; j < newH; j++) {
					for (int i = 0; i < newW; i++) {
						realFFT[k][j*newW+i] = complexMultiplication[k*newW*2*newH+i*2*newH+2*j];
						imaginaryFFT[k][j*newW+i] = complexMultiplication[k*newW*2*newH+i*2*newH+2*j+1];
					}
				}
			}
			visualizeImage(realFFT, newW, newH, newD, 0,"complex multiplication inverse real");
			visualizeImage(imaginaryFFT, newW, newH, newD, 0, "complex multiplication inverse imaginary");*/
		float[] shifted = shift(complexMultiplication, newW, newH, newD);
		float[][] output = new float[newD][newW*newH];
		for (int k = 0; k < newD; k++) {
			for (int j = 0; j < newH; j++) {
				for (int i = 0; i < newW; i++) {
					output[k][j*newW+i] = shifted[k*newW*2*newH+i*2*newH+2*j]/(w*h*d);
				}
			}
		}
		return output;
	}

	// 3D complex conjugate
	float[] complex_conjugate(float[] z,int w,int h,int d){
		float[] dest = new float[2*w*h*d];
		for (int k = 0; k < d; k++) {
			for (int j = 0; j < h; j++) {
				for (int i = 0; i < w; i++) {
					dest[k*w*2*h+i*2*h+2*j] = z[k*w*2*h+i*2*h+2*j];
					dest[k*w*2*h+i*2*h+2*j+1] = -z[k*w*2*h+i*2*h+2*j+1];
				}
			}
		}
		return dest;
	}

	// 3D complex multiplication
	float[] complex_mul(float[] z1,float[] z2,int w,int h,int d){
		float[] dest = new float[2*w*h*d];
		for (int k = 0; k < d; k++) {
			for (int j = 0; j < h; j++) {
				for (int i = 0; i < w; i++) {
					float a = z1[k*w*2*h+i*2*h+2*j], b = z1[k*w*2*h+i*2*h+2*j+1], c = z2[k*w*2*h+i*2*h+2*j], e = z2[k*w*2*h+i*2*h+2*j+1];
					dest[k*w*2*h+i*2*h+2*j] = a * c - b * e;
					dest[k*w*2*h+i*2*h+2*j+1] = b * c + a * e;
				}
			}
		}
		return dest;
	}

	// 3D shift
	float[] shift(float[] z,int w,int h,int d){
		float[] dest = new float[w*2*h*d];
		for (int k = 0; k < d; k++) {
			for (int j = 0; j < h; j++) {
				for (int i = 0; i < w; i++) {
					int newIdX = i-w/2-1,newIdY=j-h/2-1,newIdZ=k-d/2-1;
					if(newIdX<0){newIdX+=w;}
					if(newIdY<0){newIdY+=h;}
					if(newIdZ<0){newIdZ+=d;}
					dest[newIdZ*w*2*h+newIdX*2*h+2*newIdY] = z[k*w*2*h+i*2*h+2*j];
					dest[newIdZ*w*2*h+newIdX*2*h+2*newIdY+1] = z[k*w*2*h+i*2*h+2*j+1];
				}
			}
		}
		return dest;
	}


	// 2D radius truncation
	int radiusTruncation(float[] autocorrelation1,float[] autocorrelation2,double truncationValue,int w,int h){

		int radiusForTruncation = 0;
		double max1=0.,max2=0.,distanceMax1=0.,distanceMax2=0.;
		for(int y=0;y<h;y++){
			for(int x=0;x<w;x++){
				if(autocorrelation1[y*w+x]>max1){
					max1 = autocorrelation1[y*w+x];
				}
				if(autocorrelation2[y*w+x]>max2){
					max2 = autocorrelation2[y*w+x];
				}
			}
		}
		for(int y=0;y<h;y++){
			for(int x=0;x<w;x++){
				if(autocorrelation1[y*w+x]>(truncationValue*max1)){
					if(Math.sqrt(Math.pow((double)(x-w/2),2.)+Math.pow((double)(y-h/2),2.))>distanceMax1){
						distanceMax1 = Math.sqrt(Math.pow((double)(x-w/2),2.)+Math.pow((double)(y-h/2),2.));
					}
				}
				if(autocorrelation2[y*w+x]>(truncationValue*max2)){
					if(Math.sqrt(Math.pow((double)(x-w/2),2.)+Math.pow((double)(y-h/2),2.))>distanceMax2){
						distanceMax2 = Math.sqrt(Math.pow((double)(x-w/2),2.)+Math.pow((double)(y-h/2),2.));
					}
				}
			}
		}
		int maxRadius=0;
		if(w>h){maxRadius=(h-1)/2;}
		else{maxRadius=(w-1)/2;}
		if(distanceMax1>distanceMax2){radiusForTruncation = Math.min((int)Math.ceil(distanceMax1),maxRadius);}
		else{radiusForTruncation = Math.min((int)Math.ceil(distanceMax2),maxRadius);}
		return radiusForTruncation;
	}

	// 3D radius and depth truncation
	void radiusAndDepthTruncations(float[][] autocorrelation1,float[][] autocorrelation2,double truncationValue,int w,int h,int d,int[] radiusForTruncation,int[] depthForTruncation){
		double max1=0.,max2=0.,distanceMax1=0.,distanceMax2=0.;
		for(int z=0;z<d;z++){
			for(int y=0;y<h;y++){
				for(int x=0;x<w;x++){
					if(autocorrelation1[z][y*w+x]>max1){
						max1 = autocorrelation1[z][y*w+x];
					}
					if(autocorrelation2[z][y*w+x]>(max2)){
						max2 = autocorrelation2[z][y*w+x];
					}
				}
			}
		}
		for(int z=0;z<d;z++){
			for(int y=0;y<h;y++){
				for(int x=0;x<w;x++){
					if(autocorrelation1[z][y*w+x]>(truncationValue*max1)){
						if(Math.sqrt(Math.pow((double)(x-w),2.)+Math.pow((double)(y-h),2.)+Math.pow((double)(z-d),2.))>distanceMax1){
							distanceMax1 = Math.sqrt(Math.pow((double)(x-w/2),2.)+Math.pow((double)(y-h/2),2.)+Math.pow((double)(z-d/2),2.));
						}
					}
					if(autocorrelation2[z][y*w+x]>(truncationValue*max2)){
						if(Math.sqrt(Math.pow((double)(x-w),2.)+Math.pow((double)(y-h),2.)+Math.pow((double)(z-d),2.))>distanceMax2){
							distanceMax2 = Math.sqrt(Math.pow((double)(x-w/2),2.)+Math.pow((double)(y-h/2),2.)+Math.pow((double)(z-d/2),2.));
						}
					}
				}
			}
		}
		int maxRadius=0,maxDepth=(d-1)/2;
		if(w>h){maxRadius=(h-1)/2;}
		else{maxRadius=(w-1)/2;}
		if(distanceMax1>distanceMax2){radiusForTruncation[0] = Math.min((int)Math.ceil(distanceMax1),maxRadius);}
		else{radiusForTruncation[0] = Math.min((int)Math.ceil(distanceMax2),maxRadius);}
		if(distanceMax1>distanceMax2){depthForTruncation[0] = Math.min((int)Math.ceil(distanceMax1),maxDepth);}
		else{depthForTruncation[0] = Math.min((int)Math.ceil(distanceMax2),maxDepth);}
	}

	// 2D S1 computation
	void computeS1(float[] denominator,float[] autocorrelation1,float[] autocorrelation2,int w,int h,int currentFrame){

		double S1=0.;
		float[] weightedMatrix = new float[(2*w+1)*(2*h+1)];
		for(int y=-h;y<=h;y++){
			for(int x=-w;x<=w;x++){
				weightedMatrix[(y+h)*(2*w+1)+x+w] = (w-Math.abs(x))*(h-Math.abs(y));
			}
		}
		for(int y=-h;y<=h;y++){
			for(int x=-w;x<=w;x++){
				S1 += autocorrelation1[(y+h)*(2*w+1)+x+w]*autocorrelation2[(y+h)*(2*w+1)+x+w]*weightedMatrix[(y+h)*(2*w+1)+x+w];
			}
		}
		denominator[currentFrame] = (float)(S1/Math.pow((w*h),2.));
	}

	// 3D S1 computation
	void computeS1(float[] denominator,float[][] autocorrelation1,float[][] autocorrelation2,int w,int h,int d,int currentFrame){

		double S1=0.;
		float[][] weightedMatrix = new float[2*d+1][(2*w+1)*(2*h+1)];
		for(int z=-d;z<=d;z++){
			for(int y=-h;y<=h;y++){
				for(int x=-w;x<=w;x++){
					weightedMatrix[z+d][(y+h)*(2*w+1)+x+w] = (w-Math.abs(x))*(h-Math.abs(y))*(d-Math.abs(z));
				}
			}
		}
		for(int z=-d;z<=d;z++){
			for(int y=-h;y<=h;y++){
				for(int x=-w;x<=w;x++){
					S1 += autocorrelation1[z+d][(y+h)*(2*w+1)+x+w]*autocorrelation2[z+d][(y+h)*(2*w+1)+x+w]*weightedMatrix[z+d][(y+h)*(2*w+1)+x+w];
				}
			}
		}
		denominator[currentFrame] = (float)(S1/Math.pow((w*h*d),2.));
	}

	// 2D truncated S1 computation
	float computeTruncatedS1(float[] autocorrelation1,float[] autocorrelation2,int w,int h,int radiusForTruncation){
		double S1=0.;

		float[] weightedMatrix = new float[(2*w+1)*(2*h+1)];
		for(int y=-radiusForTruncation;y<=radiusForTruncation;y++){
			for(int x=-radiusForTruncation;x<=radiusForTruncation;x++){
				weightedMatrix[(y+h)*(2*w+1)+x+w] = (w-Math.abs(x))*(h-Math.abs(y));
			}
		}
		for(int y=-radiusForTruncation;y<=radiusForTruncation;y++){
			for(int x=-radiusForTruncation;x<=radiusForTruncation;x++){
				S1 += autocorrelation1[(y+h)*(2*w+1)+x+w]*autocorrelation2[(y+h)*(2*w+1)+x+w]*weightedMatrix[(y+h)*(2*w+1)+x+w];
			}
		}
		return (float)(S1/Math.pow((w*h),2.));
	}

	// 3D truncated S1 computation
	float computeTruncatedS1(float[][] autocorrelation1,float[][] autocorrelation2,int w,int h,int d,int radiusForTruncation,int depthForTruncation){
		double S1=0.;

		float[][] weightedMatrix = new float[2*d+1][(2*w+1)*(2*h+1)];
		for(int z=-depthForTruncation;z<=depthForTruncation;z++){
			for(int y=-radiusForTruncation;y<=radiusForTruncation;y++){
				for(int x=-radiusForTruncation;x<=radiusForTruncation;x++){
					weightedMatrix[z+d][(y+h)*(2*w+1)+x+w] = (w-Math.abs(x))*(h-Math.abs(y))*(d-Math.abs(z));
				}
			}
		}
		for(int z=-depthForTruncation;z<=depthForTruncation;z++){
			for(int y=-radiusForTruncation;y<=radiusForTruncation;y++){
				for(int x=-radiusForTruncation;x<=radiusForTruncation;x++){
					S1 += autocorrelation1[z+d][(y+h)*(2*w+1)+x+w]*autocorrelation2[z+d][(y+h)*(2*w+1)+x+w]*weightedMatrix[z+d][(y+h)*(2*w+1)+x+w];
				}
			}
		}
		return (float)(S1/Math.pow((w*h*d),2.));
	}


	// export p-values and test statistic
	void exportPvalues(float[] pvalues,float[] testStatistic,float[] correlation,File f,Sequence seq1,int ch1,Sequence seq2,int ch2){
		if(f.exists()){
			WritableWorkbook wb = null;
			WritableSheet sheet = null;

			try
			{
				wb = XLSUtil.loadWorkbookForWrite(f);
				sheet = XLSUtil.createNewPage(wb, "Statistical test");
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}

			if(pvalues.length>1){
				String title = seq1.getName()+"_channel"+ch1+" and "+seq2.getName()+"_channel"+ch2;
				XLSUtil.setCellString(sheet, 0, 0, title);
				XLSUtil.setCellString(sheet, 0, 1, "Time");
				XLSUtil.setCellString(sheet, 1, 1, "p-value");
				XLSUtil.setCellString(sheet, 2, 1, "Colocalization score");
				XLSUtil.setCellString(sheet, 3, 1, "Colocalization (C) or Anti-Colocalization (AC)");
				for(int i=0;i<pvalues.length;i++){
					XLSUtil.setCellNumber(sheet, 0, i+2, i);
					XLSUtil.setCellNumber(sheet, 1, i+2, pvalues[i]);
					XLSUtil.setCellNumber(sheet, 2, i+2, testStatistic[i]);
					if(correlation[i]>0){XLSUtil.setCellString(sheet, 3, i+2, "C");}
					else{XLSUtil.setCellString(sheet, 3, i+2, "AC");}
				}
			}
			else{
				String title = seq1.getName()+"_channel"+ch1+" and "+seq2.getName()+"_channel"+ch2;
				XLSUtil.setCellString(sheet, 0, 0, title);
				XLSUtil.setCellString(sheet, 0, 1, "p-value");
				XLSUtil.setCellString(sheet, 1, 1, "Colocalization score");
				XLSUtil.setCellString(sheet, 2, 1, "Colocalization (C) or Anti-Colocalization (AC)");
				XLSUtil.setCellNumber(sheet, 0, 2, pvalues[0]);
				XLSUtil.setCellNumber(sheet, 1, 2, testStatistic[0]);
				if(correlation[0]>0){XLSUtil.setCellString(sheet, 2, 2, "C");}
				else{XLSUtil.setCellString(sheet, 2, 2, "AC");}
			}

			try
			{
				XLSUtil.saveAndClose(wb);
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}
		}
		else{
			WritableWorkbook wb = null;
			WritableSheet sheet = null;

			try
			{
				wb = XLSUtil.createWorkbook(f);
				sheet = XLSUtil.createNewPage(wb, "Statistical test");
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}

			if(pvalues.length>1){
				String title = seq1.getName()+"_channel"+ch1+" and "+seq2.getName()+"_channel"+ch2;
				XLSUtil.setCellString(sheet, 0, 0, title);
				XLSUtil.setCellString(sheet, 0, 1, "Time");
				XLSUtil.setCellString(sheet, 1, 1, "p-value");
				XLSUtil.setCellString(sheet, 2, 1, "Colocalization score");
				XLSUtil.setCellString(sheet, 3, 1, "Colocalization (C) or Anti-Colocalization (AC)");
				for(int i=0;i<pvalues.length;i++){
					XLSUtil.setCellNumber(sheet, 0, i+2, i);
					XLSUtil.setCellNumber(sheet, 1, i+2, pvalues[i]);
					XLSUtil.setCellNumber(sheet, 2, i+2, testStatistic[i]);
					if(correlation[i]>0){XLSUtil.setCellString(sheet, 3, i+2, "C");}
					else{XLSUtil.setCellString(sheet, 3, i+2, "AC");}
				}
			}
			else{
				String title = seq1.getName()+"_channel"+ch1+" and "+seq2.getName()+"_channel"+ch2;
				XLSUtil.setCellString(sheet, 0, 0, title);
				XLSUtil.setCellString(sheet, 0, 1, "p-value");
				XLSUtil.setCellString(sheet, 1, 1, "Colocalization score");
				XLSUtil.setCellString(sheet, 2, 1, "Colocalization (C) or Anti-Colocalization (AC)");
				XLSUtil.setCellNumber(sheet, 0, 2, pvalues[0]);
				XLSUtil.setCellNumber(sheet, 1, 2, testStatistic[0]);
				if(correlation[0]>0){XLSUtil.setCellString(sheet, 2, 2, "C");}
				else{XLSUtil.setCellString(sheet, 2, 2, "AC");}
			}

			try
			{
				XLSUtil.saveAndClose(wb);
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}
		}
	}

	// export p-values and test statistic
	void exportRandomPvalues(int[] nbPositivePvalues,int[] nbNegativePvalues,int nbRandomizations,File f,Sequence seq1,int ch1,Sequence seq2,int ch2){
		if(f.exists()){
			WritableWorkbook wb = null;
			WritableSheet sheet = null;

			try
			{
				wb = XLSUtil.loadWorkbookForWrite(f);
				sheet = XLSUtil.createNewPage(wb, "Random co-positioning");
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}

			if(nbPositivePvalues.length>1){
				String title = seq1.getName()+"_channel"+ch1+" and "+seq2.getName()+"_channel"+ch2;
				XLSUtil.setCellString(sheet, 0, 0, title);
				XLSUtil.setCellString(sheet, 0, 1, "Time");
				XLSUtil.setCellString(sheet, 1, 1, "Proportion of tests with colocalization");
				XLSUtil.setCellString(sheet, 2, 1, "Proportion of tests with anti-colocalization");
				for(int i=0;i<nbPositivePvalues.length;i++){
					XLSUtil.setCellNumber(sheet, 0, i+2, i);
					XLSUtil.setCellNumber(sheet, 1, i+2, (float)nbPositivePvalues[i]/(float)nbRandomizations);
					XLSUtil.setCellNumber(sheet, 2, i+2, (float)nbNegativePvalues[i]/(float)nbRandomizations);
				}
			}
			else{
				String title = seq1.getName()+"_channel"+ch1+" and "+seq2.getName()+"_channel"+ch2;
				XLSUtil.setCellString(sheet, 0, 0, title);
				XLSUtil.setCellString(sheet, 0, 1, "Proportion of tests with colocalization");
				XLSUtil.setCellString(sheet, 1, 1, "Proportion of tests with anti-colocalization");
				XLSUtil.setCellNumber(sheet, 0, 2, (float)nbPositivePvalues[0]/(float)nbRandomizations);
				XLSUtil.setCellNumber(sheet, 1, 2, (float)nbNegativePvalues[0]/(float)nbRandomizations);
			}

			try
			{
				XLSUtil.saveAndClose(wb);
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}
		}
		else{
			WritableWorkbook wb = null;
			WritableSheet sheet = null;

			try
			{
				wb = XLSUtil.createWorkbook(f);
				sheet = XLSUtil.createNewPage(wb, "Random co-positioning");
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}

			if(nbPositivePvalues.length>1){
				String title = seq1.getName()+"_channel"+ch1+" and "+seq2.getName()+"_channel"+ch2;
				XLSUtil.setCellString(sheet, 0, 0, title);
				XLSUtil.setCellString(sheet, 0, 1, "Time");
				XLSUtil.setCellString(sheet, 1, 1, "Proportion of tests with colocalization");
				XLSUtil.setCellString(sheet, 2, 1, "Proportion of tests with anti-colocalization");
				for(int i=0;i<nbPositivePvalues.length;i++){
					XLSUtil.setCellNumber(sheet, 0, i+2, i);
					XLSUtil.setCellNumber(sheet, 1, i+2, (float)nbPositivePvalues[i]/(float)nbRandomizations);
					XLSUtil.setCellNumber(sheet, 2, i+2, (float)nbNegativePvalues[i]/(float)nbRandomizations);
				}
			}
			else{
				String title = seq1.getName()+"_channel"+ch1+" and "+seq2.getName()+"_channel"+ch2;
				XLSUtil.setCellString(sheet, 0, 0, title);
				XLSUtil.setCellString(sheet, 0, 1, "Proportion of tests with colocalization");
				XLSUtil.setCellString(sheet, 1, 1, "Proportion of tests with anti-colocalization");
				XLSUtil.setCellNumber(sheet, 0, 2, (float)nbPositivePvalues[0]/(float)nbRandomizations);
				XLSUtil.setCellNumber(sheet, 1, 2, (float)nbNegativePvalues[0]/(float)nbRandomizations);
			}

			try
			{
				XLSUtil.saveAndClose(wb);
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}
		}
	}

	// export temporal interaction profile
	void exportTemporalInteractionProfile(float[] testStatistic,File f,Sequence seq1,int ch1,Sequence seq2,int ch2,int nbShifts,int nbTimes){
		if(f.exists()){
			WritableWorkbook wb = null;
			WritableSheet sheet = null;

			try
			{
				wb = XLSUtil.loadWorkbookForWrite(f);
				sheet = XLSUtil.createNewPage(wb, "Temporal interaction");
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}

			String title = seq1.getName()+"_channel"+ch1+" and "+seq2.getName()+"_channel"+ch2;
			XLSUtil.setCellString(sheet, 0, 0, title);
			for(int i=0;i<nbTimes;i++){
				String firstColumn = "Frame = "+i;
				XLSUtil.setCellString(sheet, 0, i+2, firstColumn);
			}
			for(int shift=0;shift<nbShifts;shift++){
				String firstRow = "Shift = "+(shift-(nbShifts-1)/2);
				XLSUtil.setCellString(sheet, shift+1, 1, firstRow);
				for(int i=0;i<nbTimes;i++){
					XLSUtil.setCellNumber(sheet, shift+1, i+2, testStatistic[shift*nbTimes+i]);
				}
			}

			try
			{
				XLSUtil.saveAndClose(wb);
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}
		}
		else{
			WritableWorkbook wb = null;
			WritableSheet sheet = null;

			try
			{
				wb = XLSUtil.createWorkbook(f);
				sheet = XLSUtil.createNewPage(wb, "Temporal interactions");
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}

			String title = seq1.getName()+"_channel"+ch1+" and "+seq2.getName()+"_channel"+ch2;
			XLSUtil.setCellString(sheet, 0, 0, title);
			for(int i=0;i<nbTimes;i++){
				String firstColumn = "Frame = "+i;
				XLSUtil.setCellString(sheet, 0, i+2, firstColumn);
			}
			for(int shift=0;shift<nbShifts;shift++){
				String firstRow = "Shift = "+(shift-(nbShifts-1)/2);
				XLSUtil.setCellString(sheet, shift+1, 1, firstRow);
				for(int i=0;i<nbTimes;i++){
					XLSUtil.setCellNumber(sheet, shift+1, i+2, testStatistic[shift*nbTimes+i]);
				}
			}

			try
			{
				XLSUtil.saveAndClose(wb);
			}
			catch (Exception e)
			{
				throw new IcyHandledException(e.getMessage());
			}
		}
	}


	// draw white circles on an image
	void drawWhiteCircle(float[][][] colocalizationHits,int x,int y,int z,int t,int width,int height){
		int xM4=x-4,xM3=x-3,xM2=x-2,xM1=x-1,xP1=x+1,xP2=x+2,xP3=x+3,xP4=x+4,yM4=y-4,yM3=y-3,yM2=y-2,yM1=y-1,yP1=y+1,yP2=y+2,yP3=y+3,yP4=y+4;
		if(xM4>=0){
			colocalizationHits[t*3][z][y*width+xM4] =  255;
			colocalizationHits[t*3+1][z][y*width+xM4] =  255;
			colocalizationHits[t*3+2][z][y*width+xM4] =  255;}
		if((xM4>=0)&&(yM1>=0)){
			colocalizationHits[t*3][z][yM1*width+xM4] =  255;
			colocalizationHits[t*3+1][z][yM1*width+xM4] =  255;
			colocalizationHits[t*3+2][z][yM1*width+xM4] =  255;}
		if((xM3>=0)&&(yM2>=0)){
			colocalizationHits[t*3][z][yM2*width+xM3] =  255;
			colocalizationHits[t*3+1][z][yM2*width+xM3] =  255;
			colocalizationHits[t*3+2][z][yM2*width+xM3] =  255;}
		if((xM3>=0)&&(yM3>=0)){
			colocalizationHits[t*3][z][yM3*width+xM3] =  255;
			colocalizationHits[t*3+1][z][yM3*width+xM3] =  255;
			colocalizationHits[t*3+2][z][yM3*width+xM3] =  255;}
		if((xM2>=0)&&(yM3>=0)){
			colocalizationHits[t*3][z][yM3*width+xM2] =  255;
			colocalizationHits[t*3+1][z][yM3*width+xM2] =  255;
			colocalizationHits[t*3+2][z][yM3*width+xM2] =  255;}
		if((xM1>=0)&&(yM4>=0)){
			colocalizationHits[t*3][z][yM4*width+xM1] =  255;
			colocalizationHits[t*3+1][z][yM4*width+xM1] =  255;
			colocalizationHits[t*3+2][z][yM4*width+xM1] =  255;}
		if(yM4>=0){
			colocalizationHits[t*3][z][yM4*width+x] =  255;
			colocalizationHits[t*3+1][z][yM4*width+x] =  255;
			colocalizationHits[t*3+2][z][yM4*width+x] =  255;}
		if((xP1<(width-1))&&(yM4>=0)){
			colocalizationHits[t*3][z][yM4*width+xP1] =  255;
			colocalizationHits[t*3+1][z][yM4*width+xP1] =  255;
			colocalizationHits[t*3+2][z][yM4*width+xP1] =  255;}
		if((xP2<(width-1))&&(yM3>=0)){
			colocalizationHits[t*3][z][yM3*width+xP2] =  255;
			colocalizationHits[t*3+1][z][yM3*width+xP2] =  255;
			colocalizationHits[t*3+2][z][yM3*width+xP2] =  255;}
		if((xP3<(width-1))&&(yM3>=0)){
			colocalizationHits[t*3][z][yM3*width+xP3] =  255;
			colocalizationHits[t*3+1][z][yM3*width+xP3] =  255;
			colocalizationHits[t*3+2][z][yM3*width+xP3] =  255;}
		if((xP3<(width-1))&&(yM2>=0)){
			colocalizationHits[t*3][z][yM2*width+xP3] =  255;
			colocalizationHits[t*3+1][z][yM2*width+xP3] =  255;
			colocalizationHits[t*3+2][z][yM2*width+xP3] =  255;}
		if((xP4<(width-1))&&(yM1>=0)){
			colocalizationHits[t*3][z][yM1*width+xP4] =  255;
			colocalizationHits[t*3+1][z][yM1*width+xP4] =  255;
			colocalizationHits[t*3+2][z][yM1*width+xP4] =  255;}
		if(xP4<(width-1)){
			colocalizationHits[t*3][z][y*width+xP4] =  255;
			colocalizationHits[t*3+1][z][y*width+xP4] =  255;
			colocalizationHits[t*3+2][z][y*width+xP4] =  255;}
		if((xM4>=0)&&(yP1<(height))){
			colocalizationHits[t*3][z][yP1*width+xM4] =  255;
			colocalizationHits[t*3+1][z][yP1*width+xM4] =  255;
			colocalizationHits[t*3+2][z][yP1*width+xM4] =  255;}
		if((xM3>=0)&&(yP2<(height))){
			colocalizationHits[t*3][z][yP2*width+xM3] =  255;
			colocalizationHits[t*3+1][z][yP2*width+xM3] =  255;
			colocalizationHits[t*3+2][z][yP2*width+xM3] =  255;}
		if((xM3>=0)&&(yP3<(height))){
			colocalizationHits[t*3][z][yP3*width+xM3] =  255;
			colocalizationHits[t*3+1][z][yP3*width+xM3] =  255;
			colocalizationHits[t*3+2][z][yP3*width+xM3] =  255;}
		if((xM2>=0)&&(yP3<(height))){
			colocalizationHits[t*3][z][yP3*width+xM2] =  255;
			colocalizationHits[t*3+1][z][yP3*width+xM2] =  255;
			colocalizationHits[t*3+2][z][yP3*width+xM2] =  255;}
		if((xM1>=0)&&(yP4<(height))){
			colocalizationHits[t*3][z][yP4*width+xM1] =  255;
			colocalizationHits[t*3+1][z][yP4*width+xM1] =  255;
			colocalizationHits[t*3+2][z][yP4*width+xM1] =  255;}
		if(yM4>=0){
			colocalizationHits[t*3][z][yP4*width+x] =  255;
			colocalizationHits[t*3+1][z][yP4*width+x] =  255;
			colocalizationHits[t*3+2][z][yP4*width+x] =  255;}
		if((xP1<(width-1))&&(yP4<(height))){
			colocalizationHits[t*3][z][yP4*width+xP1] =  255;
			colocalizationHits[t*3+1][z][yP4*width+xP1] =  255;
			colocalizationHits[t*3+2][z][yP4*width+xP1] =  255;}
		if((xP2<(width-1))&&(yP3<(height))){
			colocalizationHits[t*3][z][yP3*width+xP2] =  255;
			colocalizationHits[t*3+1][z][yP3*width+xP2] =  255;
			colocalizationHits[t*3+2][z][yP3*width+xP2] =  255;}
		if((xP3<(width-1))&&(yP3<(height))){
			colocalizationHits[t*3][z][yP3*width+xP3] =  255;
			colocalizationHits[t*3+1][z][yP3*width+xP3] =  255;
			colocalizationHits[t*3+2][z][yP3*width+xP3] =  255;}
		if((xP3<(width-1))&&(yP2<(height))){
			colocalizationHits[t*3][z][yP2*width+xP3] =  255;
			colocalizationHits[t*3+1][z][yP2*width+xP3] =  255;
			colocalizationHits[t*3+2][z][yP2*width+xP3] =  255;}
		if((xP4<(width-1))&&(yP1<(height))){
			colocalizationHits[t*3][z][yP1*width+xP4] =  255;
			colocalizationHits[t*3+1][z][yP1*width+xP4] =  255;
			colocalizationHits[t*3+2][z][yP1*width+xP4] =  255;}
	}

	// draw blue circles on an image
	void drawBlueCircle(float[][][] colocalizationHits,int x,int y,int z,int t,int width,int height){
		int xM4=x-4,xM3=x-3,xM2=x-2,xM1=x-1,xP1=x+1,xP2=x+2,xP3=x+3,xP4=x+4,yM4=y-4,yM3=y-3,yM2=y-2,yM1=y-1,yP1=y+1,yP2=y+2,yP3=y+3,yP4=y+4;
		if(xM4>=0){
			colocalizationHits[t*3+2][z][y*width+xM4] =  255;}
		if((xM4>=0)&&(yM1>=0)){
			colocalizationHits[t*3+2][z][yM1*width+xM4] =  255;}
		if((xM3>=0)&&(yM2>=0)){
			colocalizationHits[t*3+2][z][yM2*width+xM3] =  255;}
		if((xM3>=0)&&(yM3>=0)){
			colocalizationHits[t*3+2][z][yM3*width+xM3] =  255;}
		if((xM2>=0)&&(yM3>=0)){
			colocalizationHits[t*3+2][z][yM3*width+xM2] =  255;}
		if((xM1>=0)&&(yM4>=0)){
			colocalizationHits[t*3+2][z][yM4*width+xM1] =  255;}
		if(yM4>=0){
			colocalizationHits[t*3+2][z][yM4*width+x] =  255;}
		if((xP1<(width-1))&&(yM4>=0)){
			colocalizationHits[t*3+2][z][yM4*width+xP1] =  255;}
		if((xP2<(width-1))&&(yM3>=0)){
			colocalizationHits[t*3+2][z][yM3*width+xP2] =  255;}
		if((xP3<(width-1))&&(yM3>=0)){
			colocalizationHits[t*3+2][z][yM3*width+xP3] =  255;}
		if((xP3<(width-1))&&(yM2>=0)){
			colocalizationHits[t*3+2][z][yM2*width+xP3] =  255;}
		if((xP4<(width-1))&&(yM1>=0)){
			colocalizationHits[t*3+2][z][yM1*width+xP4] =  255;}
		if(xP4<(width-1)){
			colocalizationHits[t*3+2][z][y*width+xP4] =  255;}
		if((xM4>=0)&&(yP1<(height))){
			colocalizationHits[t*3+2][z][yP1*width+xM4] =  255;}
		if((xM3>=0)&&(yP2<(height))){
			colocalizationHits[t*3+2][z][yP2*width+xM3] =  255;}
		if((xM3>=0)&&(yP3<(height))){
			colocalizationHits[t*3+2][z][yP3*width+xM3] =  255;}
		if((xM2>=0)&&(yP3<(height))){
			colocalizationHits[t*3+2][z][yP3*width+xM2] =  255;}
		if((xM1>=0)&&(yP4<(height))){
			colocalizationHits[t*3+2][z][yP4*width+xM1] =  255;}
		if(yM4>=0){
			colocalizationHits[t*3+2][z][yP4*width+x] =  255;}
		if((xP1<(width-1))&&(yP4<(height))){
			colocalizationHits[t*3+2][z][yP4*width+xP1] =  255;}
		if((xP2<(width-1))&&(yP3<(height))){
			colocalizationHits[t*3+2][z][yP3*width+xP2] =  255;}
		if((xP3<(width-1))&&(yP3<(height))){
			colocalizationHits[t*3+2][z][yP3*width+xP3] =  255;}
		if((xP3<(width-1))&&(yP2<(height))){
			colocalizationHits[t*3+2][z][yP2*width+xP3] =  255;}
		if((xP4<(width-1))&&(yP1<(height))){
			colocalizationHits[t*3+2][z][yP1*width+xP4] =  255;}
	}

	void visualizeImage(float[][][] input,int width,int height,int depth,int currentFrame,String name){
		Sequence test = new Sequence(name);
		test.beginUpdate();
		try{
			for(int z=0;z<depth;z++){
				IcyBufferedImage outputImage = new IcyBufferedImage(width,height,1,DataType.FLOAT);
				float[] outputData = outputImage.getDataXYAsFloat(0);
				for(int i=0;i<width*height;i++){
					outputData[i] = input[currentFrame][z][i];
				}
				outputImage.dataChanged();
				test.setImage(currentFrame, z, outputImage);
			}
		}
		finally{
			test.endUpdate();
		}
		addSequence(test);
	}

	void visualizeImage(int[][][] input,int width,int height,int depth,int currentFrame,String name){
		Sequence test = new Sequence(name);
		test.beginUpdate();
		try{
			for(int z=0;z<depth;z++){
				IcyBufferedImage outputImage = new IcyBufferedImage(width,height,1,DataType.INT);
				int[] outputData = outputImage.getDataXYAsInt(0);
				for(int i=0;i<width*height;i++){
					outputData[i] = input[currentFrame][z][i];
				}
				outputImage.dataChanged();
				test.setImage(currentFrame, z, outputImage);
			}
		}
		finally{
			test.endUpdate();
		}
		addSequence(test);
	}

	void visualizeImage(double[][] input,int width,int height,String name){
		Sequence test = new Sequence(name);
		test.beginUpdate();
		try{
			IcyBufferedImage outputImage = new IcyBufferedImage(width,height,1,DataType.DOUBLE);
			double[] outputData = outputImage.getDataXYAsDouble(0);
			int i=0;
			for(int y=0;y<height;y++){
				for(int x=0;x<width;x++){
					outputData[y*width+x] = input[x][y];
					i++;
				}
			}
			outputImage.dataChanged();
			test.setImage(0,0,outputImage);
		}
		finally{
			test.endUpdate();
		}
		addSequence(test);
	}

	void visualizeImage(float[][] input,int width,int height,int depth,int currentFrame,String name){
		Sequence test = new Sequence(name);
		test.beginUpdate();
		try{
			for(int z=0;z<depth;z++){
				IcyBufferedImage outputImage = new IcyBufferedImage(width,height,1,DataType.FLOAT);
				float[] outputData = outputImage.getDataXYAsFloat(0);
				for(int i=0;i<width*height;i++){
					outputData[i] = input[z][i];
				}
				outputImage.dataChanged();
				test.setImage(currentFrame, z, outputImage);
			}
		}
		finally{
			test.endUpdate();
		}
		addSequence(test);
	}

	void visualizeImage(float[] input,int width,int height,String name){
		Sequence test = new Sequence(name);
		test.beginUpdate();
		try{
			IcyBufferedImage outputImage = new IcyBufferedImage(width,height,1,DataType.FLOAT);
			float[] outputData = outputImage.getDataXYAsFloat(0);
			for(int i=0;i<width*height;i++){
				outputData[i] = input[i];
			}
			outputImage.dataChanged();
			test.setImage(0, 0, outputImage);
		}
		finally{
			test.endUpdate();
		}
		addSequence(test);
	}

	void visualizeImage(int[][] input,int width,int height,int depth,int currentFrame,String name){
		Sequence test = new Sequence(name);
		test.beginUpdate();
		try{
			for(int z=0;z<depth;z++){
				IcyBufferedImage outputImage = new IcyBufferedImage(width,height,1,DataType.INT);
				int[] outputData = outputImage.getDataXYAsInt(0);
				for(int i=0;i<width*height;i++){
					outputData[i] = input[z][i];
				}
				outputImage.dataChanged();
				test.setImage(currentFrame, z, outputImage);
			}
		}
		finally{
			test.endUpdate();
		}
		addSequence(test);
	}

	void visualizeSequence(float[][][] input,int width,int height,int depth,int nbFrames,String name){
		Sequence test = new Sequence(name);
		test.beginUpdate();
		try{
			for(int t=0;t<nbFrames;t++){
				for(int z=0;z<depth;z++){
					IcyBufferedImage outputImage = new IcyBufferedImage(width,height,1,DataType.FLOAT);
					float[] outputData = outputImage.getDataXYAsFloat(0);
					for(int i=0;i<width*height;i++){
						outputData[i] = input[t][z][i];
					}
					outputImage.dataChanged();
					test.setImage(t, z, outputImage);
				}
			}
		}
		finally{
			test.endUpdate();
		}
		addSequence(test);
	}
	
	Sequence getSequence(float[][][] input,int width,int height,int depth,int nbFrames,String name){
		Sequence test = new Sequence(name);
		test.beginUpdate();
		try{
			for(int t=0;t<nbFrames;t++){
				for(int z=0;z<depth;z++){
					IcyBufferedImage outputImage = new IcyBufferedImage(width,height,1,DataType.FLOAT);
					float[] outputData = outputImage.getDataXYAsFloat(0);
					for(int i=0;i<width*height;i++){
						outputData[i] = input[t][z][i];
					}
					outputImage.dataChanged();
					test.setImage(t, z, outputImage);
				}
			}
		}
		finally{
			test.endUpdate();
		}
		return test;
	}

	void visualizeSequence(float[][][] input,int width,int height,int depth,int spectrum,int nbFrames,String name){
		Sequence test = new Sequence(name);
		test.beginUpdate();
		try{
			for(int t=0;t<nbFrames;t++){
				for(int z=0;z<depth;z++){
					IcyBufferedImage outputImage = new IcyBufferedImage(width,height,3,DataType.FLOAT);
					float[][] outputData = outputImage.getDataXYCAsFloat();
					for(int c=0;c<spectrum;c++){
						for(int i=0;i<width*height;i++){
							outputData[c][i] = input[t*spectrum+c][z][i];
						}
					}
					outputImage.dataChanged();
					test.setImage(t, z, outputImage);
				}
			}
		}
		finally{
			test.endUpdate();
		}
		addSequence(test);
	}

	void visualizeSequence(int[][][] input,int width,int height,int depth,int nbFrames,String name){
		Sequence test = new Sequence(name);
		test.beginUpdate();
		try{
			for(int t=0;t<nbFrames;t++){
				for(int z=0;z<depth;z++){
					IcyBufferedImage outputImage = new IcyBufferedImage(width,height,1,DataType.INT);
					int[] outputData = outputImage.getDataXYAsInt(0);
					for(int i=0;i<width*height;i++){
						outputData[i] = input[t][z][i];
					}
					outputImage.dataChanged();
					test.setImage(t, z, outputImage);
				}
			}
		}
		finally{
			test.endUpdate();
		}
		addSequence(test);
	}

	void visualizeLine(double[] input,int nbComponents,String name){
		Sequence test = new Sequence(name);
		test.beginUpdate();
		try{
			IcyBufferedImage outputImage = new IcyBufferedImage(nbComponents,1,1,DataType.DOUBLE);
			double[] outputData = outputImage.getDataXYAsDouble(0);
			for(int i=0;i<nbComponents;i++){
				outputData[i] = input[i];
			}
			outputImage.dataChanged();
			test.setImage(0, 0, outputImage);
		}
		finally{
			test.endUpdate();
		}
		addSequence(test);
	}

	@Override
	protected void initialize()
	{
		String[] modePossibilities = {"Statistical test","Random geo-copositioning","Dense geo-copositioning","Temporal interaction profile"};
		mode = new EzVarText("Mode for GcoPS",modePossibilities,false);
		EzLabel modeLabel = new EzLabel("You can choose to compute a statistical test that outputs a p-value and a colocalization score, a random geo-copositioning (resp. dense co-positioning) that identifies locations of colocalization in the image (resp. outputs a dense map for colocalization) or compute a temporal interaction profile corresponding to the colocalization score when frames are shifted");
		input1 = new EzVarSequence("Input image 1");
		EzLabel input1Label = new EzLabel("The image data corresponds to one of the channels for which you want to analyze colocalization");
		channel1 = new EzVarInteger("Channel in input image 1 used for analysis",0,5,1);
		input2 = new EzVarSequence("Input image for second channel");
		EzLabel input2Label = new EzLabel("The image data corresponds to the other channel for which you want to analyze colocalization");
		channel2 = new EzVarInteger("Channel in input image 2 used for analysis",0,5,1);
		cellMask = new EzVarSequence("Cell mask");
		EzLabel cellMaskLabel = new EzLabel("The cell mask enables to analyze colocalization only on the cell (intensity superior to 0 in the cell and equal to 0 outside the cell). This input is optional.");
		cellMask.setNoSequenceSelection();
		exportExcelFileStatisticalTest = new EzVarFile("Output xls file for statistical test", "");
		EzLabel exportExcelFileStatisticalTestLabel = new EzLabel("File to export p-value(s) and colocalization level(s)");
		exportExcelFileRandomization = new EzVarFile("Output xls file for randomization study", "");
		EzLabel exportExcelFileRandomizationLabel = new EzLabel("File to export proportion of tests with hits of colocalization and anti-colocalization");
		randomizationWindowWidth = new EzVarInteger("Window width for random geo-copositioning",50,10,500,5);
		EzLabel randomizationWindowWidthLabel = new EzLabel("Width of the window used to compute random geo-copositioning");
		randomizationWindowHeight = new EzVarInteger("Window height for random geo-copositioning",50,10,500,5);
		EzLabel randomizationWindowHeightLabel = new EzLabel("Height of the window used to compute random geo-copositioning");
		randomizationWindowDepth = new EzVarInteger("Window depth for random geo-copositioning",15,3,500,1);
		EzLabel randomizationWindowDepthLabel = new EzLabel("Depth of the window used to compute random densegeo-copositioning");
		String[] randomizationProportionPossibilities = {"Very high number of tests","High number of tests","Moderate number of tests","Small number of tests"};
		randomizationProportion = new EzVarText("Number of tests",randomizationProportionPossibilities,1,false);
		EzLabel proportionLabel = new EzLabel("Number of randomly picked points for colocalization test");
		denseWindowWidth = new EzVarInteger("Window width for dense geo-copositioning",50,10,500,5);
		EzLabel denseWindowWidthLabel = new EzLabel("Width of the window used to compute dense geo-copositioning");
		denseWindowHeight = new EzVarInteger("Window height for dense geo-copositioning",50,10,500,5);
		EzLabel denseWindowHeightLabel = new EzLabel("Height of the window used to compute dense geo-copositioning");
		denseWindowDepth = new EzVarInteger("Window depth for dense geo-copositioning",15,3,500,1);
		EzLabel denseWindowDepthLabel = new EzLabel("Depth of the window used to compute dense geo-copositioning");
		maxShift = new EzVarInteger("Maximum shift between the two channels", 20, 5, 100, 1);
		exportExcelFileTemporalProfile = new EzVarFile("Output xls file for temporal interaction profile", "");
		EzLabel exportExcelFileTemporalProfileLabel = new EzLabel("File to export colocalization score when considering a range of shifts between channels");

		EzGroup modeChoice = new EzGroup("Mode for GcoPS", mode);
		super.addEzComponent(modeChoice);

		EzGroup input = new EzGroup("Input Images", input1, channel1, input2, channel2, cellMask);
		super.addEzComponent(input);

		EzGroup randomWindowDimension = new EzGroup("Windows size", randomizationProportion, randomizationWindowWidth, randomizationWindowHeight, randomizationWindowDepth);
		super.addEzComponent(randomWindowDimension);
		mode.addVisibilityTriggerTo(randomWindowDimension, "Random geo-copositioning");

		EzGroup denseWindowDimension = new EzGroup("Windows size", denseWindowWidth, denseWindowHeight, denseWindowDepth);
		super.addEzComponent(denseWindowDimension);
		mode.addVisibilityTriggerTo(denseWindowDimension, "Dense geo-copositioning");

		EzGroup outputStatisticalTest = new EzGroup("Output", exportExcelFileStatisticalTest);
		super.addEzComponent(outputStatisticalTest);
		mode.addVisibilityTriggerTo(outputStatisticalTest, "Statistical test");

		EzGroup outputRandomization = new EzGroup("Output", exportExcelFileRandomization);
		super.addEzComponent(outputRandomization);
		mode.addVisibilityTriggerTo(outputRandomization, "Random geo-copositioning");

		EzGroup shift = new EzGroup("Shift", maxShift);
		super.addEzComponent(shift);
		mode.addVisibilityTriggerTo(shift, "Temporal interaction profile");
		EzGroup outputTemporalProfile = new EzGroup("Output", exportExcelFileTemporalProfile);
		super.addEzComponent(outputTemporalProfile);
		mode.addVisibilityTriggerTo(outputTemporalProfile, "Temporal interaction profile");

		// parameters for progress bar
		Semaphore preprocessingSemaphore = new Semaphore();
		boolean stopRunningBgProcess=false;
	}

	@Override
	public void execute() {

		// get sequence chosen by the user
		final Sequence inputImage1 = input1.getValue(),inputImage2 = input2.getValue();
		final Sequence cellMaskImage = cellMask.getValue();

		// test on input image
		if((inputImage1==null)||(inputImage2==null)){MessageDialog.showDialog("This plugin needs two input images or sequences, or one input image or sequence with several channels");return;}

		// test on input images
		if((inputImage1.getSizeX()!=inputImage2.getSizeX())||(inputImage1.getSizeY()!=inputImage2.getSizeY())||(inputImage1.getSizeZ()!=inputImage2.getSizeZ())||(inputImage1.getSizeT()!=inputImage2.getSizeT())){
			MessageDialog.showDialog("The input images must have the same dimension");return;}
		if(channel1.getValue()>(inputImage1.getSizeC()-1)){MessageDialog.showDialog("The channel in input image 1 is too large");return;}
		if(channel2.getValue()>(inputImage2.getSizeC()-1)){MessageDialog.showDialog("The channel in input image 2 is too large");return;}

		// input variables
		int arraySize=inputImage1.getSizeX()*inputImage1.getSizeY(),w=inputImage1.getSizeX(),h=inputImage1.getSizeY(),d=inputImage1.getSizeZ(),nbFrames=inputImage1.getSizeT();
		double truncationValue = 0.1;

		// tests on cell mask image
		if(cellMaskImage!=null){
			if((cellMaskImage.getSizeX()!=w)||(cellMaskImage.getSizeY()!=h)||(cellMaskImage.getSizeZ()!=d)){
				MessageDialog.showDialog("The cell mask image must have same XYZ dimensions than input image");return;}
		}

		// cell mask
		int[][] cellMask = new int[d][arraySize];
		int nbCellMaskPts=0;
		if(cellMaskImage==null){
			for(int z=0;z<d;z++){
				for(int i=0;i<arraySize;i++){
					cellMask[z][i] = 1;
					nbCellMaskPts++;
				}
			}
		}
		else{
			cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(0,0), cellMaskImage.isSignedDataType());
			for(int z=0;z<d;z++){
				for(int y=0;y<h;y++){
					for(int x=0;x<w;x++){
						if(cellMask[z][y*w+x]>0){
							cellMask[z][y*w+x] = 1;
							nbCellMaskPts++;
						}
					}
				}
			}
		}

		// statistical test
		if(mode.getValue()=="Statistical test"){
			// time computation
			//long startTime = System.currentTimeMillis();
			
			// test on output xls files
			if(exportExcelFileStatisticalTest.getValue(false)==null){
				MessageDialog.showDialog("You need to specify the output xls file");
				return;
			}

			if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
			super.getUI().setProgressBarMessage("Processing data");
			processingSemaphore.init(0, nbFrames);
			super.getUI().setProgressBarValue(processingSemaphore.getProgress());
			Thread.yield();

			// output
			float[] testStatistic = new float[nbFrames],pvalues = new float[nbFrames],correlation = new float[nbFrames];

			if(d==1){

				// statistical test estimation over time
				for(int t=0;t<nbFrames;t++){
					// progress bar and stop button
					if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
					processingSemaphore.progress();
					super.getUI().setProgressBarValue(processingSemaphore.getProgress());
					Thread.yield();

					// input data
					float[] inputData1 = Array1DUtil.arrayToFloatArray(inputImage1.getDataXY(t, 0, channel1.getValue()), inputImage1.isSignedDataType()),
							inputData2 = Array1DUtil.arrayToFloatArray(inputImage2.getDataXY(t, 0, channel2.getValue()), inputImage2.isSignedDataType());
					float[] input1Tmp = new float[arraySize],input2Tmp = new float[arraySize];

					// cell mask
					if(cellMaskImage!=null){
						if(cellMaskImage.getSizeT()>1){
							cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t,0), cellMaskImage.isSignedDataType());
							for(int y=0;y<h;y++){
								for(int x=0;x<w;x++){
									if(cellMask[0][y*w+x]>0){
										cellMask[0][y*w+x] = 1;
									}
								}
							}
						}
					}

					// data test and probas
					float[] intersection = new float[arraySize];
					float input1TmpSum=0,input2TmpSum=0,cellMaskSum=0,intersectionSum=0;
					for(int i=0;i<arraySize;i++){
						input1Tmp[i] = inputData1[i]*cellMask[0][i];
						if(input1Tmp[i]>0){input1Tmp[i] = 1;}
						input2Tmp[i] = inputData2[i]*cellMask[0][i];
						if(input2Tmp[i]>0){input2Tmp[i] = 1;}
						intersection[i] = input1Tmp[i]*input2Tmp[i];
						intersectionSum += intersection[i];
						input1TmpSum += input1Tmp[i];
						input2TmpSum += input2Tmp[i];
						cellMaskSum += (float)cellMask[0][i];
					}
					float p1=input1TmpSum/cellMaskSum,p2=input2TmpSum/cellMaskSum,p12=intersectionSum/cellMaskSum;

					// autocorrelation computation
					float[] autocorrelation1 = new float[(2*w+1)*(2*h+1)],autocorrelation2 = new float[(2*w+1)*(2*h+1)];
					autocorrelation1 = fftAutoCorrelation(input1Tmp,w,h);
					autocorrelation2 = fftAutoCorrelation(input2Tmp,w,h);

					// centering covariances
					for(int i=0;i<arraySize;i++){
						autocorrelation1[i] -= Math.pow(p1, 2);
						autocorrelation2[i] -= Math.pow(p2, 2);
					}

					// remove coefficients corresponding to noise
					int radiusForTruncation=0;
					radiusForTruncation = radiusTruncation(autocorrelation1,autocorrelation2,truncationValue,2*w+1,2*h+1);

					// S1 computation
					float denominator = computeTruncatedS1(autocorrelation1,autocorrelation2,w,h,radiusForTruncation);
					// stat test S1
					testStatistic[t] = (p12-p1*p2)/(float)Math.sqrt((double)denominator);
					// normalized correlation
					correlation[t] = (p12-p1*p2)/(float)Math.sqrt(p1*(1.-p1)*p2*(1.-p2));
					// one-sided p-values S1
					if(correlation[t]>0){
						pvalues[t] = (1-CND(testStatistic[t]));
					}
					else{
						pvalues[t] = (1-CND(Math.abs(testStatistic[t])));
					}
				}
				File f = exportExcelFileStatisticalTest.getValue();
				if (!FileUtil.getFileExtension(f.getPath(), false).equalsIgnoreCase("xls")) f = new File(f.getPath() + ".xls");
				exportPvalues(pvalues,testStatistic,correlation,f,inputImage1,channel1.getValue(),inputImage2,channel2.getValue());
			}	
			else{
				// statistical test estimation over time
				for(int t=0;t<nbFrames;t++){
					// progress bar and stop button
					if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
					processingSemaphore.progress();
					super.getUI().setProgressBarValue(processingSemaphore.getProgress());
					Thread.yield();

					// input data
					float[][] inputData1 = Array2DUtil.arrayToFloatArray(inputImage1.getDataXYZ(t, channel1.getValue()), inputImage1.isSignedDataType()),
							inputData2 = Array2DUtil.arrayToFloatArray(inputImage2.getDataXYZ(t, channel2.getValue()), inputImage2.isSignedDataType());
					float[][] input1Tmp = new float[d][arraySize],input2Tmp = new float[d][arraySize];

					// cell mask
					if(cellMaskImage!=null){
						if(cellMaskImage.getSizeT()>1){
							cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t,0), cellMaskImage.isSignedDataType());
							for(int z=0;z<d;z++){
								for(int y=0;y<h;y++){
									for(int x=0;x<w;x++){
										if(cellMask[z][y*w+x]>0){
											cellMask[z][y*w+x] = 1;
										}
									}
								}
							}
						}
					}

					// data test and probas
					float[][] intersection = new float[d][arraySize];
					float input1TmpSum=0,input2TmpSum=0,cellMaskSum=0,intersectionSum=0;
					for(int z=0;z<d;z++){
						for(int i=0;i<arraySize;i++){
							input1Tmp[z][i] = inputData1[z][i]*cellMask[z][i];
							if(input1Tmp[z][i]>0){input1Tmp[z][i] = 1;}
							input2Tmp[z][i] = inputData2[z][i]*cellMask[z][i];
							if(input2Tmp[z][i]>0){input2Tmp[z][i] = 1;}
							intersection[z][i] = input1Tmp[z][i]*input2Tmp[z][i];
							intersectionSum += intersection[z][i];
							input1TmpSum += input1Tmp[z][i];
							input2TmpSum += input2Tmp[z][i];
							cellMaskSum += (float)cellMask[z][i];
						}
					}
					float p1=input1TmpSum/cellMaskSum,p2=input2TmpSum/cellMaskSum,p12=intersectionSum/cellMaskSum;
					
					// autocorrelation computation
					float[][] autocorrelation1 = new float[2*d+1][(2*w+1)*(2*h+1)],autocorrelation2 = new float[2*d+1][(2*w+1)*(2*h+1)];
					autocorrelation1 = fftAutoCorrelation(input1Tmp,w,h,d);
					autocorrelation2 = fftAutoCorrelation(input2Tmp,w,h,d);

					// centering covariances
					for(int z=0;z<d;z++){
						for(int i=0;i<arraySize;i++){
							autocorrelation1[z][i] -= Math.pow(p1, 2);
							autocorrelation2[z][i] -= Math.pow(p2, 2);
						}
					}

					// remove coefficients corresponding to noise
					int[] radiusForTruncation = new int[1],depthForTruncation = new int[1];
					radiusAndDepthTruncations(autocorrelation1,autocorrelation2,truncationValue,2*w+1,2*h+1,2*d+1,radiusForTruncation,depthForTruncation);

					// with truncation
					// S1 computation
					float denominator = computeTruncatedS1(autocorrelation1,autocorrelation2,w,h,d,radiusForTruncation[0],depthForTruncation[0]);
					// stat test S1
					testStatistic[t] = (p12-p1*p2)/(float)Math.sqrt((double)denominator);
					// normalized correlation
					correlation[t] = (p12-p1*p2)/(float)Math.sqrt(p1*(1.-p1)*p2*(1.-p2));
					// one-sided p-values S1
					if(correlation[t]>0){
						pvalues[t] = (1-CND(testStatistic[t]));
					}
					else{
						pvalues[t] = (1-CND(Math.abs(testStatistic[t])));
					}
				}
				File f = exportExcelFileStatisticalTest.getValue();
				if (!FileUtil.getFileExtension(f.getPath(), false).equalsIgnoreCase("xls")) f = new File(f.getPath() + ".xls");
				exportPvalues(pvalues,testStatistic,correlation,f,inputImage1,channel1.getValue(),inputImage2,channel2.getValue());
			}
			//long endTime = System.currentTimeMillis();
			//MessageDialog.showDialog("Computation time: "+(endTime-startTime));
		}
		else{
			if(mode.getValue()=="Random geo-copositioning"){
				// test on output xls files
				if(exportExcelFileRandomization.getValue(false)==null){
					MessageDialog.showDialog("You need to specify the output xls file");
					return;
				}

				// number of randomly picked points for colocalization test
				int nbRandomizations = nbCellMaskPts;
				if(d==1){
					if(randomizationProportion.getValue()=="Very high number of tests"){
						nbRandomizations /= 20;
					}
					if(randomizationProportion.getValue()=="High number of tests"){
						nbRandomizations /= 100;
					}
					if(randomizationProportion.getValue()=="Moderate number of tests"){
						nbRandomizations /= 500;
					}
					if(randomizationProportion.getValue()=="Small number of tests"){
						nbRandomizations /= 2000;
					}
				}
				else{
					if(randomizationProportion.getValue()=="Very high number of tests"){
						nbRandomizations /= 200;
					}
					if(randomizationProportion.getValue()=="High number of tests"){
						nbRandomizations /= 1000;
					}
					if(randomizationProportion.getValue()=="Moderate number of tests"){
						nbRandomizations /= 4000;
					}
					if(randomizationProportion.getValue()=="Small number of tests"){
						nbRandomizations /= 5000;
					}
				}

				// progress bar and stop button
				if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
				super.getUI().setProgressBarMessage("Processing data");
				processingSemaphore.init(0, nbFrames*nbRandomizations);
				super.getUI().setProgressBarValue(processingSemaphore.getProgress());
				Thread.yield();

				// parameters
				int rw = randomizationWindowWidth.getValue(),rh = randomizationWindowHeight.getValue(),rd = randomizationWindowDepth.getValue();
				if(rw>w/2){rw=w/2;}
				if(rh>h/2){rh=h/2;}
				if(rd>d/2){rd=d/2;}
				int[] nbPositiveTests = new int[nbFrames],nbNegativeTests = new int[nbFrames];

				// output image
				float[][][] colocalizationHits = new float[nbFrames*3][d][arraySize];

				if(d==1){

					// statistical test estimation over time
					for(int t=0;t<nbFrames;t++){

						// extract images at time t
						float[] inputData1 = Array1DUtil.arrayToFloatArray(inputImage1.getDataXY(t, 0, channel1.getValue()), inputImage1.isSignedDataType()),
								inputData2 = Array1DUtil.arrayToFloatArray(inputImage2.getDataXY(t, 0, channel2.getValue()), inputImage2.isSignedDataType());

						// output update
						float maxChannel1=0,maxChannel2=0;
						for(int i=0;i<arraySize;i++){
							if(inputData1[i]>maxChannel1){maxChannel1 = inputData1[i];}
							if(inputData2[i]>maxChannel2){maxChannel2 = inputData2[i];}
						}
						for(int i=0;i<arraySize;i++){
							colocalizationHits[t*3][0][i] = inputData1[i]*255/maxChannel1;
							colocalizationHits[t*3+1][0][i] = inputData2[i]*255/maxChannel2;
						}
						
						// cell mask
						if(cellMaskImage!=null){
							if(cellMaskImage.getSizeT()>1){
								cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t,0), cellMaskImage.isSignedDataType());
								for(int y=0;y<h;y++){
									for(int x=0;x<w;x++){
										if(cellMask[0][y*w+x]>0){
											cellMask[0][y*w+x] = 1;
										}
									}
								}
							}
						}

						// test over randomly picked points
						for(int k=0;k<nbRandomizations;k++){

							// generate random point
							double rand1,rand2;
							int rand1Shift=0,rand2Shift=0;
							boolean out=false;
							while(!out){
								rand1=Math.random();rand2=Math.random();
								rand1Shift=(int)(rand1*((double)w-(double)rw));
								rand2Shift=(int)(rand2*((double)h-(double)rh));
								if(cellMask[0][(rand2Shift+rh/2)*w+rand1Shift+rw/2]>0){out=true;}
							}

							// progress bar and stop button
							if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
							processingSemaphore.progress();
							super.getUI().setProgressBarValue(processingSemaphore.getProgress());
							Thread.yield();

							// extract windows, data test and probas
							float[] input1Tmp = new float[rw*rh],input2Tmp = new float[rw*rh],intersection = new float[rw*rh];
							float input1TmpSum=0,input2TmpSum=0,cellMaskSum=0,intersectionSum=0;
							for(int y=rand2Shift;y<(rh+rand2Shift);y++){
								for(int x=rand1Shift;x<(rw+rand1Shift);x++){
									if(cellMask[0][y*w+x]>0){
										if(inputData1[y*w+x]>0){input1Tmp[(y-rand2Shift)*rw+x-rand1Shift] = 1;}
										if(inputData2[y*w+x]>0){input2Tmp[(y-rand2Shift)*rw+x-rand1Shift] = 1;}
										intersection[(y-rand2Shift)*rw+x-rand1Shift] = input1Tmp[(y-rand2Shift)*rw+x-rand1Shift]*input2Tmp[(y-rand2Shift)*rw+x-rand1Shift];
										intersectionSum += intersection[(y-rand2Shift)*rw+x-rand1Shift];
										input1TmpSum += input1Tmp[(y-rand2Shift)*rw+x-rand1Shift];
										input2TmpSum += input2Tmp[(y-rand2Shift)*rw+x-rand1Shift];
										cellMaskSum += (float)cellMask[0][(y-rand2Shift)*rw+x-rand1Shift];
									}
								}
							}
							float p1=input1TmpSum/cellMaskSum,p2=input2TmpSum/cellMaskSum,p12=intersectionSum/cellMaskSum;

							// autocorrelation computation
							float[] autocorrelation1 = new float[(2*rw+1)*(2*rh+1)],autocorrelation2 = new float[(2*rw+1)*(2*rh+1)];
							autocorrelation1 = fftAutoCorrelation(input1Tmp,rw,rh);
							autocorrelation2 = fftAutoCorrelation(input2Tmp,rw,rh);

							// centering covariances
							for(int i=0;i<rw*rh;i++){
								autocorrelation1[i] -= Math.pow(p1, 2);
								autocorrelation2[i] -= Math.pow(p2, 2);
							}

							// remove coefficients corresponding to noise
							int radiusForTruncation=0;
							radiusForTruncation = radiusTruncation(autocorrelation1,autocorrelation2,truncationValue,2*rw+1,2*rh+1);

							// S1 computation
							float denominator = computeTruncatedS1(autocorrelation1,autocorrelation2,rw,rh,radiusForTruncation);
							// stat test S1
							float testStatistic = (p12-p1*p2)/(float)Math.sqrt((double)denominator);
							// normalized correlation
							float correlation = (p12-p1*p2)/(float)Math.sqrt(p1*(1.-p1)*p2*(1.-p2));
							// one-sided p-values S1
							if(correlation>0){
								if((1-CND(testStatistic))<0.05){
									nbPositiveTests[t]++;
									drawWhiteCircle(colocalizationHits, rand1Shift+rw/2, rand2Shift+rh/2, 0, t, w, h);
								}
							}
							else{
								if((1-CND(Math.abs(testStatistic)))<0.05){
									nbNegativeTests[t]++;
									drawBlueCircle(colocalizationHits, rand1Shift+rw/2, rand2Shift+rh/2, 0, t, w, h);
								}
							}
						}
					}
					visualizeSequence(colocalizationHits, w, h, d, 3, nbFrames, "Colocalization hits");
					File f = exportExcelFileRandomization.getValue();
					if (!FileUtil.getFileExtension(f.getPath(), false).equalsIgnoreCase("xls")) f = new File(f.getPath() + ".xls");
					exportRandomPvalues(nbPositiveTests,nbNegativeTests,nbRandomizations,f,inputImage1,channel1.getValue(),inputImage2,channel2.getValue());
				}	
				else{
					// statistical test estimation over time
					for(int t=0;t<nbFrames;t++){

						// extract images at time t
						float[][] inputData1 = Array2DUtil.arrayToFloatArray(inputImage1.getDataXYZ(t, channel1.getValue()), inputImage1.isSignedDataType()),
								inputData2 = Array2DUtil.arrayToFloatArray(inputImage2.getDataXYZ(t, channel2.getValue()), inputImage2.isSignedDataType());

						// output update
						float maxChannel1=0,maxChannel2=0;
						for(int z=0;z<d;z++){
							for(int i=0;i<arraySize;i++){
								if(inputData1[z][i]>maxChannel1){maxChannel1 = inputData1[z][i];}
								if(inputData2[z][i]>maxChannel2){maxChannel2 = inputData2[z][i];}
							}
						}
						for(int z=0;z<d;z++){
							for(int i=0;i<arraySize;i++){
								colocalizationHits[t*3][z][i] = inputData1[z][i]*255/maxChannel1;
								colocalizationHits[t*3+1][z][i] = inputData2[z][i]*255/maxChannel2;
							}
						}

						// cell mask
						if(cellMaskImage!=null){
							if(cellMaskImage.getSizeT()>1){
								cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t,0), cellMaskImage.isSignedDataType());
								for(int z=0;z<d;z++){
									for(int y=0;y<h;y++){
										for(int x=0;x<w;x++){
											if(cellMask[z][y*w+x]>0){
												cellMask[z][y*w+x] = 1;
											}
										}
									}
								}
							}
						}

						// test over randomly picked points
						for(int k=0;k<nbRandomizations;k++){

							// generate random point
							double rand1,rand2,rand3;
							int rand1Shift=0,rand2Shift=0,rand3Shift=0;
							boolean out=false;
							while(!out){
								rand1=Math.random();rand2=Math.random();rand3=Math.random();
								rand1Shift=(int)(rand1*((double)w-(double)rw));
								rand2Shift=(int)(rand2*((double)h-(double)rh));
								rand3Shift=(int)(rand3*((double)d-(double)rd));
								if((rand1Shift>=0)&&(rand1Shift<(w-rw/2))&&(rand2Shift>=0)&&(rand2Shift<(h-rh/2))&&(rand3Shift>=0)&&(rand3Shift<(d-rd/2))){
									if(cellMask[rand3Shift+rd/2][(rand2Shift+rh/2)*w+rand1Shift+rw/2]>0){
										out=true;
									}
								}
							}

							// progress bar and stop button
							if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
							processingSemaphore.progress();
							super.getUI().setProgressBarValue(processingSemaphore.getProgress());
							Thread.yield();

							// extract windows, data test and probas
							float[][] input1Tmp = new float[rd][rw*rh],input2Tmp = new float[rd][rw*rh],intersection = new float[d][rw*rh];
							float input1TmpSum=0,input2TmpSum=0,cellMaskSum=0,intersectionSum=0;
							for(int z=rand3Shift;z<(rd+rand3Shift);z++){
								for(int y=rand2Shift;y<(rh+rand2Shift);y++){
									for(int x=rand1Shift;x<(rw+rand1Shift);x++){
										if(cellMask[z][y*w+x]>0){
											if(inputData1[z][y*w+x]>0){input1Tmp[z-rand3Shift][(y-rand2Shift)*rw+x-rand1Shift] = 1;}
											if(inputData2[z][y*w+x]>0){input2Tmp[z-rand3Shift][(y-rand2Shift)*rw+x-rand1Shift] = 1;}
											intersection[z-rand3Shift][(y-rand2Shift)*rw+x-rand1Shift] = input1Tmp[z-rand3Shift][(y-rand2Shift)*rw+x-rand1Shift]*input2Tmp[z-rand3Shift][(y-rand2Shift)*rw+x-rand1Shift];
											intersectionSum += intersection[z-rand3Shift][(y-rand2Shift)*rw+x-rand1Shift];
											input1TmpSum += input1Tmp[z-rand3Shift][(y-rand2Shift)*rw+x-rand1Shift];
											input2TmpSum += input2Tmp[z-rand3Shift][(y-rand2Shift)*rw+x-rand1Shift];
											cellMaskSum += (float)cellMask[z-rand3Shift][(y-rand2Shift)*rw+x-rand1Shift];
										}
									}
								}
							}
							float p1=input1TmpSum/cellMaskSum,p2=input2TmpSum/cellMaskSum,p12=intersectionSum/cellMaskSum;

							// autocorrelation computation
							float[][] autocorrelation1 = new float[2*rd+1][(2*rw+1)*(2*rh+1)],autocorrelation2 = new float[2*rd+1][(2*rw+1)*(2*rh+1)];
							autocorrelation1 = fftAutoCorrelation(input1Tmp,rw,rh,rd);
							autocorrelation2 = fftAutoCorrelation(input2Tmp,rw,rh,rd);
							// centering covariances
							for(int z=0;z<rd;z++){
								for(int i=0;i<rw*rh;i++){
									autocorrelation1[z][i] -= Math.pow(p1, 2);
									autocorrelation2[z][i] -= Math.pow(p2, 2);
								}
							}

							// remove coefficients corresponding to noise
							int[] radiusForTruncation = new int[1],depthForTruncation = new int[1];
							radiusAndDepthTruncations(autocorrelation1,autocorrelation2,truncationValue,2*rw+1,2*rh+1,2*rd+1,radiusForTruncation,depthForTruncation);

							// with truncation
							// S1 computation
							float denominator = computeTruncatedS1(autocorrelation1,autocorrelation2,rw,rh,rd,radiusForTruncation[0],depthForTruncation[0]);
							// stat test S1
							float testStatistic = (p12-p1*p2)/(float)Math.sqrt((double)denominator);
							// normalized correlation
							float correlation = (p12-p1*p2)/(float)Math.sqrt(p1*(1.-p1)*p2*(1.-p2));
							// one-sided p-values S1
							if(correlation>0){
								if((1-CND(testStatistic))<0.05){
									nbPositiveTests[t]++;
									drawWhiteCircle(colocalizationHits, rand1Shift+rw/2, rand2Shift+rh/2, rand3Shift+rd/2, t, w, h);	
								}
							}
							else{
								if((1-CND(Math.abs(testStatistic)))<0.05){
									nbNegativeTests[t]++;
									drawBlueCircle(colocalizationHits, rand1Shift+rw/2, rand2Shift+rh/2, rand3Shift+rd/2, t, w, h);
								}
							}
						}
					}
					visualizeSequence(colocalizationHits, w, h, d, 3, nbFrames, "Colocalization hits");
					File f = exportExcelFileRandomization.getValue();
					if (!FileUtil.getFileExtension(f.getPath(), false).equalsIgnoreCase("xls")) f = new File(f.getPath() + ".xls");
					exportRandomPvalues(nbPositiveTests,nbNegativeTests,nbRandomizations,f,inputImage1,channel1.getValue(),inputImage2,channel2.getValue());
				}
			}
			else{
				if(mode.getValue()=="Dense geo-copositioning"){
					// parameters
					int dw = denseWindowWidth.getValue(),dh = denseWindowHeight.getValue(),dd = denseWindowDepth.getValue(),
							ws=5,hs=5,ds=3;
					if(dw>=w){dw=w-1;}if(dh>=h){dh=h-1;}if(dd>=d){dd=d-1;}

					// output image
					//float[][][] pvalueImage = new float[nbFrames][d-dd][(w-dw)*(h-dh)];
					float[][][] testStatisticImage = new float[nbFrames][d][arraySize];

					if(d==1){
						// bar progress and stop
						if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
						super.getUI().setProgressBarMessage("Processing data");
						processingSemaphore.init(0, nbFrames*((h-dh)/hs));
						super.getUI().setProgressBarValue(processingSemaphore.getProgress());
						Thread.yield();

						// statistical test estimation over time
						for(int t=0;t<nbFrames;t++){

							// extract images at time t
							float[] inputData1 = Array1DUtil.arrayToFloatArray(inputImage1.getDataXY(t, 0, channel1.getValue()), inputImage1.isSignedDataType()),
									inputData2 = Array1DUtil.arrayToFloatArray(inputImage2.getDataXY(t, 0, channel2.getValue()), inputImage2.isSignedDataType());

							// cell mask
							if(cellMaskImage!=null){
								if(cellMaskImage.getSizeT()>1){
									cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t,0), cellMaskImage.isSignedDataType());
									for(int y=0;y<h;y++){
										for(int x=0;x<w;x++){
											if(cellMask[0][y*w+x]>0){
												cellMask[0][y*w+x] = 1;
											}
										}
									}
								}
							}

							float maxTest=-100000,minTest=1000000;
							// test over points
							for(int y=0;y<(h-dh);y+=hs){
								// progress bar and stop button
								if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
								processingSemaphore.progress();
								super.getUI().setProgressBarValue(processingSemaphore.getProgress());
								Thread.yield();
								for(int x=0;x<(w-dw);x+=ws){
									// extract windows, test data and probas
									boolean flagChannel1=false,flagChannel2=false;
									float[] input1Tmp = new float[dw*dh],input2Tmp = new float[dw*dh],intersection = new float[dw*dh];
									float input1TmpSum=0,input2TmpSum=0,cellMaskSum=0,intersectionSum=0;
									for(int j=0;j<dh;j++){
										for(int i=0;i<dw;i++){
											if((cellMask[0][(y+j)*w+x+i]>0)&&(Math.sqrt(Math.pow(i-dw/2,2.)+Math.pow(j-dh/2,2.))<(dw/2+.01))){
												if(inputData1[(y+j)*w+x+i]>0){input1Tmp[j*dw+i] = 1;flagChannel1=true;}
												if(inputData2[(y+j)*w+x+i]>0){input2Tmp[j*dw+i] = 1;flagChannel2=true;}
												intersection[j*dw+i] = input1Tmp[j*dw+i]*input2Tmp[j*dw+i];
												intersectionSum += intersection[j*dw+i];
												input1TmpSum += input1Tmp[j*dw+i];
												input2TmpSum += input2Tmp[j*dw+i];
												cellMaskSum += (float)cellMask[0][j*dw+i];
											}
										}
									}
									float p1=input1TmpSum/cellMaskSum,p2=input2TmpSum/cellMaskSum,p12=intersectionSum/cellMaskSum;
									if(flagChannel1&&flagChannel2){
										// autocorrelation computation
										float[] autocorrelation1 = new float[(2*dw+1)*(2*dh+1)],autocorrelation2 = new float[(2*dw+1)*(2*dh+1)];
										autocorrelation1 = fftAutoCorrelation(input1Tmp,dw,dh);
										autocorrelation2 = fftAutoCorrelation(input2Tmp,dw,dh);

										// centering covariances
										for(int i=0;i<dw*dh;i++){
											autocorrelation1[i] -= Math.pow(p1, 2);
											autocorrelation2[i] -= Math.pow(p2, 2);
										}

										// remove coefficients corresponding to noise
										int radiusForTruncation=0;
										radiusForTruncation = radiusTruncation(autocorrelation1,autocorrelation2,truncationValue,2*dw+1,2*dh+1);

										// S1 computation
										float denominator = computeTruncatedS1(autocorrelation1,autocorrelation2,dw,dh,radiusForTruncation);
										// stat test S1
										float testStatistic = (p12-p1*p2)/(float)Math.sqrt((double)denominator);
										testStatisticImage[t][0][(y+dh/2)*w+(x+dw/2)] = testStatistic;
										if(testStatistic>maxTest){maxTest=testStatistic;}
										if(testStatistic<minTest){minTest=testStatistic;}
										// normalized correlation
										/*float correlation = (p12-p1*p2)/(float)Math.sqrt(p1*(1.-p1)*p2*(1.-p2));
										// one-sided p-values S1
										if(correlation>0){
											pvalueImage[t][0][y*(w-dw)+x] = 1-CND(testStatistic); 
										}
										else{
											pvalueImage[t][0][y*(w-dw)+x] = 1-CND(Math.abs(testStatistic));
										}*/
									}
									/*else{
										pvalueImage[t][0][y*(w-dw)+x] = 1;
									}*/
								}
							}
							//average(pvalueImage,w-dw,h-dh,1,nbFrames);
							//gaussianBlurring(pvalueImage,w-dw,h-dh,1,nbFrames);
							//visualizeSequence(pvalueImage, w-dw, h-dh, d, nbFrames, "p-value dense map");
							Sequence testStatisticSequence = getSequence(testStatisticImage, w, h, d, nbFrames, "Colocalization score");
							GaussianFilter gf = new GaussianFilter();
							Sequence output = gf.filter(testStatisticSequence, 5, 5, 0);
							float[] outputArray = Array1DUtil.arrayToFloatArray(output.getDataXY(t, 0, 0), output.isSignedDataType());
							float blurredMax=-1000000,blurredMin=1000000;
							for(int i=0;i<arraySize;i++){
								if(outputArray[i]>blurredMax){blurredMax=outputArray[i];}
								if(outputArray[i]<blurredMin){blurredMin=outputArray[i];}
							}
							for(int i=0;i<arraySize;i++){
								outputArray[i] = (outputArray[i]-blurredMin)*(maxTest-minTest)/(blurredMax-blurredMin)+minTest;
							}
							visualizeImage(outputArray, w, h, "Colocalization score");
						}
					}
					else{
						// bar progress and stop button
						if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
						super.getUI().setProgressBarMessage("Processing data");
						processingSemaphore.init(0, (int)((float)nbFrames*(((float)d-(float)dd)/(float)ds)*(((float)h-(float)dh)/(float)hs)));
						super.getUI().setProgressBarValue(processingSemaphore.getProgress());
						Thread.yield();

						for(int t=0;t<nbFrames;t++){

							// extract images at time t
							float[][] inputData1 = Array2DUtil.arrayToFloatArray(inputImage1.getDataXYZ(t, channel1.getValue()), inputImage1.isSignedDataType()),
									inputData2 = Array2DUtil.arrayToFloatArray(inputImage2.getDataXYZ(t, channel2.getValue()), inputImage2.isSignedDataType());

							// cell mask
							if(cellMaskImage!=null){
								if(cellMaskImage.getSizeT()>1){
									cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t,0), cellMaskImage.isSignedDataType());
									for(int z=0;z<d;z++){
										for(int y=0;y<h;y++){
											for(int x=0;x<w;x++){
												if(cellMask[z][y*w+x]>0){
													cellMask[z][y*w+x] = 1;
												}
											}
										}
									}
								}
							}

							float maxTest=-10000000,minTest=1000000;
							// test over points
							for(int z=0;z<(d-dd);z+=ds){
								for(int y=0;y<(h-dh);y+=hs){
									// progress bar and stop button
									if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
									processingSemaphore.progress();
									super.getUI().setProgressBarValue(processingSemaphore.getProgress());
									Thread.yield();
									for(int x=0;x<(w-dw);x+=ws){
										// extract windows, test data and probas
										boolean flagChannel1=false,flagChannel2=false;
										float[][] input1Tmp = new float[dd][dw*dh],input2Tmp = new float[dd][dw*dh],intersection = new float[dd][dw*dh];
										float input1TmpSum=0,input2TmpSum=0,cellMaskSum=0,intersectionSum=0;
										for(int k=0;k<dd;k++){
											for(int j=0;j<dh;j++){
												for(int i=0;i<dw;i++){
													if((cellMask[z+k][(y+j)*w+x+i]>0)&&(Math.sqrt(Math.pow(i-dw/2,2.)+Math.pow(j-dh/2,2.))<(dw/2+.01))){
														if(inputData1[z+k][(y+j)*w+x+i]>0){input1Tmp[k][j*dw+i] = 1;flagChannel1=true;}
														if(inputData2[z+k][(y+j)*w+x+i]>0){input2Tmp[k][j*dw+i] = 1;flagChannel2=true;}
														intersection[k][j*dw+i] = input1Tmp[k][j*dw+i]*input2Tmp[k][j*dw+i];
														intersectionSum += intersection[k][j*dw+i];
														input1TmpSum += input1Tmp[k][j*dw+i];
														input2TmpSum += input2Tmp[k][j*dw+i];
														cellMaskSum += (float)cellMask[0][j*dw+i];
													}
												}
											}
										}
										float p1=input1TmpSum/cellMaskSum,p2=input2TmpSum/cellMaskSum,p12=intersectionSum/cellMaskSum;

										if(flagChannel1&&flagChannel2){
											// autocorrelation computation
											float[][] autocorrelation1 = new float[2*dd+1][(2*dw+1)*(2*dh+1)],autocorrelation2 = new float[2*dd+1][(2*dw+1)*(2*dh+1)];
											autocorrelation1 = fftAutoCorrelation(input1Tmp,dw,dh,dd);
											autocorrelation2 = fftAutoCorrelation(input2Tmp,dw,dh,dd);
											// centering covariances
											for(int k=0;k<dd;k++){
												for(int i=0;i<dw*dh;i++){
													autocorrelation1[z][i] -= Math.pow(p1, 2);
													autocorrelation2[z][i] -= Math.pow(p2, 2);
												}
											}

											// remove coefficients corresponding to noise
											int[] radiusForTruncation = new int[1],depthForTruncation = new int[1];
											radiusAndDepthTruncations(autocorrelation1,autocorrelation2,truncationValue,2*dw+1,2*dh+1,2*dd+1,radiusForTruncation,depthForTruncation);

											// with truncation
											// S1 computation
											float denominator = computeTruncatedS1(autocorrelation1,autocorrelation2,dw,dh,dd,radiusForTruncation[0],depthForTruncation[0]);
											// stat test S1
											float testStatistic = (p12-p1*p2)/(float)Math.sqrt((double)denominator);
											testStatisticImage[t][z+dd/2][(y+dh/2)*w+x+dw/2] = testStatistic;
											if(testStatistic>maxTest){maxTest=testStatistic;}
											if(testStatistic<minTest){minTest=testStatistic;}
											// normalized correlation
											//float correlation = (p12-p1*p2)/(float)Math.sqrt(p1*(1.-p1)*p2*(1.-p2));
											// one-sided p-values S1
											//if(correlation>0){
												//pvalueImage[t][z][y*(w-dw)+x] = 1-CND(testStatistic); 
											//}
											//else{
												//pvalueImage[t][z][y*(w-dw)+x] = 1-CND(Math.abs(testStatistic));
											//}
										}
										//else{
											//pvalueImage[t][z][y*(w-dw)+x] = 1;
										//}
									}
								}
							}
							//average(pvalueImage,w-dw,h-dh,d-dd,nbFrames);
							//visualizeSequence(pvalueImage, w-dw, h-dh, d-dd, nbFrames, "p-value dense map");
							//average(testStatisticImage,w-dw,h-dh,d-dd,nbFrames);
							//visualizeSequence(testStatisticImage, w-dw, h-dh, d-dd, nbFrames, "Colocalization score");
							Sequence testStatisticSequence = getSequence(testStatisticImage, w, h, d, nbFrames, "Colocalization score");
							GaussianFilter gf = new GaussianFilter();
							float gz=5;
							if((6.F*gz+1.F)>d){gz = ((float)d-1.F)/3.F;}
							Sequence output = gf.filter(testStatisticSequence, 5, 5, 1.5);
							float[][] outputArray = Array2DUtil.arrayToFloatArray(output.getDataXYZ(t, 0), output.isSignedDataType());
							float blurredMax=-1000000,blurredMin=1000000;
							for(int z=0;z<d;z++){
								for(int i=0;i<arraySize;i++){
									if(outputArray[z][i]>blurredMax){blurredMax=outputArray[z][i];}
									if(outputArray[z][i]<blurredMin){blurredMin=outputArray[z][i];}
								}
							}
							for(int z=0;z<d;z++){
								for(int i=0;i<arraySize;i++){
									outputArray[z][i] = (outputArray[z][i]-blurredMin)*(maxTest-minTest)/(blurredMax-blurredMin)+minTest;
								}
							}
							visualizeImage(outputArray, w, h, d, 0, "Colocalization score");
						}
					}
				}
				else{
					if(mode.getValue()=="Temporal interaction profile"){
						if(inputImage1.getSizeT()==1){
							MessageDialog.showDialog("The temporal interaction profile is only available for image sequences");return;}

						// test on output xls files
						if(exportExcelFileTemporalProfile.getValue(false)==null){
							MessageDialog.showDialog("You need to specify the output xls file");
							return;
						}

						// parameters
						int actualMaxShift = maxShift.getValue();
						if(actualMaxShift>nbFrames){actualMaxShift = nbFrames;}
						float[] testStatistic = new float[(2*actualMaxShift+1)*(nbFrames-actualMaxShift)];

						// bar progress and stop
						if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
						super.getUI().setProgressBarMessage("Computing autocorrelation at each time step");
						autocorrelationSemaphore.init(0, nbFrames);
						super.getUI().setProgressBarValue(autocorrelationSemaphore.getProgress());
						Thread.yield();

						if(d==1){

							// computing autocorrelations over time
							float[][] autocorrelationOverTime1 = new float[nbFrames][(2*w+1)*(2*h+1)],autocorrelationOverTime2 = new float[nbFrames][(2*w+1)*(2*h+1)];
							for(int t=0;t<nbFrames;t++){
								// progress bar and stop button
								if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
								autocorrelationSemaphore.progress();
								super.getUI().setProgressBarValue(autocorrelationSemaphore.getProgress());
								Thread.yield();

								// cell mask
								if(cellMaskImage!=null){
									if(cellMaskImage.getSizeT()>1){
										cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t,0), cellMaskImage.isSignedDataType());
										for(int y=0;y<h;y++){
											for(int x=0;x<w;x++){
												if(cellMask[0][y*w+x]>0){
													cellMask[0][y*w+x] = 1;
												}
											}
										}
									}
								}

								// input data
								float[] inputData1 = Array1DUtil.arrayToFloatArray(inputImage1.getDataXY(t, 0, channel1.getValue()), inputImage1.isSignedDataType()),
										inputData2 = Array1DUtil.arrayToFloatArray(inputImage2.getDataXY(t, 0, channel2.getValue()), inputImage2.isSignedDataType());
								float[] input1Tmp = new float[arraySize],input2Tmp = new float[arraySize];

								// data test and probas
								for(int i=0;i<arraySize;i++){
									if(inputData1[i]*cellMask[0][i]>0){input1Tmp[i] = 1;}
									if(inputData2[i]*cellMask[0][i]>0){input2Tmp[i] = 1;}
								}

								// autocorrelation computation
								float[] autocorrelation1 = new float[(2*w+1)*(2*h+1)],autocorrelation2 = new float[(2*w+1)*(2*h+1)];
								autocorrelation1 = fftAutoCorrelation(input1Tmp,w,h);
								autocorrelation2 = fftAutoCorrelation(input2Tmp,w,h);
								for(int i=0;i<(2*w+1)*(2*h+1);i++){
									autocorrelationOverTime1[t][i] = autocorrelation1[i];
									autocorrelationOverTime2[t][i] = autocorrelation2[i];
								}
							}

							// bar progress and stop
							if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
							super.getUI().setProgressBarMessage("Processing");
							processingSemaphore.init(0, 2*actualMaxShift+1);
							super.getUI().setProgressBarValue(processingSemaphore.getProgress());
							Thread.yield();

							// computing test statistic for negative shift
							for(int shift=actualMaxShift;shift>0;shift--){
								// progress bar and stop button
								if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
								processingSemaphore.progress();
								super.getUI().setProgressBarValue(processingSemaphore.getProgress());
								Thread.yield();

								// statistical test estimation over time
								for(int t=0;t<(nbFrames-actualMaxShift);t++){
									// cell mask
									if(cellMaskImage!=null){
										if(cellMaskImage.getSizeT()>1){
											cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t+shift,0), cellMaskImage.isSignedDataType());
											for(int y=0;y<h;y++){
												for(int x=0;x<w;x++){
													if(cellMask[0][y*w+x]>0){
														cellMask[0][y*w+x] = 1;
													}
												}
											}
										}
									}

									// input data
									float[] inputData1 = Array1DUtil.arrayToFloatArray(inputImage1.getDataXY(t+shift, 0, channel1.getValue()), inputImage1.isSignedDataType()),
											inputData2 = Array1DUtil.arrayToFloatArray(inputImage2.getDataXY(t, 0, channel2.getValue()), inputImage2.isSignedDataType());
									float[] input1Tmp = new float[arraySize],input2Tmp = new float[arraySize],intersection = new float[arraySize],autocorrelation1 = new float[(2*w+1)*(2*h+1)],autocorrelation2 = new float[(2*w+1)*(2*h+1)];
									float input1TmpSum=0,input2TmpSum=0,cellMaskSum=0,intersectionSum=0;
									for(int y=0;y<h;y++){
										for(int x=0;x<w;x++){
											if(cellMask[0][y*w+x]>0){
												if(inputData1[y*w+x]>0){input1Tmp[y*w+x] = 1;}
												if(inputData2[y*w+x]>0){input2Tmp[y*w+x] = 1;}
												intersection[y*w+x] = input1Tmp[y*w+x]*input2Tmp[y*w+x];
												intersectionSum += intersection[y*w+x];
												input1TmpSum += input1Tmp[y*w+x];
												input2TmpSum += input2Tmp[y*w+x];
												cellMaskSum += (float)cellMask[0][y*w+x];
											}
										}
									}
									float p1=input1TmpSum/cellMaskSum,p2=input2TmpSum/cellMaskSum,p12=intersectionSum/cellMaskSum;
									for(int i=0;i<(2*w+1)*(2*h+1);i++){
										autocorrelation1[i] = autocorrelationOverTime1[t+shift][i] - (float)Math.pow(p1, 2);
										autocorrelation2[i] = autocorrelationOverTime2[t][i] - (float)Math.pow(p2, 2);
									}

									// remove coefficients corresponding to noise
									int radiusForTruncation=0;
									radiusForTruncation = radiusTruncation(autocorrelation1,autocorrelation2,truncationValue,2*w+1,2*h+1);

									// S1 computation
									float denominator = computeTruncatedS1(autocorrelation1,autocorrelation2,w,h,radiusForTruncation);
									// stat test S1
									testStatistic[(actualMaxShift-shift)*(nbFrames-actualMaxShift)+t] = (p12-p1*p2)/(float)Math.sqrt((double)denominator);
								}
							}
							// computing test statistic for every positive shift
							for(int shift=0;shift<=actualMaxShift;shift++){
								// progress bar and stop button
								if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
								processingSemaphore.progress();
								super.getUI().setProgressBarValue(processingSemaphore.getProgress());
								Thread.yield();

								// statistical test estimation over time
								for(int t=0;t<(nbFrames-actualMaxShift);t++){
									// cell mask
									if(cellMaskImage!=null){
										if(cellMaskImage.getSizeT()>1){
											cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t,0), cellMaskImage.isSignedDataType());
											for(int y=0;y<h;y++){
												for(int x=0;x<w;x++){
													if(cellMask[0][y*w+x]>0){
														cellMask[0][y*w+x] = 1;
													}
												}
											}
										}
									}

									// input data
									float[] inputData1 = Array1DUtil.arrayToFloatArray(inputImage1.getDataXY(t, 0, channel1.getValue()), inputImage1.isSignedDataType()),
											inputData2 = Array1DUtil.arrayToFloatArray(inputImage2.getDataXY(t+shift, 0, channel2.getValue()), inputImage2.isSignedDataType());
									float[] input1Tmp = new float[arraySize],input2Tmp = new float[arraySize],intersection = new float[arraySize],autocorrelation1 = new float[(2*w+1)*(2*h+1)],autocorrelation2 = new float[(2*w+1)*(2*h+1)];
									float input1TmpSum=0,input2TmpSum=0,cellMaskSum=0,intersectionSum=0;
									for(int y=0;y<h;y++){
										for(int x=0;x<w;x++){
											if(cellMask[0][y*w+x]>0){
												if(inputData1[y*w+x]>0){input1Tmp[y*w+x] = 1;}
												if(inputData2[y*w+x]>0){input2Tmp[y*w+x] = 1;}
												intersection[y*w+x] = input1Tmp[y*w+x]*input2Tmp[y*w+x];
												intersectionSum += intersection[y*w+x];
												input1TmpSum += input1Tmp[y*w+x];
												input2TmpSum += input2Tmp[y*w+x];
												cellMaskSum += (float)cellMask[0][y*w+x];
											}
										}
									}
									float p1=input1TmpSum/cellMaskSum,p2=input2TmpSum/cellMaskSum,p12=intersectionSum/cellMaskSum;
									for(int i=0;i<(2*w+1)*(2*h+1);i++){
										autocorrelation1[i] = autocorrelationOverTime1[t][i] - (float)Math.pow(p1, 2);
										autocorrelation2[i] = autocorrelationOverTime2[t+shift][i] - (float)Math.pow(p2, 2);
									}

									// remove coefficients corresponding to noise
									int radiusForTruncation=0;
									radiusForTruncation = radiusTruncation(autocorrelation1,autocorrelation2,truncationValue,2*w+1,2*h+1);

									// S1 computation
									float denominator = computeTruncatedS1(autocorrelation1,autocorrelation2,w,h,radiusForTruncation);
									// stat test S1
									testStatistic[(actualMaxShift+shift)*(nbFrames-actualMaxShift)+t] = (p12-p1*p2)/(float)Math.sqrt((double)denominator);
								}
							}
						}
						else{
							// computing autocorrelations over time
							float[][][] autocorrelationOverTime1 = new float[nbFrames][2*d+1][(2*w+1)*(2*h+1)],autocorrelationOverTime2 = new float[nbFrames][2*d+1][(2*w+1)*(2*h+1)];
							for(int t=0;t<nbFrames;t++){
								// progress bar and stop button
								if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
								autocorrelationSemaphore.progress();
								super.getUI().setProgressBarValue(autocorrelationSemaphore.getProgress());
								Thread.yield();

								// input data
								float[][] inputData1 = Array2DUtil.arrayToFloatArray(inputImage1.getDataXYZ(t, channel1.getValue()), inputImage1.isSignedDataType()),
										inputData2 = Array2DUtil.arrayToFloatArray(inputImage2.getDataXYZ(t, channel2.getValue()), inputImage2.isSignedDataType());
								float[][] input1Tmp = new float[d][arraySize],input2Tmp = new float[d][arraySize];

								// cell mask
								if(cellMaskImage!=null){
									if(cellMaskImage.getSizeT()>1){
										cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t,0), cellMaskImage.isSignedDataType());
										for(int z=0;z<d;z++){
											for(int y=0;y<h;y++){
												for(int x=0;x<w;x++){
													if(cellMask[z][y*w+x]>0){
														cellMask[z][y*w+x] = 1;
													}
												}
											}
										}
									}
								}

								// data test and probas
								for(int z=0;z<d;z++){
									for(int i=0;i<arraySize;i++){
										if(inputData1[z][i]*cellMask[z][i]>0){input1Tmp[z][i] = 1;}
										if(inputData2[z][i]*cellMask[z][i]>0){input2Tmp[z][i] = 1;}
									}
								}

								// autocorrelation computation
								float[][] autocorrelation1 = new float[2*d+1][(2*w+1)*(2*h+1)],autocorrelation2 = new float[2*d+1][(2*w+1)*(2*h+1)];
								autocorrelation1 = fftAutoCorrelation(input1Tmp,w,h,d);
								autocorrelation2 = fftAutoCorrelation(input2Tmp,w,h,d);
								for(int z=0;z<d;z++){
									for(int i=0;i<(2*w+1)*(2*h+1);i++){
										autocorrelationOverTime1[t][z][i] = autocorrelation1[z][i];
										autocorrelationOverTime2[t][z][i] = autocorrelation2[z][i];
									}
								}
							}

							// bar progress and stop
							if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
							super.getUI().setProgressBarMessage("Processing");
							processingSemaphore.init(0, 2*actualMaxShift+1);
							super.getUI().setProgressBarValue(processingSemaphore.getProgress());
							Thread.yield();

							// computing test statistic for every negative shift
							for(int shift=actualMaxShift;shift>0;shift--){
								// progress bar and stop button
								if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
								processingSemaphore.progress();
								super.getUI().setProgressBarValue(processingSemaphore.getProgress());
								Thread.yield();

								// statistical test estimation over time
								for(int t=0;t<(nbFrames-actualMaxShift);t++){
									// cell mask
									if(cellMaskImage!=null){
										if(cellMaskImage.getSizeT()>1){
											cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t+shift,0), cellMaskImage.isSignedDataType());
											for(int z=0;z<d;z++){
												for(int y=0;y<h;y++){
													for(int x=0;x<w;x++){
														if(cellMask[z][y*w+x]>0){
															cellMask[z][y*w+x] = 1;
														}
													}
												}
											}
										}
									}

									// input data
									float[][] inputData1 = Array2DUtil.arrayToFloatArray(inputImage1.getDataXYZ(t+shift, channel1.getValue()), inputImage1.isSignedDataType()),
											inputData2 = Array2DUtil.arrayToFloatArray(inputImage2.getDataXYZ(t, channel2.getValue()), inputImage2.isSignedDataType());
									float[][] input1Tmp = new float[d][arraySize],input2Tmp = new float[d][arraySize],intersection = new float[d][arraySize],autocorrelation1 = new float[2*d+1][(2*w+1)*(2*h+1)],autocorrelation2 = new float[2*d+1][(2*w+1)*(2*h+1)];
									float input1TmpSum=0,input2TmpSum=0,cellMaskSum=0,intersectionSum=0;
									for(int z=0;z<d;z++){
										for(int y=0;y<h;y++){
											for(int x=0;x<w;x++){
												if(cellMask[z][y*w+x]>0){
													if(inputData1[z][y*w+x]>0){input1Tmp[z][y*w+x] = 1;}
													if(inputData2[z][y*w+x]>0){input2Tmp[z][y*w+x] = 1;}
													intersection[z][y*w+x] = input1Tmp[z][y*w+x]*input2Tmp[z][y*w+x];
													intersectionSum += intersection[z][y*w+x];
													input1TmpSum += input1Tmp[z][y*w+x];
													input2TmpSum += input2Tmp[z][y*w+x];
													cellMaskSum += (float)cellMask[z][y*w+x];
												}
											}
										}
									}
									float p1=input1TmpSum/cellMaskSum,p2=input2TmpSum/cellMaskSum,p12=intersectionSum/cellMaskSum;
									for(int z=0;z<d;z++){
										for(int i=0;i<(2*w+1)*(2*h+1);i++){
											autocorrelation1[z][i] = autocorrelationOverTime1[t+shift][z][i] - (float)Math.pow(p1, 2);
											autocorrelation2[z][i] = autocorrelationOverTime2[t][z][i] - (float)Math.pow(p2, 2);
										}
									}

									// remove coefficients corresponding to noise
									int[] radiusForTruncation = new int[1],depthForTruncation = new int[1];
									radiusAndDepthTruncations(autocorrelation1,autocorrelation2,truncationValue,2*w+1,2*h+1,2*d+1,radiusForTruncation,depthForTruncation);

									// with truncation
									// S1 computation
									float denominator = computeTruncatedS1(autocorrelation1,autocorrelation2,w,h,d,radiusForTruncation[0],depthForTruncation[0]);
									// stat test S1
									testStatistic[(actualMaxShift-shift)*(nbFrames-actualMaxShift)+t] = (p12-p1*p2)/(float)Math.sqrt((double)denominator);
								}
							}

							// computing test statistic for every positive shift
							for(int shift=0;shift<=actualMaxShift;shift++){
								// progress bar and stop button
								if(stopRunningBgProcess){stopRunningBgProcess=false;return;}
								processingSemaphore.progress();
								super.getUI().setProgressBarValue(processingSemaphore.getProgress());
								Thread.yield();

								// statistical test estimation over time
								for(int t=0;t<(nbFrames-actualMaxShift);t++){
									// cell mask
									if(cellMaskImage!=null){
										if(cellMaskImage.getSizeT()>1){
											cellMask = Array2DUtil.arrayToIntArray(cellMaskImage.getDataXYZ(t,0), cellMaskImage.isSignedDataType());
											for(int z=0;z<d;z++){
												for(int y=0;y<h;y++){
													for(int x=0;x<w;x++){
														if(cellMask[z][y*w+x]>0){
															cellMask[z][y*w+x] = 1;
														}
													}
												}
											}
										}
									}

									// input data
									float[][] inputData1 = Array2DUtil.arrayToFloatArray(inputImage1.getDataXYZ(t, channel1.getValue()), inputImage1.isSignedDataType()),
											inputData2 = Array2DUtil.arrayToFloatArray(inputImage2.getDataXYZ(t+shift, channel2.getValue()), inputImage2.isSignedDataType());
									float[][] input1Tmp = new float[d][arraySize],input2Tmp = new float[d][arraySize],intersection = new float[d][arraySize],autocorrelation1 = new float[2*d+1][(2*w+1)*(2*h+1)],autocorrelation2 = new float[2*d+1][(2*w+1)*(2*h+1)];
									float input1TmpSum=0,input2TmpSum=0,cellMaskSum=0,intersectionSum=0;
									for(int z=0;z<d;z++){
										for(int y=0;y<h;y++){
											for(int x=0;x<w;x++){
												if(cellMask[z][y*w+x]>0){
													if(inputData1[z][y*w+x]>0){input1Tmp[z][y*w+x] = 1;}
													if(inputData2[z][y*w+x]>0){input2Tmp[z][y*w+x] = 1;}
													intersection[z][y*w+x] = input1Tmp[z][y*w+x]*input2Tmp[z][y*w+x];
													intersectionSum += intersection[z][y*w+x];
													input1TmpSum += input1Tmp[z][y*w+x];
													input2TmpSum += input2Tmp[z][y*w+x];
													cellMaskSum += (float)cellMask[z][y*w+x];
												}
											}
										}
									}
									float p1=input1TmpSum/cellMaskSum,p2=input2TmpSum/cellMaskSum,p12=intersectionSum/cellMaskSum;
									for(int z=0;z<d;z++){
										for(int i=0;i<(2*w+1)*(2*h+1);i++){
											autocorrelation1[z][i] = autocorrelationOverTime1[t][z][i] - (float)Math.pow(p1, 2);
											autocorrelation2[z][i] = autocorrelationOverTime2[t+shift][z][i] - (float)Math.pow(p2, 2);
										}
									}

									// remove coefficients corresponding to noise
									int[] radiusForTruncation = new int[1],depthForTruncation = new int[1];
									radiusAndDepthTruncations(autocorrelation1,autocorrelation2,truncationValue,2*w+1,2*h+1,2*d+1,radiusForTruncation,depthForTruncation);

									// with truncation
									// S1 computation
									float denominator = computeTruncatedS1(autocorrelation1,autocorrelation2,w,h,d,radiusForTruncation[0],depthForTruncation[0]);
									// stat test S1
									testStatistic[(actualMaxShift+shift)*(nbFrames-actualMaxShift)+t] = (p12-p1*p2)/(float)Math.sqrt((double)denominator);
								}
							}
						}
						File f = exportExcelFileTemporalProfile.getValue();
						if (!FileUtil.getFileExtension(f.getPath(), false).equalsIgnoreCase("xls")) f = new File(f.getPath() + ".xls");
						exportTemporalInteractionProfile(testStatistic, f, inputImage1, channel1.getValue(), inputImage2, channel2.getValue(), 2*actualMaxShift+1, (nbFrames-actualMaxShift));
					}
				}
			}
		}
	}

	@Override
	public void stopExecution()
	{
		stopRunningBgProcess=true;
	}

	@Override
	public void clean()
	{
		processingSemaphore = new Semaphore();
		autocorrelationSemaphore = new Semaphore();
		stopRunningBgProcess=false;
	}

}
