/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.shape.priorshapes.shapes;

import plugins.big.bigsnakeutils.icy.snake3D.Snake3DNode;

/**
 * Custom 3D shape
 * 
 * @version November 26, 2014
 * 
 * @author Christophe Gaudet-Blavignac (chrisgaubla@gmail.com)
 */
public class Custom3D extends PriorShape3D {

	public Custom3D(Snake3DNode[] coef) {
		name_ = new String("Custom");
		minNumberNodes_ = coef.length;
		coef_ = new Snake3DNode[minNumberNodes_];
		for (int i = 0; i < coef_.length; i++) {
			coef_[i] = new Snake3DNode(coef[i].x, coef[i].y, coef[i].z,
					coef[i].isFrozen(), coef[i].isHidden());
		}
	}
}

