/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.shape.utils;

import java.awt.Polygon;
import java.awt.geom.Point2D;

/**
 * Class that encapsulates some geometric manipulation procedures.
 * 
 * @version May 3, 2014
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class Geometry2D {

	// ============================================================================
	// PUBLIC METHODS

	/**
	 * Parameterizes a curve to arc-length parameterization with a given number
	 * of points.
	 */
	public static Point2D.Double[] arcLengthResampling(Polygon p, int nPoints) {
		p.addPoint(p.xpoints[0], p.ypoints[0]);

		double[] arcLength = new double[p.npoints];
		arcLength[0] = 0;
		for (int i = 1; i < p.npoints; i++) {
			arcLength[i] = arcLength[i - 1]
					+ Math.sqrt((p.xpoints[i] - p.xpoints[i - 1])
							* (p.xpoints[i] - p.xpoints[i - 1])
							+ (p.ypoints[i] - p.ypoints[i - 1])
							* (p.ypoints[i] - p.ypoints[i - 1]));
		}

		Point2D.Double[] resampledCurve = new Point2D.Double[nPoints];
		double delta = arcLength[p.npoints - 1] / nPoints;
		int index = 0;
		for (int i = 0; i < nPoints; i++) {
			double t = delta * i;
			boolean found = false;
			for (; index < (p.npoints - 1) && !found; index++) {
				if (arcLength[index] <= t && arcLength[index + 1] >= t) {
					found = true;
				}
			}
			index--;
			resampledCurve[i] = new Point2D.Double(
					((arcLength[index + 1] - t) * p.xpoints[index] + (t - arcLength[index])
							* p.xpoints[index + 1])
							/ (arcLength[index + 1] - arcLength[index]),
					((arcLength[index + 1] - t) * p.ypoints[index] + (t - arcLength[index])
							* p.ypoints[index + 1])
							/ (arcLength[index + 1] - arcLength[index]));
		}
		return resampledCurve;
	}

	// ----------------------------------------------------------------------------

	/** Reverses the array of points. */
	public static Point2D.Double[] reverse(Point2D.Double[] p) {
		if (p == null) {
			return null;
		} else {
			Point2D.Double[] pRev = new Point2D.Double[p.length];
			for (int i = 0; i < p.length; i++) {
				pRev[i] = p[p.length - i - 1];
			}
			return pRev;
		}
	}
}
