/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.kymographtracker;

import icy.sequence.Sequence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import plugins.tinevez.kymographtracker.ActionPanel;

public class WorkFlowPanel
extends ActionPanel {
    private static final long serialVersionUID = -628508865966579403L;
    Sequence selectedSequence = null;
    JTextArea sequenceLabel;
    String noSequenceMessage = "<strong><font color=#FF0000>No sequence is selected.\n Please select first a sequence.</font></strong>";
    String kymoExtractionMessage = "<b>Kymograph extraction</b>: trace extraction paths in the sequence to analyze and convert them to ROIs, or directly trace (multiple or single line) ROIs. Kymographs are generated according to pixel values along the ROIs.";
    String kymoTrackingMessage = "<b>Kymograph tracking</b>: trace paths or ROIs in the kymograph images and convert them to tracks.";
    String worflowMessage = "The general workflow for kymograph tracking is the following: <ol> <li>" + this.kymoExtractionMessage + "</li> <li>" + this.kymoTrackingMessage + "</li></ol>";
    JEditorPane editorPane;
    JButton startWorkFlowButton;

    public WorkFlowPanel() {
        this.description = "Workflow";
        this.node = new DefaultMutableTreeNode(this.description);
        this.setBorder(new TitledBorder(this.description));
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new GridBagLayout());
        this.add((Component)northPanel, "North");
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        this.editorPane = new JEditorPane();
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditable(false);
        northPanel.add((Component)this.editorPane, c);
        this.refreshText();
        JPanel southPanel = new JPanel(new BorderLayout());
        this.startWorkFlowButton = new JButton("Start with kymograph extraction");
        southPanel.add((Component)this.startWorkFlowButton, "Center");
        this.add((Component)southPanel, "South");
    }

    public void enableGUI(boolean enable) {
    }

    @Override
    protected void changeSelectedSequence(Sequence sequence) {
        this.selectedSequence = sequence;
        this.refreshText();
    }

    public void refreshText() {
        if (this.selectedSequence == null) {
            this.editorPane.setText(String.valueOf(this.noSequenceMessage) + "<br>" + this.worflowMessage);
        } else {
            this.editorPane.setText("<font color=#00FF00>Selected sequence: " + this.selectedSequence.getName() + "</font><br>" + this.worflowMessage);
        }
    }
}

