/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.shape.priorshapes.shapes;

import plugins.big.bigsnakeutils.icy.snake2D.Snake2DNode;

/**
 * Shape prior with taking the shape of a circle.
 * 
 * @version November 13, 2013
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class Circle extends PriorShape {

	public Circle() {
		name_ = new String("Circle");
		minNumberNodes_ = 16;
		coef_ = new Snake2DNode[minNumberNodes_];
		for (int i = 0; i < minNumberNodes_; i++) {
			double t = 2.0 * Math.PI * i / minNumberNodes_;
			coef_[i] = new Snake2DNode(Math.sin(t), Math.cos(-t));
		}
	}

	// ----------------------------------------------------------------------------

	@Override
	public Snake2DNode[] getNodes(int M) {
		coef_ = new Snake2DNode[M];
		for (int i = 0; i < M; i++) {
			double t = 2.0 * Math.PI * i / M;
			coef_[i] = new Snake2DNode(Math.sin(t), Math.cos(-t));
		}
		return coef_;
	}
}
