/*
 * Decompiled with CFR 0.152.
 */
package kovac.gui.panels;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kovac.gui.panels.TransformationPanel;
import kovac.shapes.EllipsoidOverlay;

public class EllipsoidPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private EllipsoidOverlay overlay;
    private JButton chooseColorButton;
    private JButton chooseNameButton;
    private JButton transformations;
    private JTextField changeName;

    public EllipsoidPanel(EllipsoidOverlay e) {
        this.overlay = e;
        this.initComponents();
        this.initListeners();
    }

    private void initComponents() {
        this.setLayout(new GridLayout(3, 2));
        this.changeName = new JTextField(this.overlay.getName());
        this.chooseNameButton = new JButton("Change Name");
        this.chooseColorButton = new JButton("Change Color");
        this.transformations = new JButton("Transform Ellipsoid");
        this.add(this.changeName);
        this.add(this.chooseNameButton);
        this.add(new JPanel());
        this.add(this.chooseColorButton);
        this.add(new JPanel());
        this.add(this.transformations);
        this.transformations.setEnabled(false);
    }

    private void initListeners() {
        this.chooseColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(null, "Choose a Color", Color.RED);
                EllipsoidPanel.this.overlay.setColor(c);
            }
        });
        this.chooseNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EllipsoidPanel.this.overlay.setName(EllipsoidPanel.this.changeName.getText());
            }
        });
        this.transformations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame fen = new JFrame("Transformations");
                fen.add(new TransformationPanel(EllipsoidPanel.this.overlay));
                fen.pack();
                fen.setDefaultCloseOperation(2);
                fen.setVisible(true);
                fen.setResizable(false);
                fen.setAlwaysOnTop(true);
                fen.addWindowListener(new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        EllipsoidPanel.this.overlay.goToWireframe();
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        EllipsoidPanel.this.overlay.goToGeneric();
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }
                });
            }
        });
    }
}

