/*
 * Decompiled with CFR 0.152.
 */
package kovac.shapes;

import Jama.Matrix;
import icy.gui.dialog.ConfirmDialog;
import icy.painter.Overlay;
import icy.painter.VtkPainter;
import icy.sequence.DimensionId;
import java.awt.Color;
import javax.swing.JPanel;
import kovac.gui.panels.EllipsoidPanel;
import kovac.res.EllipsoidTransformations;
import kovac.res.quadric.QuadricExpression;
import kovac.res.util.LinkedViewersUtil;
import kovac.res.util.MathUtils;
import kovac.saving.SavingStatic;
import kovac.shapes.Ellipsoid;
import vtk.vtkActor;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDoubleArray;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkSphereSource;
import vtk.vtkTensorGlyph;

public class EllipsoidOverlay
extends Overlay
implements VtkPainter {
    private vtkActor ellipsoidActor;
    private Ellipsoid ellipsoid;
    private QuadricExpression quadric;
    private QuadricExpression quadricMicro;
    private String name;
    private boolean isSaved;
    private Matrix matSR;
    private vtkPoints center;
    private EllipsoidTransformations linkedTransformation;
    private double[] bounds;

    public EllipsoidOverlay(Matrix matSR, vtkPoints center) {
        super("Ellipsoid");
        this.isSaved = false;
        this.matSR = matSR;
        this.center = center;
        this.linkedTransformation = new EllipsoidTransformations(matSR, center.GetPoint(0), this);
        this.initMat();
    }

    public EllipsoidOverlay() {
        super("Empty overlay");
    }

    public void saveQuadric(QuadricExpression quadric, QuadricExpression quadricMicro) {
        this.quadric = quadric;
        this.quadricMicro = quadricMicro;
    }

    public void applyTransformation() {
        this.remove();
        this.matSR = this.linkedTransformation.getNewMatrix();
        this.center = new vtkPoints();
        double[] newCenter = this.linkedTransformation.getNewCenter();
        this.center.InsertNextPoint(newCenter);
        Matrix centerMat = new Matrix(3, 1);
        centerMat.set(0, 0, newCenter[0]);
        centerMat.set(1, 0, newCenter[1]);
        centerMat.set(2, 0, newCenter[2]);
        this.initMat();
        this.goToWireframe();
        this.setCanBeRemoved(true);
        LinkedViewersUtil.addOverlayToVTK(this);
        LinkedViewersUtil.getOrthCanvas().repaint();
    }

    public EllipsoidTransformations getTransform() {
        return this.linkedTransformation;
    }

    private void initMat() {
        vtkPolyData polyData = new vtkPolyData();
        polyData.SetPoints(this.center);
        vtkDoubleArray tensors = new vtkDoubleArray();
        tensors.SetNumberOfComponents(9);
        double[][] tabTmp = this.matSR.getArray();
        tensors.InsertTuple9(0, tabTmp[0][0], tabTmp[0][1], tabTmp[0][2], tabTmp[1][0], tabTmp[1][1], tabTmp[1][2], tabTmp[2][0], tabTmp[2][1], tabTmp[2][2]);
        polyData.GetPointData().SetTensors((vtkDataArray)tensors);
        vtkSphereSource sphereSource = new vtkSphereSource();
        sphereSource.SetPhiResolution(18);
        sphereSource.SetThetaResolution(18);
        sphereSource.Update();
        vtkTensorGlyph tensorGlyph = new vtkTensorGlyph();
        tensorGlyph.SetInputData((vtkDataObject)polyData);
        tensorGlyph.SetSourceConnection(sphereSource.GetOutputPort());
        tensorGlyph.ColorGlyphsOff();
        tensorGlyph.ThreeGlyphsOff();
        tensorGlyph.ExtractEigenvaluesOff();
        tensorGlyph.Update();
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputData(tensorGlyph.GetOutput());
        mapper.Update();
        this.bounds = mapper.GetBounds();
        this.ellipsoidActor = new vtkActor();
        this.ellipsoidActor.SetMapper((vtkMapper)mapper);
        this.ellipsoidActor.SetScale(LinkedViewersUtil.getScale());
        this.ellipsoidActor.GetProperty().SetColor(1.0, 0.0, 0.0);
    }

    public vtkProp[] getProps() {
        return new vtkProp[]{this.ellipsoidActor};
    }

    public void setName(String name) {
        if (this.isSaved) {
            SavingStatic.rename(this.name, name);
        }
        this.name = name;
        super.setName(this.name);
        try {
            this.ellipsoid.setName(name);
        }
        catch (NullPointerException e) {
            System.err.println(e.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EllipsoidOverlay other = (EllipsoidOverlay)((Object)obj);
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void validate() {
        SavingStatic.saveEllipsoid(this.ellipsoid, this.name);
        this.isSaved = true;
    }

    public void setColor(Color c) {
        double[] rgb = new double[]{(double)c.getRed() / 255.0, (double)c.getGreen() / 255.0, (double)c.getBlue() / 255.0};
        this.ellipsoidActor.GetProperty().SetColor(rgb);
    }

    public double getVolume() {
        if (this.ellipsoid == null) {
            return Double.NaN;
        }
        return this.ellipsoid.getVolume(this.ellipsoid.getSemiLength());
    }

    public double[] getColor() {
        return this.ellipsoidActor.GetProperty().GetColor();
    }

    public QuadricExpression getQuadricExpression() {
        return this.quadric;
    }

    public JPanel getOptionsPanel() {
        return new EllipsoidPanel(this);
    }

    public void goToWireframe() {
        this.ellipsoidActor.GetProperty().SetRepresentationToWireframe();
    }

    public void goToGeneric() {
        this.ellipsoidActor.GetProperty().SetRepresentationToSurface();
    }

    public void setEllipsoid(Ellipsoid e) {
        this.ellipsoid = e;
        this.ellipsoid.setMicroQuadric(this.quadricMicro);
        this.ellipsoid.setBounds(this.bounds);
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public double[] getIntersection(DimensionId dim, double[] truePos) {
        return this.quadric.getIntersection(dim, truePos);
    }

    public void checkValues() {
        boolean needsToDelete = false;
        double[] length = this.quadric.getSemiAxis();
        double max = MathUtils.max(length);
        int i = 0;
        while (i < length.length) {
            int n = i++;
            length[n] = length[n] / max;
        }
        double[] dArray = length;
        int n = length.length;
        int n2 = 0;
        while (n2 < n) {
            double d1 = dArray[n2];
            double[] dArray2 = length;
            int n3 = length.length;
            int n4 = 0;
            while (n4 < n3) {
                double d2 = dArray2[n4];
                if (d1 != d2 && d1 / d2 > 5.0) {
                    needsToDelete = true;
                }
                ++n4;
            }
            ++n2;
        }
        if (needsToDelete && !ConfirmDialog.confirm((String)"The ellipsoid elongation is higher than 5, do you want to proceed anyway ?")) {
            SavingStatic.deleteEllipsoid(this.ellipsoid.getName());
            this.remove();
        }
    }
}

