/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.core;

/**
 * Offers global parameters (settings) and functions used by the plug-in.
 * 
 * Settings makes use of the Singleton design pattern: There is at most one
 * instance present, which can only be accessed through
 * <code>getInstance()</code>.
 * 
 * @version December 30, 2014
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class Settings {

	/** The unique instance of <code>Settings</code> (Singleton design pattern). */
	private static Settings instance_ = null;

	// ----------------------------------------------------------------------------
	// PLUG-IN INFO

	/** Name of the application. */
	private final String appName_ = "Active Cells SDK for Icy";
	/** Version of the application. */
	private final String appVersion_ = "2.5";
	/** Minimal version of Icy required to run the plug-in. */
	private final String icyRequiredVersion_ = "1.6.1.1";

	// ----------------------------------------------------------------------------
	// OTHER

	/** Set to true to enable DEBUG mode */
	public static final boolean DEBUG = false;

	// ============================================================================
	// PUBLIC METHODS

	/** Get <code>Settings</code> instance */
	static public Settings getInstance() {
		if (instance_ == null) {
			instance_ = new Settings();
		}
		return instance_;
	}

	// ============================================================================
	// SETTERS AND GETTERS

	/** Returns the name of the plug-in. */
	public String getAppName() {
		return appName_;
	}

	// ----------------------------------------------------------------------------

	/** Returns the version of the plug-in. */
	public String getAppVersion() {
		return appVersion_;
	}

	// ----------------------------------------------------------------------------

	/** Returns the minimum version of Icy in which the plug-in works properly. */
	public String getIcyRequiredVersion() {
		return icyRequiredVersion_;
	}
}