/*
 * Decompiled with CFR 0.152.
 */
package kovac.binaryMask;

import icy.gui.frame.progress.CancelableProgressFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.thread.ThreadUtil;
import icy.type.collection.array.Array1DUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kovac.binaryMask.BoundingBox;
import kovac.binaryMask.ConcurrentBoundingBoxTreatment;
import kovac.saving.SavingStatic;
import kovac.shapes.Ellipsoid;

public class BinaryMask {
    private Sequence seqExport;
    private List<BoundingBox> boundingBoxes;
    private int[] size;
    private static Collection<int[]> coordinates = Collections.synchronizedCollection(new ArrayList());
    final ProgressFrame progress;

    public BinaryMask(Sequence initialSeq) {
        this.size = new int[]{initialSeq.getSizeX(), initialSeq.getSizeY(), initialSeq.getSizeZ()};
        this.seqExport = SequenceUtil.getCopy((Sequence)initialSeq);
        this.seqExport.setName("Binary Mask for " + initialSeq.getName());
        this.boundingBoxes = new ArrayList<BoundingBox>();
        this.progress = new CancelableProgressFrame("Creating mask");
    }

    private void initializeSequence() {
        int z = 0;
        while (z < this.size[2]) {
            Array1DUtil.fill((Object)this.seqExport.getImage(0, z).getDataXY(0), (int)0, (int)(this.size[0] * this.size[1]), (double)0.0);
            ++z;
        }
    }

    private void getBoundingBoxes() {
        for (Ellipsoid e : SavingStatic.getAllEllipsoids()) {
            this.boundingBoxes.add(new BoundingBox(e));
        }
    }

    private void treatBoundingBoxes() {
        ExecutorService exec = ThreadUtil.createThreadPool((String)"Bounding Boxes");
        for (BoundingBox b : this.boundingBoxes) {
            exec.execute(new ConcurrentBoundingBoxTreatment(b));
        }
        exec.shutdown();
        try {
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            System.out.println("Threads didn't finish in time");
        }
    }

    public static void addCoordinates(int[] coord) {
        coordinates.add(coord);
    }

    public Sequence buildExitSequence() {
        this.initializeSequence();
        this.getBoundingBoxes();
        this.treatBoundingBoxes();
        this.progress.setLength((double)coordinates.size());
        ArrayList<int[]> monoThreadCoordinates = new ArrayList<int[]>(coordinates);
        coordinates.clear();
        ExecutorService exec = ThreadUtil.createThreadPool((String)"Creating Mask");
        for (int[] coordinates : monoThreadCoordinates) {
            exec.execute(new AddCoordinates(coordinates));
        }
        exec.shutdown();
        try {
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            System.out.println("Threads didn't finish in time");
        }
        return this.seqExport;
    }

    private class AddCoordinates
    implements Runnable {
        int[] coordinates;

        public AddCoordinates(int[] coordinates) {
            this.coordinates = coordinates;
        }

        @Override
        public void run() {
            BinaryMask.this.seqExport.getImage(0, this.coordinates[2]).setData(this.coordinates[0], this.coordinates[1], 0, 255.0);
            BinaryMask.this.progress.incPosition();
        }
    }
}

