package plugins.tprovoost.contextualpainter.popups;

import icy.canvas.IcyCanvas;
import icy.main.Icy;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.point.Point5D;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public class PopupROI extends JPopupMenu
{

    /**
	 * 
	 */
    private static final long serialVersionUID = -1447332106769927581L;
    static ROI2D roiCopied = null;

    /**
     * This class creates a JPopupMenu for the ROIs, when user right clich on
     * their edge or center.
     * 
     * @param roi
     * @param e
     * @param imagePoint
     * @param canvas
     */
    public PopupROI(final ROI roi, MouseEvent e, final Point2D imagePoint, final IcyCanvas canvas)
    {
        super("ROI");

        Border titleUnderline = BorderFactory.createMatteBorder(1, 0, 0, 0, getForeground());
        TitledBorder labelBorder = BorderFactory.createTitledBorder(titleUnderline, getLabel(), TitledBorder.CENTER,
                TitledBorder.ABOVE_TOP, super.getFont().deriveFont(Font.BOLD), getForeground());
        setBorder(BorderFactory.createCompoundBorder(getBorder(), labelBorder));

        // ---------
        // ROI MENU
        // ---------
        JMenuItem itemCrop = new JMenuItem("Crop");
        itemCrop.addActionListener(new ActionListener()
        {

            @Override
            public void actionPerformed(ActionEvent e)
            {
                ThreadUtil.bgRun(new Runnable()
                {

                    @Override
                    public void run()
                    {
                        crop(canvas.getSequence(), roi, false);
                    }
                });
            }
        });
        add(itemCrop);
        itemCrop.setEnabled(roi instanceof ROI2DRectangle || roi instanceof ROI2DPolygon || roi instanceof ROI2DEllipse
                || roi instanceof ROI2DArea);

        JMenuItem itemCropBounds = new JMenuItem("Crop Bounds");
        itemCropBounds.addActionListener(new ActionListener()
        {

            @Override
            public void actionPerformed(ActionEvent e)
            {
                ThreadUtil.bgRun(new Runnable()
                {

                    @Override
                    public void run()
                    {
                        crop(canvas.getSequence(), roi, true);
                    }
                });
            }
        });
        if (!(roi instanceof ROI2DRectangle))
            add(itemCropBounds);

        // ---------
        // COPY MENU
        // ---------
        JMenuItem itemCopy = new JMenuItem("Copy");
        itemCopy.addActionListener(new ActionListener()
        {

            @Override
            public void actionPerformed(ActionEvent e)
            {
                roiCopied = (ROI2D) roi;
            }
        });
        add(itemCopy);
    }

    @Override
    protected void paintComponent(Graphics g)
    {
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintComponent(g2);
    }

    /**
     * Crop the roi in the canvas only if the ROI is a Rectangle, a Polygon, an
     * Ellipse or an Area. The <code>cropBound</code> boolean defines if the
     * data outside the shape should be set to the smallest value on the image.
     * 
     * @param sequence
     *        : Sequence on which the crop should happen.
     * @param roi
     *        : ROI used for cropping.
     * @param cropBounds
     *        : crop with a rectangle bound of the shape or not.
     */
    public static void crop(Sequence sequence, ROI roi, boolean cropBounds)
    {
        crop(sequence, roi, cropBounds, true);
    }

    /**
     * Crop the roi in the canvas only if the ROI is a Rectangle, a Polygon, an
     * Ellipse or an Area. The <code>cropBound</code> boolean defines if the
     * data outside the shape should be set to the smallest value on the image.
     * 
     * @param sequence
     *        : Sequence on which the crop should happen.
     * @param roi
     *        : ROI used for cropping.
     * @param cropBounds
     *        : crop with a rectangle bound of the shape or not.
     * @param replaceWithMinimum
     *        : used only if cropBound is true: will set pixels outside the
     *        shape to zero or the minimum value of the cropped image (for
     *        visual purposes, because of automatic bounds of the LUT).
     */
    public static void crop(Sequence sequence, ROI roi, boolean cropBounds, boolean replaceWithMinimum)
    {
        // crop result over ROI
        final Sequence cropped = SequenceUtil.getSubSequence(sequence, roi);

        cropped.setName(sequence.getName() + " - Cropped");

        // don't use bounds only
        if (!cropBounds)
        {
            final Point5D pos = roi.getPosition5D();
            final int offX = (pos.getX() == Double.NEGATIVE_INFINITY) ? 0 : (int) pos.getX();
            final int offY = (pos.getY() == Double.NEGATIVE_INFINITY) ? 0 : (int) pos.getY();
            final int offZ = (pos.getZ() == Double.NEGATIVE_INFINITY) ? 0 : (int) pos.getZ();
            final int offT = (pos.getT() == Double.NEGATIVE_INFINITY) ? 0 : (int) pos.getT();
            final int offC = (pos.getC() == Double.NEGATIVE_INFINITY) ? 0 : (int) pos.getC();
            final int sizeX = cropped.getSizeX();
            final int sizeY = cropped.getSizeY();
            final int sizeZ = cropped.getSizeZ();
            final int sizeT = cropped.getSizeT();
            final int sizeC = cropped.getSizeC();
            final DataType dataType = cropped.getDataType_();

            for (int t = 0; t < sizeT; ++t)
            {
                for (int z = 0; z < sizeZ; ++z)
                {
                    for (int c = 0; c < sizeC; ++c)
                    {
                        final BooleanMask2D mask = roi.getBooleanMask2D(z + offZ, t + offT, c + offC, false);
                        final Object data = cropped.getDataXY(t, z, c);
                        final double min = cropped.getChannelMin(c);

                        for (int y = 0; y < sizeY; ++y)
                        {
                            for (int x = 0; x < sizeX; ++x)
                            {
                                if (!mask.contains(x + offX, y + offY))
                                {
                                    if (replaceWithMinimum)
                                        Array1DUtil.setValue(data, (y * sizeX) + x, dataType, min);
                                    else
                                        Array1DUtil.setValue(data, (y * sizeX) + x, dataType, 0d);
                                }
                            }
                        }
                    }
                }
            }

            cropped.dataChanged();
        }

        Icy.getMainInterface().addSequence(cropped);
    }
}
