/*
 * Decompiled with CFR 0.152.
 */
package kovac.res.util;

import Jama.Matrix;

public class MathUtils {
    public static double[] getCenterOfMass(Matrix m) {
        double[][] matArray = m.getArray();
        double[] centerOfMass = new double[]{MathUtils.avg(matArray[0]), MathUtils.avg(matArray[1]), MathUtils.avg(matArray[2])};
        return centerOfMass;
    }

    public static double getVariance(double[] d) {
        double avgD = MathUtils.avg(d);
        double[] aMinusAvg = new double[d.length];
        int i = 0;
        while (i < d.length) {
            aMinusAvg[i] = Math.abs(d[i] - avgD);
            ++i;
        }
        return MathUtils.sumSquare(aMinusAvg) / (double)(d.length - 1);
    }

    public static double sum(double[] t) {
        double res = 0.0;
        int i = 0;
        while (i < t.length) {
            res += t[i];
            ++i;
        }
        return res;
    }

    public static double sumSquare(double[] d) {
        double res = 0.0;
        int i = 0;
        while (i < d.length) {
            res += d[i] * d[i];
            ++i;
        }
        return res;
    }

    public static double avg(double[] t) {
        return MathUtils.sum(t) / (double)t.length;
    }

    public static double min(double ... ds) {
        double min = ds[0];
        double[] dArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d < min) {
                min = d;
            }
            ++n2;
        }
        return min;
    }

    public static double max(double ... ds) {
        double max = ds[0];
        double[] dArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d > max) {
                max = d;
            }
            ++n2;
        }
        return max;
    }

    public static double times(double ... ds) {
        double res = 1.0;
        double[] dArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            res *= d;
            ++n2;
        }
        return res;
    }
}

