/*
 * Decompiled with CFR 0.152.
 */
package kovac.saving.persistent;

import icy.file.xml.XMLPersistent;
import icy.util.XMLUtil;
import java.util.ArrayList;
import kovac.saving.SavingStatic;
import kovac.shapes.Ellipsoid;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PersistentEllipsoids
implements XMLPersistent {
    private static final String ID_CLASS = "class";
    private static final String VALUE_CLASS = PersistentEllipsoids.class.getName();
    private static final String ID_ELLIPSOID = "ellipsoid";
    private static final String ID_NAME = "name";
    private static final String ID_ID = "id";

    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        Element className = XMLUtil.getElement((Node)node, (String)ID_CLASS);
        if (className == null) {
            className = XMLUtil.addElement((Node)node, (String)ID_CLASS);
        }
        if (className == null) {
            className = XMLUtil.addElement((Node)node, (String)ID_CLASS);
            XMLUtil.setAttributeValue((Element)className, (String)ID_NAME, (String)VALUE_CLASS);
        }
        for (Ellipsoid e : SavingStatic.getAllEllipsoids()) {
            if (e == null) continue;
            e.saveEllipsoidToXML(className);
        }
        return true;
    }

    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        ArrayList ellipsoids = XMLUtil.getElements((Node)XMLUtil.getElement((Node)node, (String)ID_CLASS), (String)ID_ELLIPSOID);
        for (Element e : ellipsoids) {
            String uniqueID = XMLUtil.getAttributeValue((Element)e, (String)ID_ID, (String)"");
            Ellipsoid ell = new Ellipsoid(uniqueID);
            ell.loadEllipsoidFromXML(e);
        }
        return true;
    }
}

