/*
 * Decompiled with CFR 0.152.
 */
package kovac.maths;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import icy.gui.dialog.MessageDialog;
import icy.type.point.Point3D;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kovac.res.Points;
import kovac.res.quadric.QuadricExpression;
import kovac.res.util.LinkedViewersUtil;
import kovac.res.util.MathUtils;
import kovac.shapes.Ellipsoid;
import kovac.shapes.EllipsoidOverlay;
import org.apache.commons.lang.ArrayUtils;
import vtk.vtkPoints;

public class EllipsoidAlgorithm {
    private static double gamma = 10.0;
    private static int nbIterations = 10000;
    private Matrix basePoints;
    private QuadricExpression quadricExpression;
    private QuadricExpression quadricExpressionMicro;
    private vtkPoints realCenter;
    private static double[] c;
    private Matrix basePointsMicro;

    public EllipsoidAlgorithm(List<Point3D> basePoints) {
        this.basePoints = new Matrix(3, basePoints.size());
        this.basePointsMicro = new Matrix(3, basePoints.size());
        double[] scale = LinkedViewersUtil.getScale();
        int i = 0;
        while (i < basePoints.size()) {
            this.basePoints.set(0, i, basePoints.get(i).getX());
            this.basePointsMicro.set(0, i, basePoints.get(i).getX() * scale[0]);
            this.basePoints.set(1, i, basePoints.get(i).getY());
            this.basePointsMicro.set(1, i, basePoints.get(i).getY() * scale[1]);
            this.basePoints.set(2, i, basePoints.get(i).getZ());
            this.basePointsMicro.set(2, i, basePoints.get(i).getZ() * scale[2]);
            ++i;
        }
    }

    public EllipsoidAlgorithm() {
    }

    public static Matrix getQ0(Matrix baseMatrix) {
        double[] baseCenter = MathUtils.getCenterOfMass(baseMatrix);
        double[] matVariance = new double[baseMatrix.getRowDimension()];
        int i = 0;
        while (i < baseMatrix.getRowDimension()) {
            matVariance[i] = MathUtils.getVariance(baseMatrix.getArray()[i]);
            ++i;
        }
        double avgRadius = MathUtils.sum(matVariance);
        double[][] baseSphereArray = new double[][]{{0.3333333333333333}, {0.3333333333333333}, {0.3333333333333333}, {0.0}, {0.0}, {0.0}, {-2.0 * baseCenter[0] / 3.0}, {-2.0 * baseCenter[1] / 3.0}, {-2.0 * baseCenter[2] / 3.0}, {(baseCenter[0] * baseCenter[0] + baseCenter[1] * baseCenter[1] + baseCenter[2] * baseCenter[2] - avgRadius) / 3.0}};
        return new Matrix((double[][])baseSphereArray);
    }

    public static void WriteMatrix(String name, Matrix M) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(name, "UTF-8");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        M.print(writer, 2, 4);
        writer.flush();
        writer.close();
    }

    private QuadricExpression douglasRachford(Matrix basePoints) {
        System.out.println("Number of points " + basePoints.getColumnDimension());
        c = MathUtils.getCenterOfMass(basePoints);
        double[][] shifting = new double[3][basePoints.getColumnDimension()];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < basePoints.getColumnDimension()) {
                shifting[i][j] = c[i];
                ++j;
            }
            ++i;
        }
        Matrix basePointsShifted = basePoints.minus(new Matrix(shifting));
        Matrix Cov = basePointsShifted.times(basePointsShifted.transpose());
        EigenvalueDecomposition eig = new EigenvalueDecomposition(Cov);
        Matrix U = eig.getV();
        Matrix S = eig.getD();
        int i2 = 0;
        while (i2 < 3) {
            S.set(i2, i2, Math.sqrt(1.0 / (S.get(i2, i2) + 1.0E-16)));
            ++i2;
        }
        Matrix P = S.times(U.transpose());
        Matrix basePointsInvariant = P.times(basePointsShifted);
        Matrix K = EllipsoidAlgorithm.getK(basePointsInvariant);
        Matrix M = EllipsoidAlgorithm.getM(K);
        Matrix p = EllipsoidAlgorithm.getQ0(basePointsShifted);
        Matrix q = null;
        int i3 = 0;
        while (i3 < nbIterations) {
            q = EllipsoidAlgorithm.proxf2(p);
            Matrix update = EllipsoidAlgorithm.proxf1(M, q.times(2.0).minus(p)).minus(q);
            p = p.plus(update);
            if (update.norm2() < p.norm2() * 1.0E-8) {
                System.out.println("Ellipsoid found in " + i3 + " iterations");
                break;
            }
            if (i3 > 1 && i3 % 10000 == 0) {
                System.out.println("Current iteration : " + i3);
            }
            if (i3 == nbIterations) {
                System.err.println("No acceptable ellipsoid could be found");
                throw new IllegalArgumentException("No acceptable ellipsoid could be found");
            }
            ++i3;
        }
        q = EllipsoidAlgorithm.proxf2(q);
        double[] et = new double[]{c[0], c[1], c[2]};
        Matrix t = new Matrix(et, 3);
        double[][] eA2 = new double[][]{{q.get(0, 0), q.get(3, 0) / Math.sqrt(2.0), q.get(4, 0) / Math.sqrt(2.0)}, {q.get(3, 0) / Math.sqrt(2.0), q.get(1, 0), q.get(5, 0) / Math.sqrt(2.0)}, {q.get(4, 0) / Math.sqrt(2.0), q.get(5, 0) / Math.sqrt(2.0), q.get(2, 0)}};
        Matrix A2 = new Matrix((double[][])eA2);
        double[] eb2 = new double[]{q.get(6, 0), q.get(7, 0), q.get(8, 0)};
        Matrix b2 = new Matrix(eb2, 3);
        double c2 = q.get(9, 0);
        Matrix A = P.transpose().times(A2.times(P));
        Matrix b = A.times(t.times(-2.0));
        b.plusEquals(P.transpose().times(b2));
        Matrix Pt = P.times(t);
        Matrix A2Pt = A2.times(Pt);
        A2Pt = A2Pt.transpose();
        Matrix c = A2Pt.times(Pt);
        Matrix b2t = b2.transpose();
        c.minusEquals(b2t.times(Pt));
        double[] eq = new double[]{A.get(0, 0), A.get(1, 1), A.get(2, 2), A.get(1, 0), A.get(2, 0), A.get(2, 1), b.get(0, 0), b.get(1, 0), b.get(2, 0), c.get(0, 0) + c2};
        Matrix Q = new Matrix(eq, 10);
        Q.timesEquals(1.0 / (A.get(0, 0) + A.get(1, 1) + A.get(2, 2)));
        return new QuadricExpression(Q);
    }

    public static Matrix proxf1(Matrix M, Matrix q) {
        Matrix res = Matrix.identity((int)q.getRowDimension(), (int)q.getColumnDimension());
        try {
            res = M.solve(q);
        }
        catch (RuntimeException e) {
            MessageDialog.showDialog((String)"An error has occured, please check your points configuration");
        }
        return res;
    }

    public static Matrix proxf2(Matrix q0) {
        Matrix Q0 = new Matrix(3, 3);
        double[] arrayCopy = q0.getColumnPackedCopy();
        Q0.set(0, 0, arrayCopy[0]);
        Q0.set(0, 1, arrayCopy[3] / Math.sqrt(2.0));
        Q0.set(0, 2, arrayCopy[4] / Math.sqrt(2.0));
        Q0.set(1, 0, arrayCopy[3] / Math.sqrt(2.0));
        Q0.set(1, 1, arrayCopy[1]);
        Q0.set(1, 2, arrayCopy[5] / Math.sqrt(2.0));
        Q0.set(2, 0, arrayCopy[4] / Math.sqrt(2.0));
        Q0.set(2, 1, arrayCopy[5] / Math.sqrt(2.0));
        Q0.set(2, 2, arrayCopy[2]);
        EigenvalueDecomposition eig = new EigenvalueDecomposition(Q0);
        Matrix U = eig.getV();
        Matrix S0 = eig.getD();
        Matrix s0 = EllipsoidAlgorithm.diag(S0);
        ArrayList<Double> asList = new ArrayList<Double>(Arrays.asList(ArrayUtils.toObject((double[])s0.getColumnPackedCopy())));
        List<Double> result = EllipsoidAlgorithm.projsplx(asList);
        Matrix s = new Matrix(result.size(), 1);
        int i = 0;
        while (i < result.size()) {
            s.set(i, 0, result.get(i).doubleValue());
            ++i;
        }
        Matrix S = EllipsoidAlgorithm.diag(s);
        Matrix Q = U.times(S.times(U.transpose()));
        Matrix q = new Matrix(q0.getRowDimension(), 1);
        q.set(0, 0, Q.get(0, 0));
        q.set(1, 0, Q.get(1, 1));
        q.set(2, 0, Q.get(2, 2));
        q.set(3, 0, Math.sqrt(2.0) * Q.get(1, 0));
        q.set(4, 0, Math.sqrt(2.0) * Q.get(2, 0));
        q.set(5, 0, Math.sqrt(2.0) * Q.get(2, 1));
        int i2 = 6;
        while (i2 < q0.getRowDimension()) {
            q.set(i2, 0, q0.get(i2, 0));
            ++i2;
        }
        return q;
    }

    public static Matrix diag(Matrix q) {
        Matrix res;
        block3: {
            block2: {
                res = null;
                if (q.getColumnDimension() != q.getRowDimension()) break block2;
                res = new Matrix(q.getColumnDimension(), 1);
                int i = 0;
                while (i < q.getRowDimension()) {
                    res.set(i, 0, q.get(i, i));
                    ++i;
                }
                break block3;
            }
            if (q.getColumnDimension() != 1) break block3;
            res = new Matrix(q.getRowDimension(), q.getRowDimension());
            int i = 0;
            while (i < q.getRowDimension()) {
                res.set(i, i, q.get(i, 0));
                ++i;
            }
        }
        return res;
    }

    public static Matrix getK(Matrix basePoints) {
        Matrix D = new Matrix(10, basePoints.getColumnDimension());
        int i = 0;
        while (i < basePoints.getColumnDimension()) {
            D.set(0, i, basePoints.get(0, i) * basePoints.get(0, i));
            D.set(1, i, basePoints.get(1, i) * basePoints.get(1, i));
            D.set(2, i, basePoints.get(2, i) * basePoints.get(2, i));
            D.set(3, i, Math.sqrt(2.0) * basePoints.get(0, i) * basePoints.get(1, i));
            D.set(4, i, Math.sqrt(2.0) * basePoints.get(0, i) * basePoints.get(2, i));
            D.set(5, i, Math.sqrt(2.0) * basePoints.get(1, i) * basePoints.get(2, i));
            D.set(6, i, basePoints.get(0, i));
            D.set(7, i, basePoints.get(1, i));
            D.set(8, i, basePoints.get(2, i));
            D.set(9, i, 1.0);
            ++i;
        }
        return D.times(D.transpose());
    }

    public static List<Double> projsplx(List<Double> y) {
        boolean bget = false;
        int m = y.size();
        ArrayList<Double> sortedList = new ArrayList<Double>(y);
        Collections.sort(sortedList, Collections.reverseOrder());
        double tmpSum = 0.0;
        double tMax = 0.0;
        int i = 0;
        while (i < m - 1) {
            tMax = ((tmpSum += ((Double)sortedList.get(i)).doubleValue()) - 1.0) / (double)(i + 1);
            if (tMax >= (Double)sortedList.get(i + 1)) {
                bget = true;
                break;
            }
            ++i;
        }
        if (!bget) {
            tMax = (tmpSum + (Double)sortedList.get(m - 1) - 1.0) / (double)m;
        }
        i = 0;
        while (i < y.size()) {
            y.set(i, Math.max(y.get(i) - tMax, 0.0));
            ++i;
        }
        return y;
    }

    public static Matrix getM(Matrix K) {
        Matrix identity = new Matrix(K.getRowDimension(), K.getColumnDimension());
        int i = 0;
        while (i < identity.getRowDimension()) {
            identity.set(i, i, 1.0);
            ++i;
        }
        Matrix M = K.times(gamma).plus(identity);
        return M;
    }

    public QuadricExpression getFinalQuadric() {
        if (this.quadricExpression == null) {
            this.quadricExpression = this.douglasRachford(this.basePoints);
        }
        return this.quadricExpression;
    }

    public EllipsoidOverlay generateEllipsoid() {
        try {
            this.quadricExpressionMicro = this.douglasRachford(this.basePointsMicro);
            this.quadricExpression = this.douglasRachford(this.basePoints);
        }
        catch (IllegalArgumentException e) {
            MessageDialog.showDialog((String)"No acceptable fitting ellipsoid could be found for this set of point", (int)0);
            Points.clear();
            return new EllipsoidOverlay();
        }
        catch (RuntimeException e) {
            MessageDialog.showDialog((String)"The original point configuration was not correct. Please try again");
            Points.clear();
            return new EllipsoidOverlay();
        }
        return this.getOverlay();
    }

    public EllipsoidOverlay generateEllipsoid(QuadricExpression quadric, QuadricExpression quadricMicro) {
        this.quadricExpression = quadric;
        this.quadricExpressionMicro = quadricMicro;
        this.quadricExpressionMicro.getRealParameters();
        this.quadricExpression.getRealParameters();
        return this.getOverlay();
    }

    private EllipsoidOverlay getOverlay() {
        this.quadricExpression.getRealParameters();
        this.realCenter = new vtkPoints();
        this.realCenter.InsertNextPoint(this.quadricExpression.getCenterMat().getColumnPackedCopy());
        EllipsoidOverlay ret = new EllipsoidOverlay(this.quadricExpression.getMatSR(), this.realCenter);
        ret.saveQuadric(this.quadricExpression, this.quadricExpressionMicro);
        ret.setEllipsoid(new Ellipsoid(this.quadricExpression));
        ret.setCanBeRemoved(true);
        ret.setPersistent(false);
        ret.setReadOnly(false);
        return ret;
    }
}

