/*
 * Decompiled with CFR 0.152.
 */
package kovac.shapes;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import icy.sequence.DimensionId;
import kovac.maths.EllipsoidAlgorithm;

public class Ellipse {
    private double xCenter;
    private double yCenter;
    private double semiWidth;
    private double semiHeight;
    private double angleWithAxis;
    private DimensionId dim;
    private boolean isGenerated;
    private double[] quadCoeffs;

    public Ellipse(double[] quadCoeffs) {
        this.quadCoeffs = quadCoeffs;
    }

    public DimensionId getDim() {
        return this.dim;
    }

    public void setDim(DimensionId dim) {
        this.dim = dim;
    }

    private void generateParams() {
        Matrix matEll = new Matrix(2, 2);
        matEll.set(0, 0, this.quadCoeffs[0]);
        matEll.set(0, 1, this.quadCoeffs[2] / 2.0);
        matEll.set(1, 0, this.quadCoeffs[2] / 2.0);
        matEll.set(1, 1, this.quadCoeffs[1]);
        Matrix lastCoeffs = new Matrix(2, 1);
        lastCoeffs.set(0, 0, this.quadCoeffs[3] / 2.0);
        lastCoeffs.set(1, 0, this.quadCoeffs[4] / 2.0);
        Matrix centerMat = EllipsoidAlgorithm.proxf1(matEll, lastCoeffs.times(-1.0));
        this.xCenter = centerMat.get(0, 0);
        this.yCenter = centerMat.get(1, 0);
        Matrix scalarMat = matEll.times(centerMat);
        scalarMat = centerMat.transpose().times(scalarMat);
        double scalar = scalarMat.getColumnPackedCopy()[0];
        double alpha = 1.0 / (scalar - this.quadCoeffs[5]);
        matEll = matEll.times(alpha);
        SingularValueDecomposition svd = matEll.svd();
        Matrix semiLength = svd.getS();
        this.semiWidth = Math.sqrt(1.0 / semiLength.get(0, 0));
        this.semiHeight = Math.sqrt(1.0 / semiLength.get(1, 1));
        Matrix vectors = svd.getU();
        double xCoeff = vectors.get(0, 0);
        double yCoeff = vectors.get(1, 0);
        this.angleWithAxis = Math.atan(yCoeff / xCoeff);
        if (this.dim == DimensionId.X) {
            this.angleWithAxis = Math.atan(xCoeff / yCoeff);
            this.xCenter = centerMat.get(1, 0);
            this.yCenter = centerMat.get(0, 0);
        }
        this.isGenerated = true;
    }

    public double[] getParams() {
        if (!this.isGenerated) {
            this.generateParams();
        }
        return new double[]{this.xCenter, this.yCenter, this.semiWidth, this.semiHeight, this.angleWithAxis};
    }
}

