/*
 * Decompiled with CFR 0.152.
 */
package kovac.shapes;

import Jama.Matrix;
import icy.gui.dialog.MessageDialog;
import icy.util.XMLUtil;
import java.util.ArrayList;
import java.util.UUID;
import kovac.maths.EllipsoidAlgorithm;
import kovac.res.quadric.QuadricExpression;
import kovac.res.util.LinkedViewersUtil;
import kovac.saving.SavingStatic;
import kovac.shapes.EllipsoidOverlay;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Ellipsoid {
    private static final String ID_ELLIPSOID = "ellipsoid";
    private static final String ID_ID = "id";
    private static final String ID_NAME = "name";
    private static final String ID_CENTER = "center";
    private static final String[] ID_AXIS = new String[]{"x", "y", "z"};
    private static final String ID_VALUE = "value";
    private static final String ID_DIRECTION_VECTORS = "directionVectors";
    private static final String ID_VECTOR = "vector";
    private static final String ID_COEFF = "coefficient";
    private static final String ID_SEMI = "axisSemiLength";
    private static final String ID_VOLUME = "volume";
    private static final String ID_QUADRIC = "quadricExpression";
    private static final String ID_QUADRIC_MICRO = "quadricExpressionMicrometers";
    private static final String[] ID_QUADRIC_COEFFS = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "a10"};
    private String uniqueID;
    private double[] semiLength;
    private QuadricExpression quadric;
    private QuadricExpression quadricMicro;
    private Matrix vectors;
    private double[] center;
    private double[] bounds;
    private String name;

    public Ellipsoid(QuadricExpression quadric) {
        this.quadric = quadric;
        this.quadric.getRealParameters();
        this.semiLength = this.quadric.getSemiAxis();
        this.vectors = this.quadric.getAxisVector();
        Matrix centerMat = this.quadric.getCenterMat();
        this.center = new double[]{centerMat.get(0, 0), centerMat.get(1, 0), centerMat.get(2, 0)};
        this.uniqueID = UUID.randomUUID().toString();
    }

    public Ellipsoid(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    public double getVolume(double[] semiLength) {
        return Math.PI * semiLength[0] * semiLength[1] * semiLength[2];
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public double[] getCenter() {
        return this.center;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uniqueID == null ? 0 : this.uniqueID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ellipsoid other = (Ellipsoid)obj;
        return !(this.uniqueID == null ? other.uniqueID != null : !this.uniqueID.equals(other.uniqueID));
    }

    public double[] getSemiLength() {
        return this.semiLength;
    }

    public QuadricExpression getQuadric() {
        return this.quadric;
    }

    public void regenerate() {
        if (!LinkedViewersUtil.areSet()) {
            return;
        }
        EllipsoidAlgorithm dummyAlgo = new EllipsoidAlgorithm();
        EllipsoidOverlay e = dummyAlgo.generateEllipsoid(this.quadric, this.quadricMicro);
        e.setName(this.name);
        e.setEllipsoid(this);
        LinkedViewersUtil.addOverlayToVTK(e);
    }

    public boolean saveEllipsoidToXML(Node node) {
        if (node == null) {
            return false;
        }
        ArrayList previousEllipsoids = XMLUtil.getElements((Node)node, (String)ID_ELLIPSOID);
        for (Element e : previousEllipsoids) {
            String id = XMLUtil.getAttributeValue((Element)e, (String)ID_ID, (String)"");
            if (!id.equals(this.uniqueID)) continue;
            return true;
        }
        Element ellipsoid = XMLUtil.addElement((Node)node, (String)ID_ELLIPSOID);
        XMLUtil.setAttributeValue((Element)ellipsoid, (String)ID_ID, (String)this.uniqueID);
        XMLUtil.addElement((Node)ellipsoid, (String)ID_NAME, (String)this.name);
        Element center = XMLUtil.addElement((Node)ellipsoid, (String)ID_CENTER);
        int i = 0;
        while (i < ID_AXIS.length) {
            Element axis = XMLUtil.addElement((Node)center, (String)ID_AXIS[i]);
            XMLUtil.setAttributeDoubleValue((Element)axis, (String)ID_VALUE, (double)this.center[i]);
            ++i;
        }
        Element directionVectors = XMLUtil.addElement((Node)ellipsoid, (String)ID_DIRECTION_VECTORS);
        int i2 = 0;
        while (i2 < 3) {
            Element vector = XMLUtil.addElement((Node)directionVectors, (String)ID_VECTOR);
            int j = 0;
            while (j < ID_AXIS.length) {
                Element axis = XMLUtil.addElement((Node)vector, (String)ID_AXIS[j]);
                XMLUtil.setAttributeDoubleValue((Element)axis, (String)ID_COEFF, (double)this.vectors.get(j, i2));
                ++j;
            }
            ++i2;
        }
        Element axisLength = XMLUtil.addElement((Node)ellipsoid, (String)ID_SEMI);
        int i3 = 0;
        while (i3 < 3) {
            Element value = XMLUtil.addElement((Node)axisLength, (String)ID_AXIS[i3]);
            XMLUtil.setDoubleValue((Element)value, (double)this.semiLength[i3]);
            ++i3;
        }
        Element volume = XMLUtil.addElement((Node)ellipsoid, (String)ID_VOLUME);
        XMLUtil.setAttributeDoubleValue((Element)volume, (String)ID_VALUE, (double)this.getVolume(this.semiLength));
        Element quadric = XMLUtil.addElement((Node)ellipsoid, (String)ID_QUADRIC);
        int i4 = 0;
        while (i4 < ID_QUADRIC_COEFFS.length) {
            Element quadricCoeff = XMLUtil.addElement((Node)quadric, (String)ID_QUADRIC_COEFFS[i4]);
            XMLUtil.setAttributeDoubleValue((Element)quadricCoeff, (String)ID_VALUE, (double)this.quadric.getSimpleArray()[i4]);
            ++i4;
        }
        if (this.quadricMicro == null) {
            MessageDialog.showDialog((String)"One or more ellipsoids could only be saved in pixel units");
            System.out.println(String.valueOf(this.name) + " couldn't only be saved in pixel units");
            return true;
        }
        Element quadricMicro = XMLUtil.addElement((Node)ellipsoid, (String)ID_QUADRIC_MICRO);
        int i5 = 0;
        while (i5 < ID_QUADRIC_COEFFS.length) {
            Element quadricCoeff = XMLUtil.addElement((Node)quadricMicro, (String)ID_QUADRIC_COEFFS[i5]);
            XMLUtil.setAttributeDoubleValue((Element)quadricCoeff, (String)ID_VALUE, (double)this.quadricMicro.getSimpleArray()[i5]);
            ++i5;
        }
        return true;
    }

    public boolean loadEllipsoidFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.name = XMLUtil.getElementValue((Node)node, (String)ID_NAME, (String)"");
        Element quadric = XMLUtil.getElement((Node)node, (String)ID_QUADRIC);
        try {
            Element quadricMicro = XMLUtil.getElement((Node)node, (String)ID_QUADRIC_MICRO);
            ArrayList coeffsMicro = XMLUtil.getElements((Node)quadricMicro);
            double[] quadricCoeffsMicro = new double[10];
            int i = 0;
            while (i < coeffsMicro.size()) {
                quadricCoeffsMicro[i] = XMLUtil.getAttributeDoubleValue((Element)((Element)coeffsMicro.get(i)), (String)ID_VALUE, (double)0.0);
                ++i;
            }
            this.quadricMicro = new QuadricExpression(quadricCoeffsMicro);
        }
        catch (NullPointerException e) {
            MessageDialog.showDialog((String)"One or more ellipsoids could only be loaded in pixel units");
            System.out.println(String.valueOf(this.name) + " could only be loaded in pixel units");
        }
        double[] quadricCoeffs = new double[10];
        ArrayList coeffs = XMLUtil.getElements((Node)quadric);
        int i = 0;
        while (i < coeffs.size()) {
            quadricCoeffs[i] = XMLUtil.getAttributeDoubleValue((Element)((Element)coeffs.get(i)), (String)ID_VALUE, (double)0.0);
            ++i;
        }
        this.quadric = new QuadricExpression(quadricCoeffs);
        this.quadric.getRealParameters();
        this.semiLength = this.quadric.getSemiAxis();
        this.vectors = this.quadric.getAxisVector();
        Matrix centerMat = this.quadric.getCenterMat();
        this.center = new double[]{centerMat.get(0, 0), centerMat.get(1, 0), centerMat.get(2, 0)};
        SavingStatic.saveEllipsoid(this, this.uniqueID);
        return true;
    }

    public String printAsCSV() {
        String res = "";
        res = String.valueOf(res) + this.name + "; Pixels ;";
        int i = 0;
        while (i < 3) {
            res = String.valueOf(res) + this.center[i] + ";";
            ++i;
        }
        double[] vectorsArray = this.vectors.getColumnPackedCopy();
        int i2 = 0;
        while (i2 < vectorsArray.length) {
            res = String.valueOf(res) + vectorsArray[i2] + ";";
            ++i2;
        }
        i2 = 0;
        while (i2 < this.semiLength.length) {
            res = String.valueOf(res) + this.semiLength[i2] + ";";
            ++i2;
        }
        res = String.valueOf(res) + this.getVolume(this.semiLength) + "\n";
        res = String.valueOf(res) + "; Micrometers ;";
        this.quadricMicro.getRealParameters();
        Matrix centerMicroMat = this.quadricMicro.getCenterMat();
        double[] centerMicro = new double[]{centerMicroMat.get(0, 0), centerMicroMat.get(1, 0), centerMicroMat.get(2, 0)};
        Matrix vectorsMicro = this.quadricMicro.getAxisVector();
        double[] semiLengthMicro = this.quadricMicro.getSemiAxis();
        int i3 = 0;
        while (i3 < 3) {
            res = String.valueOf(res) + centerMicro[i3] + ";";
            ++i3;
        }
        double[] vectorsArrayMicro = vectorsMicro.getColumnPackedCopy();
        int i4 = 0;
        while (i4 < vectorsArrayMicro.length) {
            res = String.valueOf(res) + vectorsArrayMicro[i4] + ";";
            ++i4;
        }
        i4 = 0;
        while (i4 < semiLengthMicro.length) {
            res = String.valueOf(res) + semiLengthMicro[i4] + ";";
            ++i4;
        }
        res = String.valueOf(res) + this.getVolume(semiLengthMicro) + "\n\n";
        return res;
    }

    public double[] getBounds() {
        return this.bounds;
    }

    public void setBounds(double[] bounds) {
        this.bounds = bounds;
    }

    public void setMicroQuadric(QuadricExpression micro) {
        this.quadricMicro = micro;
    }
}

