/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.shape.priorshapes.shapes;

import plugins.big.bigsnakeutils.icy.snake2D.Snake2DNode;

/**
 * Shape prior with taking the shape of a semicircle.
 * 
 * @version November 13, 2013
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class Semicircle extends PriorShape {

	public Semicircle() {
		name_ = new String("Semicircle");
		minNumberNodes_ = 16;
		coef_ = new Snake2DNode[minNumberNodes_];
		coef_[0] = new Snake2DNode(636.0, 229.0);
		coef_[1] = new Snake2DNode(644.0, 189.0);
		coef_[2] = new Snake2DNode(639.0, 155.0);
		coef_[3] = new Snake2DNode(607.0, 155.0);
		coef_[4] = new Snake2DNode(573.0, 155.0);
		coef_[5] = new Snake2DNode(542.0, 155.0);
		coef_[6] = new Snake2DNode(509.0, 155.0);
		coef_[7] = new Snake2DNode(477.0, 155.0);
		coef_[8] = new Snake2DNode(444.0, 155.0);
		coef_[9] = new Snake2DNode(436.0, 189.0);
		coef_[10] = new Snake2DNode(444.0, 229.0);
		coef_[11] = new Snake2DNode(466.0, 263.0);
		coef_[12] = new Snake2DNode(500.0, 285.0);
		coef_[13] = new Snake2DNode(541.0, 293.0);
		coef_[14] = new Snake2DNode(580.0, 285.0);
		coef_[15] = new Snake2DNode(614.0, 263.0);
	}
}
