/**
 * Copyright 2010-2017 Perrine Paul-Gilloteaux, CNRS.
 * Perrine.Paul-Gilloteaux@univ-nantes.fr
 * 
 * This file is part of EC-CLEM.
 * 
 * you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 **/



/**
 * AUthor: Perrine.Paul-Gilloteaux@curie.fr
 * Main Class can be used alone or call from another plugin: 
 * will apply the transform content in an xml file as in easyclem,
 * but specifying if the orginal scae has changed (both for source and target)
 */

package plugins.perrine.easyclemv0;



import java.io.File;
import java.util.ArrayList;




import org.w3c.dom.Document;
import org.w3c.dom.Element;

import Jama.Matrix;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.file.Saver;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.preferences.ApplicationPreferences;
import icy.sequence.Sequence;
import icy.util.XMLUtil;


/**
 * 
 * @author Perrine
 *
 */
public class ApplyTransfotoScaledImage extends EzPlug {
	
	EzVarSequence source;
	private EzVarFile xmlFile;
	
	private EzVarInteger sourcebinning;
	private EzVarInteger targetbinning;
	
	@Override
	protected void initialize() {
		// TODO Auto-generated by Icy4Eclipse
		new ToolTipFrame(    			
    			"<html>"+
    			"<br>If you have worked on a resized (reduced) version of source and "+
    			"<br> of target image for time and memory purpose, "+
    			"<br> the transfo computed from this reduced image will be rescale to fit the original size" +
    			"<br> of your source and target images"+
    			"<br><b> Source binning </b> is the reduced scale for source that you used to compute the transfo, "+
    			"<br><b> Target binning </b> is the reduced scale for target that you used to compute the transfo, "+
    			" <br>Example : you have processed reduced size source of 512*512 of a 2048x2048 original source file"+
    			" <br>and a reduced size target of 512*512 of a 4096x4096 original target file"+
    			" <br>Source binning will be 4 (2048/ 512) and target binning will be 8 (4096 / 512)"+
    			"</html>"
    			);

		source=new EzVarSequence("Select Source Image Full Size (will be transformed from xml file)");
		String varName ="Xml file containing list of transformation (computed on reduced images)";
		if (source.getValue()!=null)
			xmlFile=new EzVarFile(varName, source.getValue().getFilename());
		else
			xmlFile=new EzVarFile(varName, ApplicationPreferences.getPreferences().node("frame/imageLoader").get("path", "."));
		sourcebinning= new EzVarInteger("Source Binning ",1, 100, 1);
		targetbinning=new EzVarInteger("Target Binning ",1, 100, 1);
		
		
		addEzComponent(source);
		addEzComponent(xmlFile);
		addEzComponent(sourcebinning);
		addEzComponent(targetbinning);
		
	}
/**
 * play
 */
	@Override
	protected void execute() {
		
	
		Sequence sourceseq=source.getValue();
		double targetsx ;
		double targetsy ;
		double targetsz ;
		//Icy.getMainInterface().addActiveSequenceListener(this);
		//String name=sourceseq.getFilename()+"_transfo.xml";
		if (sourceseq==null){
			MessageDialog.showDialog("Please make sure that your image is opened");
			return;
		}
		Document document = XMLUtil.loadDocument( xmlFile.getValue());
		
		Element root = XMLUtil.getRootElement(document);
		
		try{
		Element newsizeelement = XMLUtil.getElements( root , "TargetSize" ).get(0);
		int width = XMLUtil.getAttributeIntValue( newsizeelement, "width" , -1 );
		int height = XMLUtil.getAttributeIntValue( newsizeelement, "height" , -1 );
		// the following variable will get the default value is the transformation was computed in 2D.
		 targetsx =XMLUtil.getAttributeDoubleValue( newsizeelement, "sx" , -1 );
		 targetsy =XMLUtil.getAttributeDoubleValue( newsizeelement, "sy" , -1 );
		targetsz =XMLUtil.getAttributeDoubleValue( newsizeelement, "sz" , -1 );
		
		int nbz = XMLUtil.getAttributeIntValue( newsizeelement, "nz" , -1 );
		double scalesource=1.0/(double)sourcebinning.getValue();
		double scaletarget=1.0/(double)targetbinning.getValue();
		width=width*targetbinning.getValue();// we als resclae the output param
		height=height*targetbinning.getValue();
		
		Matrix CombinedTransfo=getCombinedTransfo(document,scalesource,scaletarget);
		if (nbz==-1){// it is filled only ion mode 3D, even if the original file was 3D.
			ImageTransformer mytransformer = new ImageTransformer();
			//double mtargetsx=targetsx*1.0/targetbinning.getValue();
			//double mtargetsy=targetsy*1.0/targetbinning.getValue();
			mytransformer.setImageSource(source.getValue());
			mytransformer.setParameters(CombinedTransfo);
			// mytransformer.setParameters(0,0,0,0,scale);
			//double width_s=(double)width/scaletarget;
			//double height_s=(double)height/scaletarget;
			mytransformer.setDestinationsize((int)width,(int)height);
			mytransformer.run();
			/*Stack3DVTKTransformer transfoimage3D=new Stack3DVTKTransformer();
			transfoimage3D.setImageSource(source.getValue(),source.getValue().getSizeX(),source.getValue().getSizeY(), source.getValue().getSizeX());
			transfoimage3D.setDestinationsize(width, height, 1,
					source.getValue().getSizeX(), source.getValue().getSizeY(),source.getValue().getSizeZ());
			transfoimage3D.setParameters(CombinedTransfo,1,1);
			transfoimage3D.run();*/
			
		}
		else {
			SimilarityTransformation3D transfo = getCombinedTransfo3D(document, scalesource, scaletarget);
			
			
			// write xml file
			Matrix transfomat = transfo.getMatrix();

			Stack3DVTKTransformer transfoimage3D=new Stack3DVTKTransformer();
			transfoimage3D.setImageSource(source.getValue(),transfo.getorisizex(),transfo.getorisizey(), transfo.getorisizez());
			transfoimage3D.setDestinationsize(width, height, nbz,
					targetsx, targetsy, targetsz);
			transfoimage3D.setParameters(transfomat,transfo.getscalex(),transfo.getscalez());
			transfoimage3D.run();
			

		}
		}
		catch (Exception e){
			new AnnounceFrame("Do not forget to load the xml file",5);
			return;
		}
		
		
		

		IcyCanvas sourcecanvas = source.getValue().getFirstViewer().getCanvas();
		if (sourcecanvas instanceof IcyCanvas2D)
			((IcyCanvas2D) sourcecanvas).fitCanvasToImage();

		sourceseq.setFilename(sourceseq.getFilename()+" (transformed)");
		sourceseq.setName(sourceseq.getName()+ " (transformed)");
		sourceseq.setPixelSizeX(targetsx*1.0/targetbinning.getValue());
		sourceseq.setPixelSizeY(targetsy*1.0/targetbinning.getValue());
		sourceseq.setPixelSizeZ(targetsz);
		File file=new File(sourceseq.getFilename());
		boolean multipleFiles=false;
		boolean showProgress=true;
		System.out.println("Save as"+sourceseq.getFilename());
		Saver.save(sourceseq, file, multipleFiles, showProgress);
		MessageDialog.showDialog("Transformation have been applied. Image has been renamed and saved, use this one for going on with your alignments");
	}
	private SimilarityTransformation3D getCombinedTransfo3D(Document document,double sourcescale,double targetscale) {
	// TODO Auto-generated method stub
		Element root = XMLUtil.getRootElement(document);

		ArrayList<Element> transfoElementArrayList = XMLUtil.getElements(root,
				"MatrixTransformation");
		// int nbtransfo=transfoElementArrayList.size();
		ArrayList<Matrix> listoftransfo = new ArrayList<Matrix>();
		boolean firsttime=true;
		//Matrix ScaleSourcetransfo=Matrix.identity(4, 4).times(sourcescale);
		//Matrix Scaletargettransfo=Matrix.identity(4, 4).times(1.0/targetscale);
		Matrix ScaleSourcetransfo=Matrix.identity(4, 4).times(sourcescale);
		ScaleSourcetransfo.set(3,3,1.0);
		ScaleSourcetransfo.set(2,2,1.0);//do not touch z
		Matrix Scaletargettransfo=Matrix.identity(4, 4).times(1.0/targetscale);
		Scaletargettransfo.set(3,3,1.0);
		Scaletargettransfo.set(2,2,1.0);//do not touch z
		listoftransfo.add(ScaleSourcetransfo);
		// the default value of orisizex has to the actual pixel size:
		// otherwise during the initialisation (i.e the first tranform 
		//when getcombined transform has nothing to return
		double orisizex=source.getValue().getPixelSizeX();
		double orisizey=source.getValue().getPixelSizeY();
		double orisizez=source.getValue().getPixelSizeZ();
		
		for (Element transfoElement : transfoElementArrayList) {
			double[][] m = new double[4][4];
			// int order = XMLUtil.getAttributeIntValue( transfoElement, "order"
			// , -1 ); //to be check for now only: has to be used!!!
			// the only different pixel size (i.e the orginal source size) is given only at the first transformation
			if (firsttime){
				//orisizex=XMLUtil.getAttributeDoubleValue(transfoElement, "formerpixelsizeX", 0);
				//orisizey=XMLUtil.getAttributeDoubleValue(transfoElement, "formerpixelsizeY", 0);
				//orisizez=XMLUtil.getAttributeDoubleValue(transfoElement, "formerpixelsizeZ", 0);
				firsttime=false;
			}
			
			m[0][0] = XMLUtil.getAttributeDoubleValue(transfoElement, "m00", 0);
			m[0][1] = XMLUtil.getAttributeDoubleValue(transfoElement, "m01", 0);
			m[0][2] = XMLUtil.getAttributeDoubleValue(transfoElement, "m02", 0);
			m[0][3] = XMLUtil.getAttributeDoubleValue(transfoElement, "m03", 0);

			m[1][0] = XMLUtil.getAttributeDoubleValue(transfoElement, "m10", 0);
			m[1][1] = XMLUtil.getAttributeDoubleValue(transfoElement, "m11", 0);
			m[1][2] = XMLUtil.getAttributeDoubleValue(transfoElement, "m12", 0);
			m[1][3] = XMLUtil.getAttributeDoubleValue(transfoElement, "m13", 0);

			m[2][0] = XMLUtil.getAttributeDoubleValue(transfoElement, "m20", 0);
			m[2][1] = XMLUtil.getAttributeDoubleValue(transfoElement, "m21", 0);
			m[2][2] = XMLUtil.getAttributeDoubleValue(transfoElement, "m22", 0);
			m[2][3] = XMLUtil.getAttributeDoubleValue(transfoElement, "m23", 0);

			m[3][0] = XMLUtil.getAttributeDoubleValue(transfoElement, "m30", 0);
			m[3][1] = XMLUtil.getAttributeDoubleValue(transfoElement, "m31", 0);
			m[3][2] = XMLUtil.getAttributeDoubleValue(transfoElement, "m32", 0);
			m[3][3] = XMLUtil.getAttributeDoubleValue(transfoElement, "m33", 0);
			
			Matrix T = new Matrix(m);
			listoftransfo.add(T);

		}
		listoftransfo.add(Scaletargettransfo);
		Matrix CombinedTransfo = Matrix.identity(4, 4);
		for (int i = 0; i < listoftransfo.size(); i++) {
			CombinedTransfo = listoftransfo.get(i).times(CombinedTransfo);
		}
		
		//orisizex=orisizex*sourcescale;
		//orisizey=orisizey*sourcescale;
		//orisizez=orisizez*sourcescale;
		SimilarityTransformation3D resulttransfo=new SimilarityTransformation3D(CombinedTransfo,orisizex,orisizey,orisizez);
		return resulttransfo;
	
}
	/**
	 * not used
	 */
	@Override
	public void clean() {
		// TODO Auto-generated by Icy4Eclipse
	}
	/**
	 * compute (again) the combine transformed to avoid interpolation arrors	
	 * @param document
	 * @return
	 */
	public Matrix getCombinedTransfo(Document document,double sourcescale,double targetscale){
		Element root = XMLUtil.getRootElement(document);




		ArrayList<Element> transfoElementArrayList = XMLUtil.getElements( root , "MatrixTransformation" );

		ArrayList<Matrix> listoftransfo=new ArrayList<Matrix>();
		Matrix ScaleSourcetransfo=Matrix.identity(4, 4).times(sourcescale*sourcescale);
		ScaleSourcetransfo.set(3,3,1.0);
		ScaleSourcetransfo.set(2,2,1.0);//do not touch z
		Matrix Scaletargettransfo=Matrix.identity(4, 4).times(1.0/targetscale);
		Scaletargettransfo.set(3,3,1.0);
		Scaletargettransfo.set(2,2,1.0);//do not touch z
		listoftransfo.add(ScaleSourcetransfo);
		for ( Element transfoElement : transfoElementArrayList )
		{
			double[][] m=new double[4][4];


			m[0][0] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m00" , 0 );
			m[0][1] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m01" , 0 );
			m[0][2] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m02" , 0 );	
			m[0][3] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m03" , 0 );

			m[1][0] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m10" , 0 );
			m[1][1] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m11" , 0 );
			m[1][2]= XMLUtil.getAttributeDoubleValue(  transfoElement, "m12" , 0 );	
			m[1][3] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m13" , 0 );

			m[2][0]= XMLUtil.getAttributeDoubleValue(  transfoElement, "m20" , 0 );
			m[2][1] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m21" , 0 );
			m[2][2] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m22" , 0 );	
			m[2][3] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m23" , 0 );

			m[3][0] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m30" , 0 );
			m[3][1] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m31" , 0 );
			m[3][2] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m32" , 0 );	
			m[3][3] = XMLUtil.getAttributeDoubleValue(  transfoElement, "m33" , 0 );


			Matrix T=new Matrix(m);
			listoftransfo.add(T);


		}
		listoftransfo.add(Scaletargettransfo);
		Matrix CombinedTransfo=Matrix.identity(4, 4);
		for (int i=0;i<listoftransfo.size();i++){
			CombinedTransfo=listoftransfo.get(i).times(CombinedTransfo);
		}
		//CombinedTransfo.times(1.0/CombinedTransfo.get(3, 3));
		return CombinedTransfo;
	}
	/**
	 * get the xml file
	 * @return
	 */
	public Document getdocumentTitle() {
		Document document = XMLUtil.loadDocument( xmlFile.getValue());
		return document;
	}
}
