/*
 * Decompiled with CFR 0.152.
 */
package kovac.shapes;

import icy.painter.Overlay;
import icy.painter.VtkPainter;
import icy.type.point.Point3D;
import java.util.List;
import kovac.res.util.LinkedViewersUtil;
import vtk.vtkActor;
import vtk.vtkCellArray;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;

public class GroupPointsOverlay
extends Overlay
implements VtkPainter {
    private List<Point3D> points;
    private vtkActor groupActor;

    public GroupPointsOverlay(String name, List<Point3D> points) {
        super(name);
        this.points = points;
        this.init();
    }

    private void init() {
        vtkPoints pointsVTK = new vtkPoints();
        vtkCellArray cellArray = new vtkCellArray();
        for (Point3D pt : this.points) {
            this.id = pointsVTK.InsertNextPoint(pt.getX(), pt.getY(), pt.getZ());
            cellArray.InsertNextCell(1);
            cellArray.InsertNextCell(this.id);
        }
        vtkPolyData polyData = new vtkPolyData();
        polyData.SetPoints(pointsVTK);
        polyData.SetVerts(cellArray);
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputData(polyData);
        this.groupActor = new vtkActor();
        this.groupActor.SetMapper((vtkMapper)mapper);
        this.groupActor.SetScale(LinkedViewersUtil.getScale());
        this.groupActor.GetProperty().SetColor(0.0, 1.0, 0.0);
        this.groupActor.GetProperty().SetPointSize(5.0);
        this.groupActor.SetPickable(0);
    }

    public vtkProp[] getProps() {
        return new vtkProp[]{this.groupActor};
    }
}

