package plugins.tprovoost.sequenceblocks.infos;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

/**
 * @author thomasprovoost
 */
public class SetResolution extends Plugin implements SequenceBlock, PluginBundled
{
	private VarSequence varSequence = new VarSequence("Sequence", null);
	private VarDouble pxSizeX = new VarDouble("Pixel Size X (m)", 1d);
	private VarDouble pxSizeY = new VarDouble("Pixel Size Y (m)", 1d);
	private VarDouble pxSizeZ = new VarDouble("Pixel Size Z (m)", 1d);
	private VarDouble timeIntT = new VarDouble("Time interval T (s)", 100d);

	@Override
	public void run()
	{
		Sequence s = varSequence.getValue();

		if (s != null)
		{
			double x = pxSizeX.getValue().doubleValue();
			double y = pxSizeY.getValue().doubleValue();
			double z = pxSizeZ.getValue().doubleValue();
			double ti = timeIntT.getValue().doubleValue();
			if (x != -1)
				s.setPixelSizeX(x);
			if (y != -1)
				s.setPixelSizeY(y);
			if (z != -1)
				s.setPixelSizeZ(z);
			if (ti != -1)
				s.setTimeInterval(ti);
		} else
		{
			throw new VarException(varSequence, "Sequence is null");
		}
	}

	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add("sequence", varSequence);
		inputMap.add("PxSize X (m)", pxSizeX);
		inputMap.add("PxSize Y (m)", pxSizeY);
		inputMap.add("PxSize Z (m)", pxSizeZ);
		inputMap.add("Time interval T (s)", timeIntT);
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
	    //
	}

	@Override
	public String getMainPluginClassName()
	{
		return SequenceBlocks.class.getName();
	}
}
