/*
 * Decompiled with CFR 0.152.
 */
package kovac.shapes;

import icy.painter.Overlay;
import icy.painter.VtkPainter;
import kovac.res.util.LinkedViewersUtil;
import vtk.vtkActor;
import vtk.vtkLineSource;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;

public class AxisOverlay
extends Overlay
implements VtkPainter {
    private double xCoord;
    private double yCoord;
    private double zCoord;
    private vtkActor lineXY;
    private vtkActor lineXZ;
    private vtkActor lineYZ;

    public AxisOverlay(String name, double[] pointCoordinates) {
        super(name);
        this.xCoord = pointCoordinates[0];
        this.yCoord = pointCoordinates[1];
        this.zCoord = pointCoordinates[2];
        this.init();
    }

    private void init() {
        vtkLineSource[] lineSources = new vtkLineSource[]{new vtkLineSource(), new vtkLineSource(), new vtkLineSource()};
        double[] maxCoords = LinkedViewersUtil.getSizes();
        lineSources[0].SetPoint1(this.xCoord, this.yCoord, 0.0);
        lineSources[0].SetPoint2(this.xCoord, this.yCoord, maxCoords[2]);
        lineSources[1].SetPoint1(this.xCoord, 0.0, this.zCoord);
        lineSources[1].SetPoint2(this.xCoord, maxCoords[1], this.zCoord);
        lineSources[2].SetPoint1(0.0, this.yCoord, this.zCoord);
        lineSources[2].SetPoint2(maxCoords[0], this.yCoord, this.zCoord);
        vtkPolyDataMapper[] mappers = new vtkPolyDataMapper[]{new vtkPolyDataMapper(), new vtkPolyDataMapper(), new vtkPolyDataMapper()};
        vtkActor[] actors = new vtkActor[]{new vtkActor(), new vtkActor(), new vtkActor()};
        int i = 0;
        while (i < 3) {
            mappers[i].SetInputConnection(lineSources[i].GetOutputPort());
            actors[i].SetMapper((vtkMapper)mappers[i]);
            actors[i].GetProperty().SetColor(255.0, 0.0, 0.0);
            actors[i].SetScale(LinkedViewersUtil.getScale());
            ++i;
        }
        this.lineXY = actors[0];
        this.lineXZ = actors[1];
        this.lineYZ = actors[2];
    }

    public vtkProp[] getProps() {
        return new vtkProp[]{this.lineXY, this.lineXZ, this.lineYZ};
    }
}

