/*
 * Decompiled with CFR 0.152.
 */
package kovac.res.quadric;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import icy.sequence.DimensionId;
import icy.type.point.Point3D;

public class QuadricExpression {
    private Matrix coefficients;
    private Matrix matSR;
    private Matrix centerMat;
    private Matrix axisVector;
    private double xSemiLength;
    private double ySemiLength;
    private double zSemiLength;

    public QuadricExpression(Matrix coefficients) {
        this.coefficients = coefficients;
    }

    public QuadricExpression(double[] coefficients) {
        if (coefficients.length != 10) {
            throw new IllegalArgumentException("Needs 10 factors to build a QuadricExpression");
        }
        double[][] matArrayCoeffs = new double[10][1];
        int i = 0;
        while (i < 10) {
            matArrayCoeffs[i] = new double[]{coefficients[i]};
            ++i;
        }
        this.coefficients = new Matrix(matArrayCoeffs);
    }

    public void setCoefficients(double[] coeffs) {
        if (coeffs.length != 10) {
            throw new RuntimeException("Needs 10 factors to build a QuadricExpression");
        }
        double[][] matArrayCoeffs = new double[10][1];
        int i = 0;
        while (i < 10) {
            matArrayCoeffs[i] = new double[]{coeffs[i]};
            ++i;
        }
        this.coefficients = new Matrix(matArrayCoeffs);
    }

    public Matrix getCoefficients() {
        return this.coefficients;
    }

    public double[] getSimpleArray() {
        return this.coefficients.getColumnPackedCopy();
    }

    private void updateMatAndCenter(double[] arrayQ) {
        this.matSR.set(0, 0, arrayQ[0]);
        this.matSR.set(0, 1, arrayQ[3]);
        this.matSR.set(0, 2, arrayQ[4]);
        this.matSR.set(1, 0, arrayQ[3]);
        this.matSR.set(1, 1, arrayQ[1]);
        this.matSR.set(1, 2, arrayQ[5]);
        this.matSR.set(2, 0, arrayQ[4]);
        this.matSR.set(2, 1, arrayQ[5]);
        this.matSR.set(2, 2, arrayQ[2]);
        Matrix b = new Matrix(3, 1);
        b.set(0, 0, arrayQ[6] / 2.0);
        b.set(1, 0, arrayQ[7] / 2.0);
        b.set(2, 0, arrayQ[8] / 2.0);
        b = b.times(-1.0);
        this.centerMat = this.matSR.solve(b);
    }

    public void getRealParameters() {
        this.matSR = new Matrix(3, 3);
        double[] arrayQ = this.getSimpleArray();
        this.updateMatAndCenter(arrayQ);
        Matrix scalarMat = this.matSR.times(this.centerMat);
        scalarMat = scalarMat.transpose();
        scalarMat = scalarMat.times(this.centerMat);
        double r2 = scalarMat.get(0, 0) - arrayQ[9];
        Matrix tmp = new Matrix(this.matSR.getArray());
        SingularValueDecomposition svd = tmp.svd();
        Matrix S = svd.getS();
        Matrix U = svd.getU();
        double[][] st = new double[3][3];
        this.xSemiLength = Math.sqrt(r2 / S.get(0, 0));
        this.ySemiLength = Math.sqrt(r2 / S.get(1, 1));
        this.zSemiLength = Math.sqrt(r2 / S.get(2, 2));
        this.axisVector = U;
        st[0][0] = this.xSemiLength * 2.0;
        st[1][1] = this.ySemiLength * 2.0;
        st[2][2] = this.zSemiLength * 2.0;
        st[0][1] = 0.0;
        st[0][2] = 0.0;
        st[1][0] = 0.0;
        st[1][2] = 0.0;
        st[2][0] = 0.0;
        st[2][1] = 0.0;
        S = new Matrix(st);
        this.matSR = U.times(S.times(U.transpose()));
    }

    public void updateQuadric(Matrix matSR, Matrix centerMat) {
        this.matSR = matSR;
        this.centerMat = centerMat;
        this.coefficients = new Matrix(10, 1);
    }

    public Matrix getMatSR() {
        if (this.matSR == null) {
            this.getRealParameters();
        }
        return this.matSR;
    }

    public Matrix getCenterMat() {
        return this.centerMat;
    }

    public Matrix getAxisVector() {
        return this.axisVector;
    }

    public double[] getSemiAxis() {
        return new double[]{this.xSemiLength, this.ySemiLength, this.zSemiLength};
    }

    public double[] getIntersection(DimensionId dim, double[] truePos) {
        double[] coeffs = new double[6];
        double[] originalCoeffs = this.getSimpleArray();
        switch (dim) {
            case X: {
                double fixedCoordinate = truePos[0];
                coeffs[0] = originalCoeffs[1];
                coeffs[1] = originalCoeffs[2];
                coeffs[2] = originalCoeffs[5];
                coeffs[3] = originalCoeffs[3] * fixedCoordinate + originalCoeffs[7];
                coeffs[4] = originalCoeffs[4] * fixedCoordinate + originalCoeffs[8];
                coeffs[5] = originalCoeffs[0] * (fixedCoordinate * fixedCoordinate) + originalCoeffs[6] * fixedCoordinate + originalCoeffs[9];
                break;
            }
            case Y: {
                double fixedCoordinate = truePos[1];
                coeffs[0] = originalCoeffs[0];
                coeffs[1] = originalCoeffs[2];
                coeffs[2] = originalCoeffs[4];
                coeffs[3] = originalCoeffs[3] * fixedCoordinate + originalCoeffs[6];
                coeffs[4] = originalCoeffs[5] * fixedCoordinate + originalCoeffs[8];
                coeffs[5] = originalCoeffs[1] * (fixedCoordinate * fixedCoordinate) + originalCoeffs[7] * fixedCoordinate + originalCoeffs[9];
                break;
            }
            case Z: {
                double fixedCoordinate = truePos[2];
                coeffs[0] = originalCoeffs[0];
                coeffs[1] = originalCoeffs[1];
                coeffs[2] = originalCoeffs[3];
                coeffs[3] = originalCoeffs[4] * fixedCoordinate + originalCoeffs[6];
                coeffs[4] = originalCoeffs[5] * fixedCoordinate + originalCoeffs[7];
                coeffs[5] = originalCoeffs[2] * (fixedCoordinate * fixedCoordinate) + originalCoeffs[8] * fixedCoordinate + originalCoeffs[9];
                break;
            }
        }
        return coeffs;
    }

    public boolean isInsideQuadric(Point3D pt) {
        double z;
        double y;
        double x;
        if (pt == null) {
            return false;
        }
        double[] simpleArray = this.getSimpleArray();
        return simpleArray[0] * ((x = pt.getX()) * x) + simpleArray[1] * ((y = pt.getY()) * y) + simpleArray[2] * ((z = pt.getZ()) * z) + 2.0 * simpleArray[3] * x * y + 2.0 * simpleArray[4] * x * z + 2.0 * simpleArray[5] * z * y + simpleArray[6] * x + simpleArray[7] * y + simpleArray[8] * z + simpleArray[9] <= 0.0;
    }
}

