/*
 * Decompiled with CFR 0.152.
 */
package kovac.res.util;

import Jama.Matrix;
import icy.sequence.DimensionId;
import icy.type.point.Point3D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import kovac.res.Points;
import kovac.res.enums.Methods;
import kovac.res.util.LinkedViewersUtil;
import kovac.res.util.MathUtils;
import kovac.saving.SavingStatic;
import kovac.shapes.Ellipsoid;
import plugins.weiss.fitellipsoid.fitellipsoid;

public class PaintersUtil {
    private static Shape eraserZone;

    public static void paintIntersection(Graphics2D g2, DimensionId dim, double[] truePos) {
        ArrayList<Ellipsoid> ellipsoids = new ArrayList<Ellipsoid>(SavingStatic.getAllEllipsoids());
        double x = truePos[0];
        double y = truePos[1];
        double z = truePos[2];
        Font myFont = new Font("Serif", 2, 4);
        g2.setFont(myFont);
        switch (dim) {
            case X: {
                for (Ellipsoid e : ellipsoids) {
                    double c;
                    double cb;
                    double zm;
                    double b3;
                    double b3b;
                    Matrix M = e.getQuadric().getCoefficients();
                    double a11 = M.get(0, 0);
                    double a22 = M.get(1, 0);
                    double a33 = M.get(2, 0);
                    double a12 = M.get(3, 0);
                    double a13 = M.get(4, 0);
                    double a23 = M.get(5, 0);
                    double b1 = M.get(6, 0);
                    double b2 = M.get(7, 0);
                    double b2b = b2 + 2.0 * a12 * x;
                    double ym = -1.0 / (a22 * a33 - a23 * a23) * (a33 * b2b / 2.0 - a23 * (b3b = (b3 = M.get(8, 0)) + 2.0 * a13 * x) / 2.0);
                    double val = a22 * ym * ym + a33 * (zm = -1.0 / (a22 * a33 - a23 * a23) * (-a23 * b2b / 2.0 + a22 * b3b / 2.0)) * zm + 2.0 * a23 * ym * zm + b2b * ym + b3b * zm + (cb = (c = M.get(9, 0)) + a11 * x * x + b1 * x);
                    if (!(val <= -1.0E-10)) continue;
                    double D = Math.sqrt((a22 - a33) * (a22 - a33) + 4.0 * a23 * a23);
                    double sigma1 = 0.5 * (a22 + a33 + D);
                    double sigma2 = 0.5 * (a22 + a33 - D);
                    double r2 = (a22 * ym + a23 * zm) * ym + (a23 * ym + a33 * zm) * zm - cb;
                    double l1 = Math.sqrt(r2 / sigma1);
                    double l2 = Math.sqrt(r2 / sigma2);
                    double[] v1 = new double[]{2.0 * a23, a33 - a22 + D};
                    double theta = Math.atan2(-v1[1], v1[0]) - 1.5707963267948966;
                    Shape ellipse = new Ellipse2D.Double(-l1, -l2, 2.0 * l1, 2.0 * l2);
                    ellipse = AffineTransform.getRotateInstance(theta).createTransformedShape(ellipse);
                    ellipse = AffineTransform.getTranslateInstance(zm, ym).createTransformedShape(ellipse);
                    g2.draw(ellipse);
                    g2.fill(ellipse);
                    String numberOnly = e.getName().replaceAll("[^0-9]", "");
                    g2.drawString(numberOnly, (int)zm, (int)ym);
                }
                break;
            }
            case Y: {
                for (Ellipsoid e : ellipsoids) {
                    double c;
                    double cb;
                    double zm;
                    Matrix M = e.getQuadric().getCoefficients();
                    double a11 = M.get(0, 0);
                    double a22 = M.get(1, 0);
                    double a33 = M.get(2, 0);
                    double a12 = M.get(3, 0);
                    double a13 = M.get(4, 0);
                    double a23 = M.get(5, 0);
                    double b1 = M.get(6, 0);
                    double b2 = M.get(7, 0);
                    double b1b = b1 + 2.0 * a12 * y;
                    double b3 = M.get(8, 0);
                    double b3b = b3 + 2.0 * a23 * y;
                    double xm = -1.0 / (a11 * a33 - a13 * a13) * (a33 * b1b / 2.0 - a13 * b3b / 2.0);
                    double val = a11 * xm * xm + a33 * (zm = -1.0 / (a11 * a33 - a13 * a13) * (-a13 * b1b / 2.0 + a11 * b3b / 2.0)) * zm + 2.0 * a13 * xm * zm + b1b * xm + b3b * zm + (cb = (c = M.get(9, 0)) + a22 * y * y + b2 * y);
                    if (!(val <= -1.0E-10)) continue;
                    double D = Math.sqrt((a11 - a33) * (a11 - a33) + 4.0 * a13 * a13);
                    double sigma1 = 0.5 * (a11 + a33 + D);
                    double sigma2 = 0.5 * (a11 + a33 - D);
                    double r2 = (a11 * xm + a13 * zm) * xm + (a13 * xm + a33 * zm) * zm - cb;
                    double l1 = Math.sqrt(r2 / sigma1);
                    double l2 = Math.sqrt(r2 / sigma2);
                    double[] v1 = new double[]{2.0 * a13, a33 - a11 + D};
                    double theta = -Math.atan2(-v1[1], v1[0]);
                    Shape ellipse = new Ellipse2D.Double(-l1, -l2, 2.0 * l1, 2.0 * l2);
                    ellipse = AffineTransform.getRotateInstance(theta).createTransformedShape(ellipse);
                    ellipse = AffineTransform.getTranslateInstance(xm, zm).createTransformedShape(ellipse);
                    g2.draw(ellipse);
                    g2.fill(ellipse);
                    String numberOnly = e.getName().replaceAll("[^0-9]", "");
                    g2.drawString(numberOnly, (int)xm, (int)zm);
                }
                break;
            }
            case Z: {
                for (Ellipsoid e : ellipsoids) {
                    Matrix M = e.getQuadric().getCoefficients();
                    double a11 = M.get(0, 0);
                    double a22 = M.get(1, 0);
                    double a33 = M.get(2, 0);
                    double a12 = M.get(3, 0);
                    double a13 = M.get(4, 0);
                    double a23 = M.get(5, 0);
                    double b1 = M.get(6, 0);
                    double b2 = M.get(7, 0);
                    double b3 = M.get(8, 0);
                    double b1b = b1 + 2.0 * a13 * z;
                    double b2b = b2 + 2.0 * a23 * z;
                    double xm = -1.0 / (a11 * a22 - a12 * a12) * (a22 * b1b / 2.0 - a12 * b2b / 2.0);
                    double ym = -1.0 / (a11 * a22 - a12 * a12) * (-a12 * b1b / 2.0 + a11 * b2b / 2.0);
                    double c = M.get(9, 0);
                    double cb = c + a33 * z * z + b3 * z;
                    double val = a11 * xm * xm + a22 * ym * ym + 2.0 * a12 * xm * ym + b1b * xm + b2b * ym + cb;
                    if (!(val <= -1.0E-10)) continue;
                    double D = Math.sqrt((a11 - a22) * (a11 - a22) + 4.0 * a12 * a12);
                    double sigma1 = 0.5 * (a11 + a22 + D);
                    double sigma2 = 0.5 * (a11 + a22 - D);
                    double r2 = (a11 * xm + a12 * ym) * xm + (a12 * xm + a22 * ym) * ym - cb;
                    double l1 = Math.sqrt(r2 / sigma1);
                    double l2 = Math.sqrt(r2 / sigma2);
                    double[] v1 = new double[]{2.0 * a12, a22 - a11 + D};
                    double theta = -Math.atan2(-v1[1], v1[0]);
                    Shape ellipse = new Ellipse2D.Double(-l1, -l2, 2.0 * l1, 2.0 * l2);
                    ellipse = AffineTransform.getRotateInstance(theta).createTransformedShape(ellipse);
                    ellipse = AffineTransform.getTranslateInstance(xm, ym).createTransformedShape(ellipse);
                    g2.draw(ellipse);
                    g2.fill(ellipse);
                    String numberOnly = e.getName().replaceAll("[^0-9]", "");
                    g2.drawString(numberOnly, (int)xm, (int)ym);
                }
                break;
            }
        }
    }

    public static boolean isInsideEraser(Point3D pt, DimensionId dim) {
        if (eraserZone == null) {
            return false;
        }
        return eraserZone.contains(PaintersUtil.translatePoint(pt, dim));
    }

    public static Point2D translatePoint(Point3D pt, DimensionId dim) {
        Point2D.Double ptReturn = null;
        double[] scale = LinkedViewersUtil.getScale();
        double minScale = MathUtils.min(scale);
        switch (dim) {
            case X: {
                ptReturn = new Point2D.Double(pt.getZ() * (scale[2] / minScale), pt.getY() * (scale[1] / minScale));
                break;
            }
            case Y: {
                ptReturn = new Point2D.Double(pt.getX() * (scale[0] / minScale), pt.getZ() * (scale[2] / minScale));
                break;
            }
            case Z: {
                ptReturn = new Point2D.Double(pt.getX() * (scale[0] / minScale), pt.getY() * (scale[1] / minScale));
                break;
            }
        }
        return ptReturn;
    }

    public static void paintPoints(Graphics2D g2, DimensionId currentDimension, double[] truePos) {
        if (fitellipsoid.getChosenMethod() == Methods.POINTS) {
            g2.setColor(Color.RED);
            Rectangle2D.Double point = null;
            double[] scale = LinkedViewersUtil.getScale();
            double minScale = MathUtils.min(scale);
            for (Points.PointInSpace pt : Points.getAllPoints()) {
                if (pt.getDim() != currentDimension) continue;
                switch (currentDimension) {
                    case X: {
                        if (pt.getPoint().getX() != truePos[0]) break;
                        point = new Rectangle2D.Double(pt.getPoint().getZ() * (scale[2] / minScale), pt.getPoint().getY() * (scale[1] / minScale), 1.0, 1.0);
                        break;
                    }
                    case Y: {
                        if (pt.getPoint().getY() != truePos[1]) break;
                        point = new Rectangle2D.Double(pt.getPoint().getX() * (scale[0] / minScale), pt.getPoint().getZ() * (scale[2] / minScale), 1.0, 1.0);
                        break;
                    }
                    case Z: {
                        if (pt.getPoint().getZ() != truePos[2]) break;
                        point = new Rectangle2D.Double(pt.getPoint().getX() * (scale[0] / minScale), pt.getPoint().getY() * (scale[1] / minScale), 1.0, 1.0);
                        break;
                    }
                }
                if (point == null) continue;
                g2.draw(point);
                g2.fill(point);
            }
        }
    }

    public static void paintEraser(Graphics2D g2, DimensionId currentDimension, Point2D startDrag, Point2D endDrag, Point2D crossPosition) {
        g2.setColor(Color.LIGHT_GRAY);
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        if (startDrag == null || endDrag == null) {
            if (crossPosition == null) {
                return;
            }
            Line2D.Double lineHorizontal = new Line2D.Double(crossPosition.getX() - 2.0, crossPosition.getY(), crossPosition.getX() + 2.0, crossPosition.getY());
            Line2D.Double lineVertical = new Line2D.Double(crossPosition.getX(), crossPosition.getY() - 2.0, crossPosition.getX(), crossPosition.getY() + 2.0);
            g2.draw(lineVertical);
            g2.draw(lineHorizontal);
            return;
        }
        PaintersUtil.makeRectangle(startDrag.getX(), startDrag.getY(), endDrag.getX(), endDrag.getY());
        g2.draw(eraserZone);
        g2.setColor(Color.WHITE);
        g2.fill(eraserZone);
    }

    public static void eraseRectangle() {
        eraserZone = null;
    }

    private static void makeRectangle(double x1, double y1, double x2, double y2) {
        eraserZone = new Rectangle2D.Double(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1 - x2), Math.abs(y1 - y2));
    }
}

