/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.icy.gui.curve;

import java.awt.geom.Point2D;
import java.util.Vector;

import plugins.adufour.ezplug.EzVar;
import plugins.adufour.vars.gui.model.VarEditorModel;

/**
 * EzVar for Curve objects.
 * 
 * @version May 3, 2014
 * 
 * @author Julien Jacquemot
 */
public class EzVarCurve extends EzVar<Curve> {
	protected EzVarCurve(VarCurve variable, VarEditorModel<Curve> constraint) {
		super(variable, constraint);
	}

	protected EzVarCurve(VarCurve variable, Curve[] defaultValues,
			int defaultValueIndex, boolean allowUserInput) {
		super(variable, defaultValues, defaultValueIndex, allowUserInput);
	}

	/**
	 * EzVarCurve for PolynomialCurve (convenient class)
	 * 
	 * @author Julien Jacquemot
	 * 
	 */
	public static class Polynomial extends EzVarCurve {
		/** Constructs an empty variable with the given name. */
		public Polynomial(String name) {
			this(name, new Vector<Point2D>());
		}

		/** Constructs a variable using a set of control points. */
		public Polynomial(String name, final Vector<Point2D> points) {
			this(new VarCurve(name, new PolynomialCurve(points)),
					new CurveModel(new PolynomialCurve(points)));
		}

		/**
		 * Constructs a variable specifying the position of the first and last
		 * points of the curve.
		 */
		public Polynomial(String name, double y0, double y1) {
			this(new VarCurve(name, new PolynomialCurve(y0, y1)),
					new CurveModel(new PolynomialCurve(y0, y1)));
		}

		protected Polynomial(VarCurve variable, VarEditorModel<Curve> constraint) {
			super(variable, constraint);
		}

		protected Polynomial(VarCurve variable,
				PolynomialCurve[] defaultValues, int defaultValueIndex,
				boolean allowUserInput) {
			super(variable, defaultValues, defaultValueIndex, allowUserInput);
		}
	}
}
