package plugins.tprovoost.sequenceblocks.files;

import icy.file.Loader;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.sequence.MetaDataUtil;

import java.io.File;

import loci.formats.ome.OMEXMLMetadataImpl;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

public class LoadMetadata extends Plugin implements SequenceBlock, PluginLibrary, PluginBundled
{
    VarMutable f_in = new VarMutable("File", null)
    {
        @Override
        public boolean isAssignableFrom(@SuppressWarnings("rawtypes") Var source)
        {
            return (String.class == source.getType()) || (File.class == source.getType());
        }
    };
    Var<OMEXMLMetadataImpl> output = new Var<OMEXMLMetadataImpl>("Metadata", OMEXMLMetadataImpl.class);
    VarInteger numSerie = new VarInteger("Serie number", 1);

    @Override
    public void run()
    {
        final Object obj = f_in.getValue();
        if (obj != null)
        {
            final File f;

            if (obj instanceof String)
                f = new File((String) obj);
            else
                f = (File) obj;

            try
            {
                final OMEXMLMetadataImpl meta = Loader.getMetaData(f.getAbsolutePath());

                if (meta != null)
                {
                    output.setValue(meta);
                    numSerie.setValue(Integer.valueOf(MetaDataUtil.getNumSerie(meta)));
                }
            }
            catch (Exception e)
            {
                throw new VarException(null, e.getMessage());
            }
        }
    }

    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("file", f_in);
    }

    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("Metadata", output);
        outputMap.add("Serie number", numSerie);
    }

    @Override
    public String getMainPluginClassName()
    {
        return SequenceBlocks.class.getName();
    }
}
