/*
 * Decompiled with CFR 0.152.
 */
package kovac.gui.panels;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kovac.gui.res.IntegerField;
import kovac.res.EllipsoidTransformations;
import kovac.res.enums.Axis;
import kovac.shapes.EllipsoidOverlay;

public class TransformationPanel
extends JPanel {
    private static final String translation = "Translation";
    private static final String scaling = "Scaling";
    private static final String rotation = "Rotation";
    private static final long serialVersionUID = 1L;
    private EllipsoidOverlay overlay;
    private EllipsoidTransformations transform;

    public TransformationPanel(EllipsoidOverlay o) {
        if (o != null) {
            this.overlay = o;
            this.transform = this.overlay.getTransform();
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(translation, new ContentPanel(translation));
        tabbedPane.addTab(scaling, new ContentPanel(scaling));
        tabbedPane.addTab(rotation, new ContentPanel(rotation));
        this.add(tabbedPane);
    }

    private class ContentPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private String title;
        private double value;
        private JCheckBox axisX;
        private JCheckBox axisY;
        private JCheckBox axisZ;
        private JButton buttonPlus;
        private JButton buttonMinus;
        private JButton buttonValidate;
        private JButton buttonCancel;
        private JTextField fieldValue;

        public ContentPanel(String title) {
            this.title = title;
            this.initComponents();
            this.initListeners();
        }

        private void initComponents() {
            this.axisX = new JCheckBox("Axis X", false);
            this.axisY = new JCheckBox("Axis Y", false);
            this.axisZ = new JCheckBox("Axis Z", false);
            this.buttonPlus = new JButton("Plus");
            this.buttonMinus = new JButton("Minus");
            this.buttonValidate = new JButton("Validate");
            this.buttonCancel = new JButton("Cancel");
            this.fieldValue = new IntegerField("1.0");
            this.value = 1.0;
            this.fieldValue.setHorizontalAlignment(0);
            this.fieldValue.setMaximumSize(new Dimension(50, 15));
            this.setLayout(new GridLayout(3, 3, 3, 3));
            this.setBorder(new EmptyBorder(3, 3, 3, 3));
            this.add(this.axisX);
            this.add(this.axisY);
            this.add(this.axisZ);
            this.add(this.buttonMinus);
            this.add(this.fieldValue);
            this.add(this.buttonPlus);
            this.add(this.buttonCancel);
            this.add(new JPanel());
            this.add(this.buttonValidate);
        }

        private void initListeners() {
            this.axisX.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            this.fieldValue.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changeValue();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changeValue();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.changeValue();
                }

                private void changeValue() {
                    try {
                        ContentPanel.this.value = Double.parseDouble(ContentPanel.this.fieldValue.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.buttonPlus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ContentPanel.this.title.equals(TransformationPanel.translation)) {
                        ContentPanel.this.handleTranslation(ContentPanel.this.value);
                    } else if (ContentPanel.this.title.equals(TransformationPanel.scaling)) {
                        ContentPanel.this.handleScaling(ContentPanel.this.value);
                    } else {
                        ContentPanel.this.handleRotation(ContentPanel.this.value);
                    }
                    TransformationPanel.this.transform.validate();
                }
            });
            this.buttonMinus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ContentPanel.this.title.equals(TransformationPanel.translation)) {
                        ContentPanel.this.handleTranslation(-ContentPanel.this.value);
                    } else if (ContentPanel.this.title.equals(TransformationPanel.scaling)) {
                        ContentPanel.this.handleScaling(-ContentPanel.this.value);
                    } else {
                        ContentPanel.this.handleRotation(-ContentPanel.this.value);
                    }
                    TransformationPanel.this.transform.validate();
                }
            });
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransformationPanel.this.transform.cancel();
                    TransformationPanel.this.transform.validate();
                }
            });
            this.buttonValidate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransformationPanel.this.transform.validate();
                    TransformationPanel.this.overlay.goToGeneric();
                    JFrame fen = (JFrame)TransformationPanel.this.getParent().getParent().getParent().getParent();
                    fen.dispose();
                }
            });
        }

        private void handleTranslation(double value) {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (this.axisX.isSelected()) {
                x = value;
            }
            if (this.axisY.isSelected()) {
                y = value;
            }
            if (this.axisZ.isSelected()) {
                z = value;
            }
            TransformationPanel.this.transform.applyTranslation(x, y, z);
        }

        private void handleScaling(double value) {
            Axis[] selectedAxis = new Axis[3];
            if (this.axisX.isSelected()) {
                selectedAxis[0] = Axis.X;
            }
            if (this.axisY.isSelected()) {
                selectedAxis[1] = Axis.Y;
            }
            if (this.axisZ.isSelected()) {
                selectedAxis[2] = Axis.Z;
            }
            TransformationPanel.this.transform.applyScaling(value, selectedAxis);
        }

        private void handleRotation(double value) {
            ArrayList<Axis> selectedAxis = new ArrayList<Axis>();
            if (this.axisX.isSelected()) {
                selectedAxis.add(Axis.X);
            }
            if (this.axisY.isSelected()) {
                selectedAxis.add(Axis.Y);
            }
            if (this.axisZ.isSelected()) {
                selectedAxis.add(Axis.Z);
            }
            Axis[] axis = new Axis[selectedAxis.size()];
            int i = 0;
            while (i < axis.length) {
                axis[i] = (Axis)((Object)selectedAxis.get(i));
                ++i;
            }
            TransformationPanel.this.transform.applyRotation(value, axis);
        }
    }
}

