/*
 * Decompiled with CFR 0.152.
 */
package kovac.res.gui;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.canvas.IcyCanvasEvent;
import icy.canvas.Layer;
import icy.gui.component.IcySlider;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.lut.LUT;
import icy.painter.Overlay;
import icy.plugin.interface_.PluginCanvas;
import icy.preferences.CanvasPreferences;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.system.thread.SingleProcessor;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.util.EventUtil;
import icy.util.GraphicsUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kovac.res.Points;
import kovac.res.enums.Methods;
import kovac.res.util.LinkedViewersUtil;
import kovac.res.util.PaintersUtil;
import kovac.shapes.AxisOverlay;
import plugins.weiss.fitellipsoid.fitellipsoid;

public class SegOrthoViewer
implements PluginCanvas {
    private boolean isNotDeleting = true;

    public String getCanvasClassName() {
        return SegOrthoViewer.class.getName();
    }

    public IcyCanvas createCanvas(Viewer viewer) {
        return new SegOrthoCanvas(viewer);
    }

    public class SegOrthoCanvas
    extends IcyCanvas2D {
        private final JPanel orthoViewPanel;
        private final SegOrthoView xy;
        private final SegOrthoView zy;
        private final SegOrthoView xz;
        private double xScale;
        private double yScale;
        private final IcySlider zoomSlider;
        private double zoom;
        private boolean crossHairVisible;
        private boolean isLocked;
        private Overlay currentAxis;
        private JCheckBox lock;

        public void setLock(boolean val) {
            this.isLocked = val;
        }

        public JCheckBox getLock() {
            if (this.lock == null) {
                this.lock = new JCheckBox("Lock", false);
                this.lock.setFocusable(false);
                this.lock.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SegOrthoCanvas.this.isLocked = SegOrthoCanvas.this.lock.isSelected();
                        if (!SegOrthoCanvas.this.isLocked) {
                            Points.saveCurrentList();
                        }
                        SegOrthoCanvas.this.refresh();
                    }
                });
            }
            return this.lock;
        }

        public SegOrthoCanvas(Viewer viewer) {
            super(viewer);
            this.xScale = 1.0;
            this.yScale = 1.0;
            this.zoomSlider = new IcySlider(0, 1, 1000, 100);
            this.zoom = 1.0;
            this.crossHairVisible = true;
            this.isLocked = false;
            this.orthoViewPanel = new JPanel(null);
            this.orthoViewPanel.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    int newValue = SegOrthoCanvas.this.zoomSlider.getValue();
                    int steps = e.getWheelRotation() * 10;
                    if (steps < 0) {
                        if ((newValue += -steps) == SegOrthoCanvas.this.zoomSlider.getMaximum()) {
                            newValue = SegOrthoCanvas.this.zoomSlider.getMaximum();
                        }
                    } else {
                        newValue -= steps;
                    }
                    SegOrthoCanvas.this.zoomSlider.setValue(newValue);
                    SegOrthoCanvas.this.repaint();
                }
            });
            this.xy = new SegOrthoView(DimensionId.Z);
            this.xz = new SegOrthoView(DimensionId.Y);
            this.zy = new SegOrthoView(DimensionId.X);
            this.xScale = this.getSequence().getPixelSizeZ() / this.getSequence().getPixelSizeX();
            if (Double.isNaN(this.xScale) || this.xScale == 0.0) {
                this.xScale = 1.0;
            }
            this.yScale = this.getSequence().getPixelSizeZ() / this.getSequence().getPixelSizeY();
            if (Double.isNaN(this.yScale) || this.yScale == 0.0) {
                this.yScale = 1.0;
            }
            this.posX = this.getSequence().getSizeX() / 2;
            this.posY = this.getSequence().getSizeY() / 2;
            this.posZ = this.getSequence().getSizeZ() / 2;
            this.orthoViewPanel.add(this.xy);
            this.orthoViewPanel.add(this.zy);
            this.orthoViewPanel.add(this.xz);
            this.setZoom(1.0);
            JScrollPane scroll = new JScrollPane(this.orthoViewPanel, 20, 30);
            final JScrollBar vertical = scroll.getVerticalScrollBar();
            final JScrollBar horizontal = scroll.getHorizontalScrollBar();
            InputMap mapVert = vertical.getInputMap(2);
            mapVert.put(KeyStroke.getKeyStroke("DOWN"), "actionWhenDown");
            vertical.getActionMap().put("actionWhenDown", new AbstractAction("keyDownAction"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int currentValue = vertical.getValue();
                    vertical.setValue(currentValue + vertical.getMaximum() / 100);
                }
            });
            mapVert.put(KeyStroke.getKeyStroke("UP"), "actionWhenUp");
            vertical.getActionMap().put("actionWhenUp", new AbstractAction("keyUpAction"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int currentValue = vertical.getValue();
                    vertical.setValue(currentValue - vertical.getMaximum() / 100);
                }
            });
            InputMap mapHor = horizontal.getInputMap(2);
            mapHor.put(KeyStroke.getKeyStroke("RIGHT"), "actionWhenRight");
            horizontal.getActionMap().put("actionWhenRight", new AbstractAction("keyRightAction"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int currentValue = horizontal.getValue();
                    horizontal.setValue(currentValue + horizontal.getMaximum() / 100);
                }
            });
            mapHor.put(KeyStroke.getKeyStroke("LEFT"), "actionWhenLeft");
            horizontal.getActionMap().put("actionWhenLeft", new AbstractAction("keyLeftAction"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int currentValue = horizontal.getValue();
                    horizontal.setValue(currentValue - horizontal.getMaximum() / 100);
                }
            });
            this.add(scroll, "Center");
            this.updateTNav();
            this.updateZNav();
            this.getMouseImageInfosPanel().setInfoColorVisible(false);
            this.getMouseImageInfosPanel().setInfoCVisible(false);
            this.getMouseImageInfosPanel().setInfoXVisible(false);
            this.getMouseImageInfosPanel().setInfoYVisible(false);
            this.getMouseImageInfosPanel().setInfoDataVisible(false);
            this.xy.imageChanged();
            this.xz.imageChanged();
            this.zy.imageChanged();
            LinkedViewersUtil.removeAllLinesOverlayFromVTK();
            this.currentAxis = new AxisOverlay("Axis", this.imageCoordinates());
            LinkedViewersUtil.addOverlayToVTK(this.currentAxis);
            this.invalidate();
        }

        public double[] imageCoordinates() {
            return new double[]{this.posX, this.posY, this.posZ};
        }

        public double[] imageRotation2D() {
            return new double[]{this.getRotationX(), this.getRotationY()};
        }

        public void refreshAxis() {
            LinkedViewersUtil.removeAllLinesOverlayFromVTK();
            this.currentAxis = new AxisOverlay("Axis", this.imageCoordinates());
            LinkedViewersUtil.addOverlayToVTK(this.currentAxis);
        }

        public SegOrthoView getXYView() {
            return this.xy;
        }

        public SegOrthoView getXZView() {
            return this.xz;
        }

        public SegOrthoView getZYView() {
            return this.zy;
        }

        public void customizeToolbar(JToolBar toolBar) {
            super.customizeToolbar(toolBar);
            toolBar.removeAll();
            final JCheckBox showCrossHair = new JCheckBox("Crosshair", true);
            showCrossHair.setFocusable(false);
            showCrossHair.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SegOrthoCanvas.this.crossHairVisible = showCrossHair.isSelected();
                    SegOrthoCanvas.this.refresh();
                }
            });
            toolBar.add(showCrossHair);
            final JCheckBox lock = new JCheckBox("Lock", false);
            lock.setFocusable(false);
            lock.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SegOrthoCanvas.this.isLocked = lock.isSelected();
                    if (!SegOrthoCanvas.this.isLocked) {
                        Points.saveCurrentList();
                    }
                    SegOrthoCanvas.this.refresh();
                }
            });
            toolBar.add(this.getLock());
            JLabel sizeLabel = new JLabel("  Zoom:");
            final JLabel zoomValueLabel = new JLabel(String.valueOf(this.zoomSlider.getValue()) + "%");
            this.zoomSlider.setFocusable(false);
            this.zoomSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SegOrthoCanvas.this.setZoom((double)SegOrthoCanvas.this.zoomSlider.getValue() / 100.0);
                    zoomValueLabel.setText(String.valueOf(SegOrthoCanvas.this.zoomSlider.getValue()) + "%");
                }
            });
            toolBar.add(sizeLabel);
            toolBar.add((Component)this.zoomSlider);
            toolBar.add(zoomValueLabel);
        }

        private void setZoom(double newZoom) {
            this.zoom = newZoom;
            int xyWidth = (int)Math.round(newZoom * (double)this.getSequence().getSizeX());
            int xyHeight = (int)Math.round(newZoom * (double)this.getSequence().getSizeY());
            this.xy.setBounds(0, 0, xyWidth, xyHeight);
            this.zy.setBounds(xyWidth + 5, 0, (int)Math.round(newZoom * (double)this.getSequence().getSizeZ() * this.xScale), xyHeight);
            this.xz.setBounds(0, xyHeight + 5, xyWidth, (int)Math.round(newZoom * (double)this.getSequence().getSizeZ() * this.yScale));
            this.orthoViewPanel.setPreferredSize(new Dimension(this.xy.getWidth() + 5 + this.zy.getWidth(), this.xy.getHeight() + 5 + this.xz.getHeight()));
        }

        public Point2D.Double canvasToImage(Point point) {
            return super.canvasToImage(point);
        }

        public void changed(IcyCanvasEvent event) {
            super.changed(event);
            switch (event.getType()) {
                case POSITION_CHANGED: {
                    if (event.getDim() == DimensionId.Z) {
                        this.xy.imageChanged();
                        this.refresh();
                        break;
                    }
                    if (event.getDim() != DimensionId.T) break;
                    this.xy.imageChanged();
                    this.zy.imageChanged();
                    this.xz.imageChanged();
                    this.refresh();
                }
            }
        }

        protected void lutChanged(int component) {
            super.lutChanged(component);
            try {
                if (this.xy != null) {
                    this.xy.imageChanged();
                }
                if (this.zy != null) {
                    this.zy.imageChanged();
                }
                if (this.xz != null) {
                    this.xz.imageChanged();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.refresh();
        }

        protected void mousePositionChanged(DimensionId dim, int x, int y) {
            x = (int)Math.max(0.0, (double)x / this.zoom);
            y = (int)Math.max(0.0, (double)y / this.zoom);
            int maxWidth = this.getSequence().getSizeX() - 1;
            int maxHeight = this.getSequence().getSizeY() - 1;
            int maxDepth = this.getSequence().getSizeZ() - 1;
            switch (dim) {
                case Z: {
                    if (x > maxWidth) {
                        x = maxWidth;
                    }
                    if (x != this.posX) {
                        this.setPositionXInternal(x);
                        this.zy.imageChanged();
                    }
                    if (y > maxHeight) {
                        y = maxHeight;
                    }
                    if (y == this.posY) break;
                    this.setPositionYInternal(y);
                    this.xz.imageChanged();
                    break;
                }
                case Y: {
                    double scale;
                    if (x > maxWidth) {
                        x = maxWidth;
                    }
                    if (x != this.posX) {
                        this.setPositionXInternal(x);
                        this.zy.imageChanged();
                    }
                    if (Double.isNaN(scale = this.getSequence().getPixelSizeZ() / this.getSequence().getPixelSizeX()) || scale == 0.0) {
                        scale = 1.0;
                    }
                    if ((y = (int)((double)y / scale)) > maxDepth) {
                        y = maxDepth;
                    }
                    if (y == this.posZ) break;
                    this.setPositionZInternal(y);
                    this.xy.imageChanged();
                    break;
                }
                case X: {
                    double scale;
                    if (y > maxHeight) {
                        y = maxHeight;
                    }
                    if (y != this.posY) {
                        this.setPositionYInternal(y);
                        this.xz.imageChanged();
                    }
                    if (Double.isNaN(scale = this.getSequence().getPixelSizeZ() / this.getSequence().getPixelSizeY()) || scale == 0.0) {
                        scale = 1.0;
                    }
                    if ((x = (int)((double)x / scale)) > maxDepth) {
                        x = maxDepth;
                    }
                    if (x == this.posZ) break;
                    this.setPositionZInternal(x);
                    this.xy.imageChanged();
                }
            }
            this.refreshAxis();
            this.refresh();
        }

        public void refresh() {
            this.getMouseImageInfosPanel().updateInfos((IcyCanvas)this);
            this.repaint();
        }

        public BufferedImage getRenderedImage(int t, int z, int c, boolean canvasView) {
            Dimension size = this.orthoViewPanel.getPreferredSize();
            BufferedImage snap = new BufferedImage(size.width, size.height, 2);
            Graphics2D g = snap.createGraphics();
            int oldZ = this.getPositionZ();
            int oldT = this.getPositionT();
            this.setPositionZInternal(z);
            this.setPositionTInternal(t);
            this.xy.imageCache.run();
            this.orthoViewPanel.paintAll(g);
            this.setPositionZInternal(oldZ);
            this.setPositionZInternal(oldT);
            return snap;
        }

        public IcyBufferedImage getCurrentImage(DimensionId fixedDim) {
            Sequence seq = this.getSequence();
            int sizeX = seq.getSizeX();
            int sizeY = seq.getSizeY();
            int sizeZ = seq.getSizeZ(this.posT);
            int sizeC = seq.getSizeC();
            if (sizeZ == 0) {
                return null;
            }
            switch (fixedDim) {
                case Z: {
                    return super.getImage(this.posT, this.posZ, -1);
                }
                case Y: {
                    if (this.posY == -1) {
                        return null;
                    }
                    IcyBufferedImage xzImage = new IcyBufferedImage(sizeX, sizeZ, sizeC, seq.getDataType_());
                    int inY = sizeX * this.posY;
                    int out_offset = 0;
                    int inSize = 0;
                    int outSize = 0;
                    try {
                        Object in_z_c_xy = seq.getDataXYCZ(this.posT);
                        Object out_c_xy = xzImage.getDataXYC();
                        int z = 0;
                        while (z < sizeZ) {
                            Object in_c_xy = Array.get(in_z_c_xy, z);
                            if (in_c_xy != null) {
                                out_offset = z * sizeX;
                                int c = 0;
                                while (c < sizeC) {
                                    Object in_xy = Array.get(in_c_xy, c);
                                    inSize = Array.getLength(in_xy);
                                    Object out_xy = Array.get(out_c_xy, c);
                                    outSize = Array.getLength(out_xy);
                                    System.arraycopy(in_xy, inY, out_xy, out_offset, sizeX);
                                    ++c;
                                }
                            }
                            ++z;
                        }
                        return xzImage;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new ArrayIndexOutOfBoundsException("cannot copy from [size=" + inSize + ",off=" + inY + "] to [size=" + outSize + ",off=" + out_offset + "] with size " + sizeX);
                    }
                }
                case X: {
                    IcyBufferedImage zyImage = new IcyBufferedImage(sizeZ, sizeY, sizeC, seq.getDataType_());
                    Object in_z_c_xy = seq.getDataXYCZ(this.posT);
                    Object out_c_xy = zyImage.getDataXYC();
                    ThreadUtil.sleep((int)20);
                    int z = 0;
                    while (z < sizeZ) {
                        Object in_c_xy = Array.get(in_z_c_xy, z);
                        if (in_c_xy != null) {
                            int c = 0;
                            while (c < sizeC) {
                                Object in_xy = Array.get(in_c_xy, c);
                                Object out_xy = Array.get(out_c_xy, c);
                                int y = 0;
                                int in_offset = this.posX;
                                int out_off = z;
                                while (y < sizeY) {
                                    Object pixelIN = Array.get(in_xy, in_offset);
                                    Array.set(out_xy, out_off, pixelIN);
                                    ++y;
                                    in_offset += sizeX;
                                    out_off += sizeZ;
                                }
                                ++c;
                            }
                        }
                        ++z;
                    }
                    return zyImage;
                }
            }
            throw new UnsupportedOperationException();
        }

        public int getPositionC() {
            return -1;
        }

        public void repaint() {
            super.repaint();
            if (this.xy != null) {
                this.xy.repaint();
            }
            if (this.zy != null) {
                this.zy.repaint();
            }
            if (this.xz != null) {
                this.xz.repaint();
            }
        }

        public void keyReleased(KeyEvent e) {
            super.keyReleased(e);
            this.repaint();
        }

        public Component getViewComponent() {
            return null;
        }

        public class SegOrthoView
        extends JPanel
        implements MouseWheelListener,
        MouseListener,
        MouseMotionListener {
            private Timer refreshTimer;
            final ImageCache imageCache;
            private final Font font;
            private final DimensionId currentDimension;
            private Point2D dragStart;
            private Point2D dragEnd;
            private Point2D crossPosition;
            private final Point5D.Double mousePosition;

            public SegOrthoView(DimensionId dim) {
                this.mousePosition = new Point5D.Double((double)SegOrthoCanvas.this.getPositionX(), (double)SegOrthoCanvas.this.getPositionY(), (double)SegOrthoCanvas.this.getPositionZ(), (double)SegOrthoCanvas.this.getPositionT(), (double)SegOrthoCanvas.this.getPositionC());
                this.currentDimension = dim;
                this.imageCache = new ImageCache();
                this.font = new Font("Arial", 1, 16);
                this.addMouseListener(this);
                this.addMouseMotionListener(this);
                this.addMouseWheelListener(this);
                this.getInputMap(2).put(KeyStroke.getKeyStroke("released DELETE"), "Start_Delete");
                this.getActionMap().put("Start_Delete", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        if (SegOrthoCanvas.this.isLocked) {
                            SegOrthoViewer.this.isNotDeleting = false;
                        }
                    }
                });
            }

            @Override
            protected void paintComponent(Graphics g) {
                BufferedImage img;
                double scaleY;
                super.paintComponent(g);
                Sequence seq = SegOrthoCanvas.this.getSequence();
                double sizeZ = seq.getSizeZ(SegOrthoCanvas.this.posT);
                double scaleX = seq.getPixelSizeZ() / seq.getPixelSizeX();
                if (Double.isNaN(scaleX) || scaleX == 0.0) {
                    scaleX = 1.0;
                }
                if (Double.isNaN(scaleY = seq.getPixelSizeZ() / seq.getPixelSizeY()) || scaleY == 0.0) {
                    scaleY = 1.0;
                }
                if ((img = this.imageCache.getImage()) != null) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.scale(SegOrthoCanvas.this.zoom, SegOrthoCanvas.this.zoom);
                    if (CanvasPreferences.getFiltering()) {
                        if (SegOrthoCanvas.this.getScaleX() < 4.0 && SegOrthoCanvas.this.getScaleY() < 4.0) {
                            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        } else {
                            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                        }
                    }
                    AffineTransform trans = new AffineTransform();
                    if (this.currentDimension == DimensionId.X) {
                        trans.scale(scaleX, 1.0);
                    } else if (this.currentDimension == DimensionId.Y) {
                        trans.scale(1.0, scaleY);
                    }
                    g2.drawImage(img, trans, null);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    ArrayList layers = SegOrthoCanvas.this.getVisibleLayers();
                    int i = layers.size() - 2;
                    while (i >= 0) {
                        Layer layer = (Layer)layers.get(i);
                        if (layer.isVisible()) {
                            float alpha = layer.getOpacity();
                            if (alpha != 1.0f) {
                                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                            } else {
                                g2.setComposite(AlphaComposite.SrcOver);
                            }
                            if (this.currentDimension == DimensionId.Z) {
                                layer.getOverlay().paint(g2, seq, (IcyCanvas)SegOrthoCanvas.this);
                            } else {
                                ROI roi = layer.getAttachedROI();
                                if (roi != null && roi instanceof ROI2D) {
                                    Color color = ((ROI.ROIPainter)layer.getOverlay()).getDisplayColor();
                                    double stroke = ((ROI.ROIPainter)layer.getOverlay()).getStroke();
                                    Rectangle rect = ((ROI2D)roi).getBounds();
                                    g2.setColor(color);
                                    g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke((IcyCanvas)SegOrthoCanvas.this, (double)(stroke + 2.0))));
                                    if (this.currentDimension == DimensionId.X) {
                                        rect.x = 0;
                                        rect.width = (int)((double)this.getWidth() * LinkedViewersUtil.getScale()[2]);
                                        rect.width = (int)((double)rect.width / SegOrthoCanvas.this.zoom);
                                    } else {
                                        rect.y = 0;
                                        rect.height = (int)((double)this.getHeight() * LinkedViewersUtil.getScale()[2]);
                                        rect.height = (int)((double)rect.height / SegOrthoCanvas.this.zoom);
                                    }
                                    g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke((IcyCanvas)SegOrthoCanvas.this, (double)(stroke + (roi.isSelected() ? 2.0 : 1.0)))));
                                    g2.setColor(Color.black);
                                    g2.draw(rect);
                                    g2.setColor(color);
                                    g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke((IcyCanvas)SegOrthoCanvas.this, (double)(stroke + (roi.isSelected() ? 1.0 : 0.0)))));
                                    g2.draw(rect);
                                }
                            }
                        }
                        --i;
                    }
                    if (SegOrthoCanvas.this.crossHairVisible) {
                        g2.setStroke(new BasicStroke((float)(SegOrthoCanvas.this.zoom > 1.0 ? 1.0 / SegOrthoCanvas.this.zoom : SegOrthoCanvas.this.zoom)));
                        g2.setColor(Color.white);
                        g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
                        switch (this.currentDimension) {
                            case Z: {
                                if (SegOrthoCanvas.this.zoom > 1.0) {
                                    g2.draw(new Rectangle2D.Double(SegOrthoCanvas.this.posX, 0.0, 1.0, seq.getHeight()));
                                    g2.draw(new Rectangle2D.Double(0.0, SegOrthoCanvas.this.posY, seq.getWidth(), 1.0));
                                    break;
                                }
                                g2.drawLine(SegOrthoCanvas.this.posX, 0, SegOrthoCanvas.this.posX, seq.getHeight());
                                g2.drawLine(0, SegOrthoCanvas.this.posY, seq.getWidth(), SegOrthoCanvas.this.posY);
                                break;
                            }
                            case X: {
                                int x;
                                if (SegOrthoCanvas.this.zoom > 1.0) {
                                    x = (int)Math.round((double)SegOrthoCanvas.this.posZ * scaleX);
                                    g2.draw(new Rectangle2D.Double(0.0, SegOrthoCanvas.this.posY, (int)((double)seq.getSizeZ() * scaleX), 1.0));
                                    g2.draw(new Rectangle2D.Double(x, 0.0, scaleX, seq.getHeight()));
                                    break;
                                }
                                g2.drawLine(0, SegOrthoCanvas.this.posY, (int)((double)seq.getSizeZ() * scaleX), SegOrthoCanvas.this.posY);
                                x = (int)Math.round((double)SegOrthoCanvas.this.posZ * scaleX + scaleX * 0.5);
                                g2.setStroke(new BasicStroke((float)(scaleX * SegOrthoCanvas.this.zoom)));
                                g2.drawLine(x, 0, x, seq.getHeight());
                                break;
                            }
                            case Y: {
                                int y;
                                if (SegOrthoCanvas.this.zoom > 1.0) {
                                    y = (int)Math.round((double)SegOrthoCanvas.this.posZ * scaleY);
                                    g2.draw(new Rectangle2D.Double(0.0, y, seq.getWidth(), scaleY));
                                    g2.draw(new Rectangle2D.Double(SegOrthoCanvas.this.posX, 0.0, 1.0, (double)seq.getHeight() * LinkedViewersUtil.getScale()[2]));
                                    break;
                                }
                                g2.drawLine(SegOrthoCanvas.this.posX, 0, SegOrthoCanvas.this.posX, (int)((double)seq.getSizeZ() * scaleX));
                                y = (int)Math.round((double)SegOrthoCanvas.this.posZ * scaleY + scaleY * 0.5);
                                g2.setStroke(new BasicStroke((float)(scaleY * SegOrthoCanvas.this.zoom)));
                                g2.drawLine(0, y, seq.getWidth(), y);
                                break;
                            }
                        }
                    }
                    PaintersUtil.paintPoints(g2, this.currentDimension, SegOrthoCanvas.this.imageCoordinates());
                    if (!SegOrthoViewer.this.isNotDeleting) {
                        PaintersUtil.paintEraser(g2, this.currentDimension, this.dragStart, this.dragEnd, this.crossPosition);
                    }
                    g2.setStroke(new BasicStroke(1.0f));
                    PaintersUtil.paintIntersection(g2, this.currentDimension, SegOrthoCanvas.this.imageCoordinates());
                    g2.dispose();
                } else {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setFont(this.font);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (SegOrthoCanvas.this.getCurrentImage() != null) {
                        this.drawTextCenter(g2, "Loading...", 0.8f);
                    } else {
                        this.drawTextCenter(g2, " No image ", 0.8f);
                    }
                }
                if (!this.isCacheValid()) {
                    this.refresh();
                }
            }

            public void drawTextBottomRight(Graphics2D g, String text, float alpha) {
                Rectangle2D rect = GraphicsUtil.getStringBounds((Graphics)g, (String)text);
                int w = (int)rect.getWidth();
                int h = (int)rect.getHeight();
                int x = this.getWidth() - (w + 8 + 2);
                int y = this.getHeight() - (h + 8 + 2);
                g.setColor(Color.gray);
                g.setComposite(AlphaComposite.getInstance(3, alpha));
                g.fillRoundRect(x, y, w + 8, h + 8, 8, 8);
                g.setColor(Color.white);
                g.drawString(text, x + 4, y + 2 + h);
            }

            public void drawTextTopRight(Graphics2D g, String text, float alpha) {
                Rectangle2D rect = GraphicsUtil.getStringBounds((Graphics)g, (String)text);
                int w = (int)rect.getWidth();
                int h = (int)rect.getHeight();
                int x = this.getWidth() - (w + 8 + 2);
                int y = 2;
                g.setColor(Color.gray);
                g.setComposite(AlphaComposite.getInstance(3, alpha));
                g.fillRoundRect(x, 2, w + 8, h + 8, 8, 8);
                g.setColor(Color.white);
                g.drawString(text, x + 4, 4 + h);
            }

            public void drawTextCenter(Graphics2D g, String text, float alpha) {
                Rectangle2D rect = GraphicsUtil.getStringBounds((Graphics)g, (String)text);
                int w = (int)rect.getWidth();
                int h = (int)rect.getHeight();
                int x = (this.getWidth() - (w + 8 + 2)) / 2;
                int y = (this.getHeight() - (h + 8 + 2)) / 2;
                g.setColor(Color.gray);
                g.setComposite(AlphaComposite.getInstance(3, alpha));
                g.fillRoundRect(x, y, w + 8, h + 8, 8, 8);
                g.setColor(Color.white);
                g.drawString(text, x + 4, y + 2 + h);
            }

            @Override
            public void repaint() {
                super.repaint();
            }

            public void refresh() {
                this.imageCache.refresh();
            }

            public void refreshLater(int milli) {
                this.refreshTimer.setInitialDelay(milli);
                this.refreshTimer.start();
            }

            public void imageChanged() {
                this.imageCache.invalidCache();
            }

            public void layersChanged() {
            }

            public boolean isCacheValid() {
                return this.imageCache.isValid();
            }

            public double[] getClickCoordinates(DimensionId dim, int x, int y) {
                double xClick = 0.0;
                double yClick = 0.0;
                double zClick = 0.0;
                switch (dim) {
                    case X: {
                        xClick = SegOrthoCanvas.this.imageCoordinates()[0];
                        yClick = (double)(y * SegOrthoCanvas.this.getSequence().getSizeY()) / SegOrthoCanvas.this.getZYView().getBounds().getHeight();
                        zClick = (double)(x * SegOrthoCanvas.this.getSequence().getSizeZ()) / SegOrthoCanvas.this.getZYView().getBounds().getWidth();
                        break;
                    }
                    case Z: {
                        xClick = (double)(x * SegOrthoCanvas.this.getSequence().getSizeX()) / SegOrthoCanvas.this.getXYView().getBounds().getWidth();
                        yClick = (double)(y * SegOrthoCanvas.this.getSequence().getSizeY()) / SegOrthoCanvas.this.getXYView().getBounds().getHeight();
                        zClick = SegOrthoCanvas.this.imageCoordinates()[2];
                        break;
                    }
                    case Y: {
                        xClick = (double)(x * SegOrthoCanvas.this.getSequence().getSizeX()) / SegOrthoCanvas.this.getXZView().getBounds().getWidth();
                        yClick = SegOrthoCanvas.this.imageCoordinates()[1];
                        zClick = (double)(y * SegOrthoCanvas.this.getSequence().getSizeZ()) / SegOrthoCanvas.this.getXZView().getBounds().getHeight();
                        break;
                    }
                }
                return new double[]{xClick, yClick, zClick};
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                for (Layer layer : SegOrthoCanvas.this.getVisibleLayers()) {
                    layer.getOverlay().mouseClick(e, this.mousePosition, (IcyCanvas)SegOrthoCanvas.this);
                }
                if (SegOrthoCanvas.this.isLocked) {
                    return;
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                for (Layer layer : SegOrthoCanvas.this.getVisibleLayers()) {
                    layer.getOverlay().mousePressed(e, this.mousePosition, (IcyCanvas)SegOrthoCanvas.this);
                }
                if (SegOrthoCanvas.this.isLocked) {
                    if (!SegOrthoViewer.this.isNotDeleting) {
                        this.dragEnd = this.dragStart = PaintersUtil.translatePoint((Point3D)new Point3D.Double(this.getClickCoordinates(this.currentDimension, e.getX(), e.getY())), this.currentDimension);
                        this.repaint();
                        e.consume();
                        return;
                    }
                    if (fitellipsoid.getChosenMethod() == Methods.POINTS) {
                        if (EventUtil.isRightMouseButton((MouseEvent)e)) {
                            Points.removeLastOne();
                            return;
                        }
                        if (fitellipsoid.getChosenMethod() == Methods.POINTS) {
                            Point3D.Double pointToDraw = new Point3D.Double(this.getClickCoordinates(this.currentDimension, e.getX(), e.getY()));
                            Points.addPoint((Point3D)pointToDraw, this.currentDimension);
                        }
                    }
                    return;
                }
                SegOrthoCanvas.this.mousePositionChanged(this.currentDimension, e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                for (Layer layer : SegOrthoCanvas.this.getVisibleLayers()) {
                    layer.getOverlay().mouseReleased(e, this.mousePosition, (IcyCanvas)SegOrthoCanvas.this);
                }
                if (SegOrthoCanvas.this.isLocked) {
                    if (!SegOrthoViewer.this.isNotDeleting) {
                        for (Points.PointInSpace pt : Points.getAllPoints()) {
                            if (pt.getDim() != this.currentDimension || !PaintersUtil.isInsideEraser(pt.getPoint(), this.currentDimension)) continue;
                            Points.remove(pt);
                        }
                        PaintersUtil.eraseRectangle();
                        this.repaint();
                        this.dragStart = null;
                        this.dragEnd = null;
                        SegOrthoViewer.this.isNotDeleting = true;
                        e.consume();
                        return;
                    }
                    if (fitellipsoid.getChosenMethod() == Methods.ELLIPSES) {
                        return;
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Point2D.Double p = SegOrthoCanvas.this.canvasToImage(e.getPoint());
                Point5D.Double p5 = new Point5D.Double(p.x / SegOrthoCanvas.this.zoom, p.y / SegOrthoCanvas.this.zoom, this.mousePosition.z, this.mousePosition.t, this.mousePosition.c);
                for (Layer layer : SegOrthoCanvas.this.getVisibleLayers()) {
                    layer.getOverlay().mouseDrag(e, p5, (IcyCanvas)SegOrthoCanvas.this);
                }
                if (SegOrthoCanvas.this.isLocked) {
                    if (!SegOrthoViewer.this.isNotDeleting) {
                        this.dragEnd = PaintersUtil.translatePoint((Point3D)new Point3D.Double(this.getClickCoordinates(this.currentDimension, e.getX(), e.getY())), this.currentDimension);
                        this.repaint();
                        return;
                    }
                    fitellipsoid.getChosenMethod();
                    return;
                }
                SegOrthoCanvas.this.mousePositionChanged(this.currentDimension, e.getX(), e.getY());
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int newValue = SegOrthoCanvas.this.zoomSlider.getValue();
                int steps = e.getWheelRotation() * 10;
                if (steps < 0) {
                    if ((newValue += -steps) == SegOrthoCanvas.this.zoomSlider.getMaximum()) {
                        newValue = SegOrthoCanvas.this.zoomSlider.getMaximum();
                    }
                } else {
                    newValue -= steps;
                }
                SegOrthoCanvas.this.zoomSlider.setValue(newValue);
                SegOrthoCanvas.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Point2D.Double p = SegOrthoCanvas.this.canvasToImage(e.getPoint());
                this.mousePosition.x = p.x / SegOrthoCanvas.this.zoom;
                this.mousePosition.y = p.y / SegOrthoCanvas.this.zoom;
                for (Layer layer : SegOrthoCanvas.this.getVisibleLayers()) {
                    layer.getOverlay().mouseMove(e, this.mousePosition, (IcyCanvas)SegOrthoCanvas.this);
                }
                if (SegOrthoCanvas.this.isLocked) {
                    if (!SegOrthoViewer.this.isNotDeleting) {
                        Point3D.Double point3d = new Point3D.Double(this.getClickCoordinates(this.currentDimension, e.getX(), e.getY()));
                        this.crossPosition = PaintersUtil.translatePoint((Point3D)point3d, this.currentDimension);
                        this.repaint();
                        return;
                    }
                    if (EventUtil.isShiftDown((InputEvent)e)) {
                        Point3D.Double pointToDraw = new Point3D.Double(this.getClickCoordinates(this.currentDimension, e.getX(), e.getY()));
                        Points.addPoint((Point3D)pointToDraw, this.currentDimension);
                        ThreadUtil.sleep((int)100);
                    }
                }
                this.repaint();
            }

            public class ImageCache
            implements Runnable {
                private BufferedImage imageCache;
                private final SingleProcessor processor = new SingleProcessor(true, "OrthoView renderer");
                private boolean needRebuild;

                public ImageCache() {
                    this.processor.setKeepAliveTime(5L, TimeUnit.MINUTES);
                    this.imageCache = null;
                    this.needRebuild = true;
                    this.processor.submit((Runnable)this);
                }

                public void invalidCache() {
                    this.needRebuild = true;
                }

                public boolean isValid() {
                    return !this.needRebuild;
                }

                public boolean isProcessing() {
                    return this.processor.isProcessing();
                }

                public void refresh() {
                    if (this.needRebuild) {
                        this.processor.submit((Runnable)this);
                    }
                    SegOrthoView.this.repaint();
                }

                public BufferedImage getImage() {
                    return this.imageCache;
                }

                @Override
                public void run() {
                    this.needRebuild = false;
                    IcyBufferedImage img = SegOrthoCanvas.this.getCurrentImage(SegOrthoView.this.currentDimension);
                    this.imageCache = img != null ? IcyBufferedImageUtil.getARGBImage((IcyBufferedImage)img, (LUT)SegOrthoCanvas.this.getLut(), (BufferedImage)this.imageCache) : null;
                    SegOrthoView.this.repaint();
                }
            }
        }
    }
}

