package plugins.tprovoost.sequenceblocks.infos;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import loci.formats.ome.OMEXMLMetadataImpl;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

/**
 * @author Stephane
 */
public class GetMetaData extends Plugin implements SequenceBlock, PluginBundled
{
    VarSequence varSequence = new VarSequence("Sequence", null);
    Var<OMEXMLMetadataImpl> metaData = new Var<OMEXMLMetadataImpl>("Metadata", OMEXMLMetadataImpl.class);
    VarString name = new VarString("Name", "");
    VarDouble pxSizeX = new VarDouble("Pixel Size X (m)", 1d);
    VarDouble pxSizeY = new VarDouble("Pixel Size Y (m)", 1d);
    VarDouble pxSizeZ = new VarDouble("Pixel Size Z (m)", 1d);
    VarDouble timeIntT = new VarDouble("Time interval T (s)", 100d);

    @Override
    public void run()
    {
        Sequence s = varSequence.getValue();
        if (s != null)
        {
            metaData.setValue(s.getMetadata());
            name.setValue(s.getName());
            pxSizeX.setValue(Double.valueOf(s.getPixelSizeX()));
            pxSizeY.setValue(Double.valueOf(s.getPixelSizeY()));
            pxSizeZ.setValue(Double.valueOf(s.getPixelSizeZ()));
            timeIntT.setValue(Double.valueOf(s.getTimeInterval()));
        }
        else
        {
            throw new VarException(varSequence, "Sequence is null");
        }
    }

    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("sequence", varSequence);
    }

    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("metadata", metaData);
        outputMap.add("name", name);
        outputMap.add("Pixel Size X (mm)", pxSizeX);
        outputMap.add("Pixel Size Y (mm)", pxSizeY);
        outputMap.add("Pixel Size Z (mm)", pxSizeZ);
        outputMap.add("Time interval T (ms)", timeIntT);
    }

    @Override
    public String getMainPluginClassName()
    {
        return SequenceBlocks.class.getName();
    }
}
