/*
 * Decompiled with CFR 0.152.
 */
package kovac.res.util;

import icy.canvas.IcyCanvas;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrameListener;
import icy.gui.viewer.Viewer;
import icy.painter.Overlay;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import java.util.ArrayList;
import java.util.List;
import kovac.res.gui.LinkListener;
import kovac.res.gui.SegOrthoViewer;
import kovac.shapes.AxisOverlay;
import kovac.shapes.EllipsoidOverlay;
import kovac.shapes.GroupPointsOverlay;
import plugins.kernel.canvas.VtkCanvas;

public class LinkedViewersUtil {
    private static Viewer vOrth;
    private static Viewer vVTK;
    private static Sequence baseSeq;
    private static boolean vtkSetUp;

    static {
        vtkSetUp = false;
    }

    public static void setOrth(Viewer v) {
        vOrth = v;
    }

    public static void setVTK(Viewer v) {
        vVTK = v;
    }

    public static void linkViewers() {
        if (!LinkedViewersUtil.areSet() || !vtkSetUp) {
            return;
        }
        vOrth.addFrameListener((IcyFrameListener)new LinkListener(vVTK));
        vVTK.addFrameListener((IcyFrameListener)new LinkListener(vOrth));
    }

    public static void setBaseSeq(Sequence s) {
        baseSeq = s;
    }

    public static Viewer getOrth() {
        return vOrth;
    }

    public static Viewer getVTK() {
        return vVTK;
    }

    public static Sequence getBaseSeq() {
        return baseSeq;
    }

    public static SegOrthoViewer.SegOrthoCanvas getOrthCanvas() {
        if (!(vOrth.getCanvas() instanceof SegOrthoViewer.SegOrthoCanvas)) {
            MessageDialog.showDialog((String)"This plugin does not work for regular 2D Canvas, the sequence will now return to OrthoViewer");
            vOrth.setCanvas(SegOrthoViewer.SegOrthoCanvas.class.getName());
        }
        return (SegOrthoViewer.SegOrthoCanvas)vOrth.getCanvas();
    }

    public static IcyCanvas getVTKCanvas() {
        return vVTK.getCanvas();
    }

    public static SegOrthoViewer.SegOrthoCanvas.SegOrthoView getView(DimensionId dim) {
        switch (dim) {
            case X: {
                return LinkedViewersUtil.getOrthCanvas().getZYView();
            }
            case Y: {
                return LinkedViewersUtil.getOrthCanvas().getXZView();
            }
            case Z: {
                return LinkedViewersUtil.getOrthCanvas().getXYView();
            }
        }
        return null;
    }

    public static Sequence getOrthSequence() {
        return vOrth.getSequence();
    }

    public static Sequence getVTKSequence() {
        return vVTK.getSequence();
    }

    public static List<Overlay> getVTKOverlays() {
        if (!vtkSetUp || vVTK == null) {
            return new ArrayList<Overlay>();
        }
        if (LinkedViewersUtil.getVTKSequence() != null) {
            return LinkedViewersUtil.getVTKSequence().getOverlays();
        }
        return new ArrayList<Overlay>();
    }

    public static void setPositionOrth(double ... coords) {
        vOrth.getCanvas().setPositionX((int)coords[0]);
        vOrth.getCanvas().setPositionY((int)coords[1]);
        vOrth.getCanvas().setPositionZ((int)coords[2]);
    }

    public static void setRotationOrth(double ... rotation) {
        vOrth.getCanvas().setRotationX(rotation[0]);
        vOrth.getCanvas().setRotationY(rotation[1]);
    }

    public static void goToVTK() {
        vtkSetUp = true;
        try {
            vVTK.setCanvas(VtkCanvas.class.getName());
        }
        catch (Throwable e) {
            System.out.println("Couldn't initialize VTK viewer");
            vtkSetUp = false;
        }
    }

    public static void goToSeg() {
        vOrth.setCanvas(SegOrthoViewer.class.getName());
    }

    public static void removeOverlayFromVTK(Overlay o) {
        if (!vtkSetUp) {
            return;
        }
        o.remove();
    }

    public static void displayAllOverlaysFromVTK() {
        if (!vtkSetUp) {
            return;
        }
        System.out.println("Below are all overlays:");
        for (Overlay o : LinkedViewersUtil.getVTKOverlays()) {
            System.out.println("Overlay " + o.getName() + "  of " + o.getClass());
        }
        System.out.println("");
    }

    public static void removeAllLinesOverlayFromVTK() {
        if (!vtkSetUp) {
            return;
        }
        for (Overlay o : LinkedViewersUtil.getVTKOverlays()) {
            if (!(o instanceof AxisOverlay)) continue;
            LinkedViewersUtil.removeOverlayFromVTK(o);
        }
    }

    public static void removeEllipsoidOverlays() {
        if (!vtkSetUp) {
            return;
        }
        for (Overlay o : LinkedViewersUtil.getVTKOverlays()) {
            if (o instanceof EllipsoidOverlay) {
                o.setCanBeRemoved(true);
                LinkedViewersUtil.removeOverlayFromVTK(o);
            }
            if (!(o instanceof GroupPointsOverlay)) continue;
            LinkedViewersUtil.removeOverlayFromVTK(o);
        }
    }

    public static void removeOverlays() {
        if (!vtkSetUp) {
            return;
        }
        for (Overlay o : LinkedViewersUtil.getVTKOverlays()) {
            LinkedViewersUtil.removeOverlayFromVTK(o);
        }
    }

    public static void addOverlayToVTK(Overlay o) {
        if (!vtkSetUp) {
            return;
        }
        LinkedViewersUtil.getVTKSequence().addOverlay(o);
    }

    public static double[] getScale() {
        return new double[]{baseSeq.getPixelSizeX(), baseSeq.getPixelSizeY(), baseSeq.getPixelSizeZ()};
    }

    public static double[] getSizes() {
        return new double[]{baseSeq.getSizeX(), baseSeq.getSizeY(), baseSeq.getSizeZ()};
    }

    public static double[] getCurrentOrthCoordinates() {
        return LinkedViewersUtil.getOrthCanvas().imageCoordinates();
    }

    public static double[] getCurrentOrthRotation() {
        return LinkedViewersUtil.getOrthCanvas().imageRotation2D();
    }

    public static boolean areSet() {
        return vOrth != null && vVTK != null;
    }

    public static void minimizeViewers() {
        vOrth.setMinimized(true);
        vVTK.setMinimized(true);
    }

    public static void clear() {
        if (vtkSetUp) {
            vVTK.close();
        }
        vOrth.close();
    }
}

