package plugins.fab.spotDetector.roi;

import java.util.ArrayList;
import java.util.HashMap;

import jxl.format.Colour;
import jxl.write.WritableSheet;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import icy.file.xls.XlsManager;
import icy.roi.ROI2D;
import icy.util.XLSUtil;
import icy.util.XMLUtil;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.GlobalDetectionToken;

public class ROI_XLS_Common_Saver {

	public static void saveXLS(WritableSheet page, GlobalDetectionToken gdt , String ROIGeneratorName )
	{

		int row = page.getRows();

		//int row = page.getExcelPage().getRows();
		XLSUtil.setCellString( page , 0, row, "Region of interest generated by : " );
		//page.setLabel( 0 , row , "Region of interest generated by : " );
		XLSUtil.setCellString( page , 1, row, ROIGeneratorName );
		//page.setLabel( 1 , row , ROIGeneratorName );
		
		row++;
		
		HashMap<ROI2D, ArrayList<DetectionSpot>> ROI2Detection = gdt.roi2detection;
		
		XLSUtil.setCellString( page , 0, row, "ROI number" );
		//page.setLabel( 0 , row , "ROI number" );
		XLSUtil.setCellString( page , 1, row, "ROI name" );
		//page.setLabel( 1 , row , "ROI name" );
		//xlsManager.setLabel( 1 , row , "ROI color" );
		XLSUtil.setCellString( page , 2, row, "ROI surface" );
		//page.setLabel( 2 , row , "ROI surface" );
		XLSUtil.setCellString( page , 3, row, "ROI nb detection" );
		//page.setLabel( 3 , row , "ROI nb detection" );
		XLSUtil.setCellString( page , 4, row, "ROI tag(s)" );
		//page.setLabel( 4 , row , "ROI tag(s)" );

		row++ ;
		
		int nb = 0;
		for ( ROI2D roi : ROI2Detection.keySet() )
		{
			//System.out.println("ROI id : " + roi.getId() );
			XLSUtil.setCellNumber( page , 0, row, nb );
			//page.setNumber( 0 , row , nb );			
			XLSUtil.setCellString( page , 1, row, roi.getName() );
			//page.setLabel( 1 , row , roi.getName() );
			//xlsManager.setLabel( 1 , row, "", roi.getColor() );
			XLSUtil.setCellNumber( page , 2, row, computeROISurface(roi) );
//			page.setNumber( 2 , row , computeROISurface(roi) );
			XLSUtil.setCellNumber( page , 3, row, ROI2Detection.get( roi ).size() );
//			page.setNumber( 3 , row , ROI2Detection.get( roi ).size() );

			int xOffset = 4;
			//System.out.println("ok");
			// ---------------------------------------------------------- add ROI tag
			Node tagNode = gdt.inputSequence.getNode("tags");
			if ( tagNode!= null )
			{

				ArrayList<Element> roiElementList = XMLUtil.getSubElements( tagNode );

				for ( Element roiElement : roiElementList )
				{
					
					int roiId = XMLUtil.getAttributeIntValue( roiElement, "ROI_ID" , -1 );		
					//System.out.println("proposed : " + roiId );
					if ( roiId == roi.getId() )
					{
					//	System.out.println("match !");
						ArrayList<Element> roiTagList = XMLUtil.getSubElements( roiElement );	

						for ( Element tag : roiTagList )
						{
							String name = XMLUtil.getAttributeValue( tag , "name", "no name");
						//	System.out.println( name );
							XLSUtil.setCellString( page , xOffset, row, name );
							//page.setLabel( xOffset , row , name );
							xOffset++;

						}

					}

				}
			}
			// ----------------------------------------------------------
			
			row++;
			nb++;
		}
		
		// Save detection per ROI
		
		row++;
		row++;
		XLSUtil.setCellString( page , 0, row, "Detection per ROI" );
		//page.setLabel( 0 , row , "Detection per ROI" );
		
		int nbROI = 0;
		for ( ROI2D roi : ROI2Detection.keySet() )
		{
			row++;
			row++;
			XLSUtil.setCellString( page , 0, row, "ROI Number:" );
			//page.setLabel( 0 , row , "ROI Number: " );
			XLSUtil.setCellNumber( page , 0, row, nbROI );
			//page.setNumber( 0 , row , nbROI );
			row++;
			row++;
			XLSUtil.setCellString( page , 0, row, "Detection #" );
			//page.setLabel( 0 , row , "Detection #" );
			XLSUtil.setCellString( page , 1, row, "Surface" );
			//page.setLabel( 1 , row , "Surface" );
			XLSUtil.setCellString( page , 2, row, "x" );
			//page.setLabel( 2 , row , "x" );
			XLSUtil.setCellString( page , 3, row, "y" );
			//page.setLabel( 3 , row , "y" );
			XLSUtil.setCellString( page , 4, row, "z" );
			//page.setLabel( 4 , row , "z" );
			XLSUtil.setCellString( page , 5, row, "t" );
			//page.setLabel( 5 , row , "t" );
			XLSUtil.setCellString( page , 6, row, "min intensity" );
			//page.setLabel( 6 , row , "min intensity" );
			XLSUtil.setCellString( page , 7, row, "max intensity" );
			//page.setLabel( 7 , row , "max intensity" );
			XLSUtil.setCellString( page , 8, row, "average intensity" );
			//page.setLabel( 8 , row , "average intensity" );
			row++;
			int detectionNumber = 0;
			for ( DetectionSpot detectionSpot : ROI2Detection.get( roi ) )
			{
				XLSUtil.setCellNumber( page , 0, row, detectionNumber );
				//page.setNumber( 0 , row , detectionNumber );
				XLSUtil.setCellNumber( page , 1, row, detectionSpot.points.size() );
//				page.setNumber( 1 , row , detectionSpot.points.size() );
				XLSUtil.setCellNumber( page , 2, row, detectionSpot.getMassCenter().x );
//				page.setNumber( 2 , row , detectionSpot.getMassCenter().x );
				XLSUtil.setCellNumber( page , 3, row, detectionSpot.getMassCenter().y );
//				page.setNumber( 3 , row , detectionSpot.getMassCenter().y );
				XLSUtil.setCellNumber( page , 4, row, detectionSpot.getMassCenter().z );
//				page.setNumber( 4 , row , detectionSpot.getMassCenter().z );
				XLSUtil.setCellNumber( page , 5, row, detectionSpot.getT() );
//				page.setNumber( 5 , row , detectionSpot.getT() );
				XLSUtil.setCellNumber( page , 6, row, detectionSpot.minIntensity );
//				page.setNumber( 6 , row , detectionSpot.minIntensity );
				XLSUtil.setCellNumber( page , 7, row, detectionSpot.maxIntensity );
//				page.setNumber( 7 , row , detectionSpot.maxIntensity );
				XLSUtil.setCellNumber( page , 8, row, detectionSpot.meanIntensity );
//				page.setNumber( 8 , row , detectionSpot.meanIntensity );				
				row++;
				detectionNumber++;
			}

			row++;
			nbROI++;
		}
		
		
	}
	
	static int computeROISurface( ROI2D roi )
	{
		boolean[] bool = roi.getAsBooleanMask( roi.getBounds() );
		
		int surface = 0;
		for ( int x = 0 ; x < bool.length ; x++ )
		{
			if ( bool[x] ) surface++;
		}
		return surface;		
	}
	
}
