package plugins.tprovoost.chronometer;

import icy.gui.component.IcyPanel;
import icy.gui.component.button.IcyButton;
import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginImageAnalysis;
import icy.resource.icon.IcyIcon;
import icy.system.thread.ThreadUtil;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class Chronometer extends Plugin implements PluginImageAnalysis {

	private IcyFrame frame;
	private InfinitePanel infinite_panel;
	

	@Override
	public void compute() {
		frame = new IcyFrame("Chronometer", true, true, false, false);
		infinite_panel = new InfinitePanel();
		
		// Main panel of the frame
		JPanel main_panel = new JPanel();
		main_panel.setLayout(new BoxLayout(main_panel, BoxLayout.Y_AXIS));
		main_panel.add(new Chronopanel());
		main_panel.add(infinite_panel);
		
		// Frame layouts
		frame.add(main_panel);
		frame.setVisible(true);
		frame.addToMainDesktopPane();
		frame.pack();
	}

	private class Chronopanel extends JPanel {

		/** Generated serial UID */
		private static final long serialVersionUID = 2464782090127451499L;
		private TimerChrono chrono;
		IcyButton btn_start;

		public Chronopanel() {
			JPanel panel_borders = GuiUtil.generatePanel("");
			setBorder(panel_borders.getBorder());
			setLayout(new GridLayout(2, 1));
			// chrono
			chrono = new TimerChrono();
			chrono.setPreferredSize(new Dimension(200, 50));
			add(chrono);

			// buttons
			JPanel panel_buttons = new JPanel();
			panel_buttons.setLayout(new BoxLayout(panel_buttons, BoxLayout.X_AXIS));
			btn_start = new IcyButton(new IcyIcon("playback_play.png"));
			btn_start.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent actionevent) {
					chrono.start();
				}
			});
			IcyButton btn_reset = new IcyButton(new IcyIcon("rot_unclock.png"));
			btn_reset.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent actionevent) {
					chrono.stop();
				}
			});
			IcyButton btn_lap = new IcyButton(new IcyIcon("pencil.png"));
			btn_lap.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent e) {
					chrono.lap();
				}
			});
			panel_buttons.add(Box.createHorizontalGlue());
			panel_buttons.add(btn_start);
			panel_buttons.add(btn_reset);
			panel_buttons.add(btn_lap);
			panel_buttons.add(Box.createHorizontalGlue());

			add(panel_buttons);
		}
		
		private class TimerChrono extends IcyPanel {

			/** */
			private static final long serialVersionUID = 6443349738677449587L;
			ChronoThread thread = new ChronoThread();
			private boolean started = false;

			String _hours = "00";
			String _minutes = "00";
			String _seconds = "00";
			String _millis = "000";
			private boolean pause = false;
			
			long toAddTime=0;
			long last_time;
			

			void setTime() {
				long new_time = System.nanoTime();
				long difference = (new_time - last_time)/1000000 + toAddTime;
				if (difference >= 3600000) {
					int resH = (int) (difference / 3600000L);
					_hours = "";
					if (resH < 10)
						_hours += "0";
					_hours = "" + resH;
					difference = difference % 3600000;
				}
				if (difference >= 60000) {
					int resM = (int) (difference / 60000);
					_minutes = "";
					if (resM < 10)
						_minutes += "0";
					_minutes += resM;
					difference = difference % 60000;
				}
				if (difference >= 1000) {
					int resS = (int) (difference / 1000);
					_seconds = "";
					if (resS < 10)
						_seconds += "0";
					_seconds += resS;
					difference = difference % 1000;
				}
				_millis = "";
				if (difference < 100)
					_millis += "0";
				if (difference < 10)
					_millis += "0";
				_millis += difference;
				ThreadUtil.invokeNow(new Runnable() {
					@Override
					public void run() {
						repaint();
					}
				});
			}

			@Override
			protected void paintComponent(Graphics g) {
				super.paintComponent(g);
				final int w = getWidth();
				final int h = getHeight();
				Graphics2D g2 = (Graphics2D) g.create();

				g2.setFont(new Font("Arial", Font.BOLD, 22));
				g2.setColor(Color.white);
				String toRender = _hours + ":" + _minutes + ":" + _seconds + ":" + _millis;
				GuiUtil.drawHCenteredText(g2, toRender, w, (h / 2) + 5);

				g2.dispose();
			}

			void reset() {
				_hours = "00";
				_minutes = "00";
				_seconds = "00";
				_millis = "000";
				toAddTime = 0;
				frame.pack();
				repaint();
			}

			void start() {
				if (started) {
					pauseResume();
				} else {
					reset();
					started = true;
					last_time = System.nanoTime();
					btn_start.setIcon(new IcyIcon("playback_pause.png"));
					ThreadUtil.bgRun(thread);
				}
			}

			public void pauseResume() {
				pause = !pause;
				if (pause) {
					btn_start.setIcon(new IcyIcon("playback_play.png"));
					long new_time = System.nanoTime();
					long difference = (new_time - last_time) / 1000000;
					toAddTime+=difference;
				}
				else {
					btn_start.setIcon(new IcyIcon("playback_pause.png"));
					last_time = System.nanoTime();
				}
			}

			public void lap() {
				if (!started)
					return;
				
				final JPanel panel_lap = new JPanel();
				panel_lap.setLayout(new BoxLayout(panel_lap, BoxLayout.X_AXIS));
				
				LapPanel lap = new LapPanel(_hours,_minutes,_seconds,_millis);
				final IcyButton btn_remove = new IcyButton(new IcyIcon("minus.png"));
				btn_remove.addActionListener(new ActionListener() {
					
					@Override
					public void actionPerformed(ActionEvent actionevent) {
						infinite_panel.removePanel(panel_lap);
						frame.pack();
					}
				});
				panel_lap.add(lap);
				panel_lap.add(btn_remove);
				
				infinite_panel.addPanel(panel_lap);
				frame.pack();
			}
			
			void stop() {
				if (!started)
					return;
				thread.setStop(true);
				started = false;
				btn_start.setIcon(new IcyIcon("playback_play.png"));
				pause = false;
			}

			private class ChronoThread implements Runnable {
				private boolean stop;

				public ChronoThread() {
					stop = false;
				}

				@Override
				public void run() {
					stop = false;
					while (!stop) {
						while (pause) {
							try {
								Thread.sleep(200);
							} catch (InterruptedException e) {
								e.printStackTrace();
							}
						}
						setTime();
						Thread.yield();
					}
					setStop(false);
					reset();
				}

				public synchronized void setStop(boolean stop) {
					this.stop = stop;
				}
			}
		}
		
		private class LapPanel extends IcyPanel {

			/** Generated serial UID  */
			private static final long serialVersionUID = 1410964214874522235L;
			String _hours = "00";
			String _minutes = "00";
			String _seconds = "00";
			String _millis = "000";
			
			public LapPanel(String hours, String minutes, String seconds, String millis) {
				setTime(hours, minutes, seconds, millis);
				setPreferredSize(new Dimension(180,40));
			}

			public void setTime(String hours, String minutes, String seconds, String millis) {
				_hours = hours; 
				_minutes = minutes;
				_seconds = seconds;
				_millis = millis;
				repaint();
			}
			
			@Override
			protected void paintComponent(Graphics g) {
				super.paintComponent(g);
				final int w = getWidth();
				final int h = getHeight();
				Graphics2D g2 = (Graphics2D) g.create();

				g2.setFont(new Font("Arial", Font.BOLD, 22));
				g2.setColor(Color.white);
				String toRender = _hours + ":" + _minutes + ":" + _seconds + ":" + _millis;
				GuiUtil.drawHCenteredText(g2, toRender, w, (h / 2) + 5);

				g2.dispose();
			}
		}
	}
}
