/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.lang.reflect.Constructor;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLFactory;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.usermodel.XSSFRelation;

public final class XSSFFactory
extends POIXMLFactory {
    private static final POILogger logger = POILogFactory.getLogger(XSSFFactory.class);
    private static final XSSFFactory inst = new XSSFFactory();

    private XSSFFactory() {
    }

    public static XSSFFactory getInstance() {
        return inst;
    }

    public POIXMLDocumentPart createDocumentPart(POIXMLDocumentPart parent, PackageRelationship rel, PackagePart part) {
        XSSFRelation descriptor = XSSFRelation.getInstance(rel.getRelationshipType());
        if (descriptor == null || descriptor.getRelationClass() == null) {
            logger.log(1, (Object)("using default POIXMLDocumentPart for " + rel.getRelationshipType()));
            return new POIXMLDocumentPart(part, rel);
        }
        try {
            Class<? extends POIXMLDocumentPart> cls = descriptor.getRelationClass();
            Constructor<? extends POIXMLDocumentPart> constructor = cls.getDeclaredConstructor(PackagePart.class, PackageRelationship.class);
            return constructor.newInstance(part, rel);
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    public POIXMLDocumentPart newDocumentPart(POIXMLRelation descriptor) {
        try {
            Class<? extends POIXMLDocumentPart> cls = descriptor.getRelationClass();
            Constructor<? extends POIXMLDocumentPart> constructor = cls.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }
}

