package plugins.ylemontag.mathoperations;

import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarListener;
import plugins.adufour.vars.util.VarReferencingPolicy;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Parametric block with a list of inputs dependent of a Math expression
 */
public class MathOperationExpressionBlock extends MathOperationAbstractBlock
{
	private VarExpression _expression;
	
	public MathOperationExpressionBlock()
	{
		super("result");
		_expression = new VarExpression("op", null);
		_expression.setReferencingPolicy(VarReferencingPolicy.NONE);
	}
	
	@Override
	public void declareInput(final VarList inputMap)
	{
		_expression.addListener(new VarListener<Expression>()
		{
			@Override
			public void valueChanged(Var<Expression> source, Expression oldValue, Expression newValue)
			{
				String[] names = newValue==null ? null : newValue.getVariablesAsArray();
				defineRuntimeInputVariants(inputMap, names);
			}
			
			@Override
			public void referenceChanged(Var<Expression> source, Var<? extends Expression> oldReference,
				Var<? extends Expression> newReference)
			{}
		});
		inputMap.add("Operation", _expression);
	}
	
	@Override
	public String getMainPluginClassName()
	{
		return MathOperationPlugin.class.getName();
	}
	
	@Override
	public String getName()
	{
		return "Math expression";
	}
	
	@Override
	public void run()
	{
		// TODO Auto-generated method stub
		
	}
}
