/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;

public class GenericSorting {
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    protected GenericSorting() {
    }

    private static void inplace_merge(int first, int middle, int last, IntComparator comp, Swapper swapper) {
        int secondCut;
        int firstCut;
        if (first >= middle || middle >= last) {
            return;
        }
        if (last - first == 2) {
            if (comp.compare(middle, first) < 0) {
                swapper.swap(first, middle);
            }
            return;
        }
        if (middle - first > last - middle) {
            firstCut = first + (middle - first) / 2;
            secondCut = GenericSorting.lower_bound(middle, last, firstCut, comp);
        } else {
            secondCut = middle + (last - middle) / 2;
            firstCut = GenericSorting.upper_bound(first, middle, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = middle;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
        }
        middle = firstCut + (secondCut - middle);
        GenericSorting.inplace_merge(first, firstCut, middle, comp, swapper);
        GenericSorting.inplace_merge(middle, secondCut, last, comp, swapper);
    }

    private static int lower_bound(int first, int last, int x, IntComparator comp) {
        int len = last - first;
        while (len > 0) {
            int half = len / 2;
            int middle = first + half;
            if (comp.compare(middle, x) < 0) {
                first = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return first;
    }

    private static int med3(int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(a, b);
        int ac = comp.compare(a, c);
        int bc = comp.compare(b, c);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void mergeSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
        int length = toIndex - fromIndex;
        if (length < 7) {
            int i = fromIndex;
            while (i < toIndex) {
                int j = i;
                while (j > fromIndex && c.compare(j - 1, j) > 0) {
                    swapper.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = (fromIndex + toIndex) / 2;
        GenericSorting.mergeSort(fromIndex, mid, c, swapper);
        GenericSorting.mergeSort(mid, toIndex, c, swapper);
        if (c.compare(mid - 1, mid) <= 0) {
            return;
        }
        GenericSorting.inplace_merge(fromIndex, mid, toIndex, c, swapper);
    }

    public static void quickSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
        GenericSorting.quickSort1(fromIndex, toIndex - fromIndex, c, swapper);
    }

    private static void quickSort1(int off, int len, IntComparator comp, Swapper swapper) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && comp.compare(j - 1, j) > 0) {
                    swapper.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = GenericSorting.med3(l, l + s, l + 2 * s, comp);
                m = GenericSorting.med3(m - s, m, m + s, comp);
                n = GenericSorting.med3(n - 2 * s, n - s, n, comp);
            }
            m = GenericSorting.med3(l, m, n, comp);
        }
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(b, m)) <= 0) {
                if (comparison == 0) {
                    if (a == m) {
                        m = b;
                    } else if (b == m) {
                        m = a;
                    }
                    swapper.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(c, m)) >= 0) {
                if (comparison == 0) {
                    if (c == m) {
                        m = d;
                    } else if (d == m) {
                        m = c;
                    }
                    swapper.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            if (b == m) {
                m = d;
            } else if (c == m) {
                m = c;
            }
            swapper.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        GenericSorting.vecswap(swapper, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        GenericSorting.vecswap(swapper, b, n - s, s);
        s = b - a;
        if (s > 1) {
            GenericSorting.quickSort1(off, s, comp, swapper);
        }
        if ((s = d - c) > 1) {
            GenericSorting.quickSort1(n - s, s, comp, swapper);
        }
    }

    private static void reverse(int first, int last, Swapper swapper) {
        while (first < --last) {
            swapper.swap(first++, last);
        }
    }

    private static void rotate(int first, int middle, int last, Swapper swapper) {
        if (middle != first && middle != last) {
            GenericSorting.reverse(first, middle, swapper);
            GenericSorting.reverse(middle, last, swapper);
            GenericSorting.reverse(first, last, swapper);
        }
    }

    private static int upper_bound(int first, int last, int x, IntComparator comp) {
        int len = last - first;
        while (len > 0) {
            int half = len / 2;
            int middle = first + half;
            if (comp.compare(x, middle) < 0) {
                len = half;
                continue;
            }
            first = middle + 1;
            len -= half + 1;
        }
        return first;
    }

    private static void vecswap(Swapper swapper, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            swapper.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }
}

