/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.NetCDFService;
import ome.units.quantity.Length;

public class MINCReader
extends FormatReader {
    private NetCDFService netcdf;
    private byte[][][] pixelData;
    private boolean isMINC2 = false;

    public MINCReader() {
        super("MINC MRI", "mnc");
        this.domains = new String[]{"Medical Imaging"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (no < this.pixelData.length) {
            for (int row = 0; row < h; ++row) {
                int srcRow = this.getSizeY() - (row + y) - 1;
                if (srcRow >= this.pixelData[no].length || x + w > this.pixelData[no][srcRow].length) continue;
                System.arraycopy(this.pixelData[no][srcRow], x * bpp, buf, row * w * bpp, w * bpp);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.netcdf != null) {
                this.netcdf.close();
            }
            this.pixelData = null;
            this.isMINC2 = false;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.netcdf = factory.getInstance(NetCDFService.class);
            this.netcdf.setFile(id);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException(e);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Vector<String> variableList = this.netcdf.getVariableList();
            for (String variable : variableList) {
                Hashtable<String, Object> attributes = this.netcdf.getVariableAttributes(variable);
                Object[] keys = attributes.keySet().toArray(new String[0]);
                Arrays.sort(keys);
                for (Object key : keys) {
                    if (attributes.get(key) instanceof Object[]) {
                        Object[] o;
                        StringBuffer sb = new StringBuffer();
                        for (Object q : o = (Object[])attributes.get(key)) {
                            sb.append(q.toString());
                        }
                        this.addGlobalMeta(variable + " " + (String)key, sb.toString());
                        continue;
                    }
                    this.addGlobalMeta(variable + " " + (String)key, attributes.get(key));
                }
            }
        }
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        try {
            Object s;
            Object pixels = this.netcdf.getVariableValue("/image");
            if (pixels == null) {
                pixels = this.netcdf.getVariableValue("/minc-2.0/image/0/image");
                this.isMINC2 = true;
            }
            if (pixels instanceof byte[][][]) {
                m.pixelType = 1;
                this.pixelData = (byte[][][])pixels;
            } else if (pixels instanceof byte[][][][]) {
                byte[][][][] actualPixels = (byte[][][][])pixels;
                m.pixelType = 1;
                this.pixelData = new byte[actualPixels.length * actualPixels[0].length][][];
                int nextPlane = 0;
                for (int t = 0; t < actualPixels.length; ++t) {
                    for (int z = 0; z < actualPixels[t].length; ++z) {
                        this.pixelData[nextPlane++] = actualPixels[t][z];
                    }
                }
            } else if (pixels instanceof short[][][]) {
                m.pixelType = 3;
                s = (short[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.shortsToBytes(s[i][j], this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof int[][][]) {
                m.pixelType = 5;
                s = (int[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.intsToBytes(s[i][j], this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof float[][][]) {
                m.pixelType = 6;
                s = (float[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.floatsToBytes(s[i][j], this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof double[][][]) {
                m.pixelType = 7;
                s = (double[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.doublesToBytes(s[i][j], this.isLittleEndian());
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new FormatException(e);
        }
        m.littleEndian = this.isMINC2;
        Double physicalX = null;
        Double physicalY = null;
        Double physicalZ = null;
        if (this.isMINC2) {
            Hashtable<String, Object> attrs = this.netcdf.getVariableAttributes("/minc-2.0/dimensions/xspace");
            m.sizeX = Integer.parseInt(attrs.get("length").toString());
            physicalX = this.getStepSize(attrs);
            attrs = this.netcdf.getVariableAttributes("/minc-2.0/dimensions/yspace");
            m.sizeY = Integer.parseInt(attrs.get("length").toString());
            physicalY = this.getStepSize(attrs);
            attrs = this.netcdf.getVariableAttributes("/minc-2.0/dimensions/zspace");
            m.sizeZ = Integer.parseInt(attrs.get("length").toString());
            physicalZ = this.getStepSize(attrs);
        } else {
            m.sizeX = this.netcdf.getDimension("/xspace");
            m.sizeY = this.netcdf.getDimension("/yspace");
            m.sizeZ = this.netcdf.getDimension("/zspace");
            physicalX = this.getStepSize(this.netcdf.getVariableAttributes("/xspace"));
            physicalY = this.getStepSize(this.netcdf.getVariableAttributes("/yspace"));
            physicalZ = this.getStepSize(this.netcdf.getVariableAttributes("/zspace"));
        }
        try {
            m.sizeT = this.netcdf.getDimension("/time");
        }
        catch (NullPointerException e) {
            m.sizeT = 1;
        }
        m.sizeC = 1;
        m.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        m.rgb = false;
        m.indexed = false;
        m.dimensionOrder = "XYZCT";
        String history = null;
        history = this.isMINC2 ? this.netcdf.getAttributeValue("/minc-2.0/ident") : this.netcdf.getAttributeValue("/history");
        this.addGlobalMeta("Comment", history);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(history, 0);
            Length sizeX = FormatTools.getPhysicalSizeX(physicalX);
            Length sizeY = FormatTools.getPhysicalSizeY(physicalY);
            Length sizeZ = FormatTools.getPhysicalSizeZ(physicalZ);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
        }
    }

    private Double getStepSize(Hashtable<String, Object> attrs) {
        Double stepSize = Double.parseDouble(attrs.get("step").toString());
        String units = attrs.get("units").toString();
        if (units.equals("mm")) {
            stepSize = stepSize * 1000.0;
        }
        return stepSize;
    }
}

