/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.HashSet;
import loci.common.DebugTools;
import loci.plugins.out.Exporter;
import loci.plugins.util.LibraryChecker;

public class LociExporter
implements PlugInFilter {
    public String arg;
    private Exporter exporter;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.exporter = new Exporter(this, imp);
        return 159;
    }

    public void run(ImageProcessor ip) {
        DebugTools.enableLogging("INFO");
        if (!LibraryChecker.checkJava() || !LibraryChecker.checkImageJ()) {
            return;
        }
        HashSet<String> missing = new HashSet<String>();
        LibraryChecker.checkLibrary(LibraryChecker.Library.BIO_FORMATS, missing);
        LibraryChecker.checkLibrary(LibraryChecker.Library.OME_JAVA_XML, missing);
        if (!LibraryChecker.checkMissing(missing)) {
            return;
        }
        if (this.exporter != null) {
            this.exporter.run();
        }
    }
}

