/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import com.ibm.media.bean.multiplayer.GrayFilter;
import com.ibm.media.bean.multiplayer.ImageLabel;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.net.URL;

public class ImageButton
extends ImageLabel {
    protected static final int defaultBorderWidth = 4;
    protected static final Color defaultBorderColor = new Color(160, 160, 160);
    private char[] text;
    private boolean txtButton = false;
    private boolean mouseIsDown = false;
    String actionCommand;
    transient ActionListener actionListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    private int darkness = -5263441;
    private Image grayImage = null;

    public ImageButton() {
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(String text, boolean txt, int width, int height) {
        this.width = width;
        this.height = height;
        if (txt) {
            int length = text.length();
            this.text = new char[length];
            text.getChars(0, length, this.text, 0);
            this.txtButton = txt;
        }
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(String imageURLString) {
        super(imageURLString);
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(URL imageURL) {
        super(imageURL);
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(URL imageDirectory, String imageFile) {
        super(imageDirectory, imageFile);
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(Image image) {
        super(image);
        this.enableEvents(144L);
        this.setBorders();
    }

    public void waitForImage(boolean doLayout) {
        if (this.txtButton) {
            this.resize(this.width, this.height);
            this.doneLoading = true;
            return;
        }
        super.waitForImage(doLayout);
    }

    public void paint(Graphics g) {
        if (!this.doneLoading) {
            this.waitForImage(true);
        } else if (!this.txtButton) {
            if (this.explicitSize) {
                g.drawImage(this.image, this.border, this.border, this.width - 2 * this.border, this.height - 2 * this.border, this);
            } else {
                g.drawImage(this.image, this.border, this.border, this);
            }
            this.drawRect(g, 0, 0, this.width - 1, this.height - 1, this.border, this.borderColor);
            if (this.grayImage == null) {
                this.createGrayImage(g);
            }
        } else {
            int tsize = this.text.length * 9 / 2;
            g.drawChars(this.text, 0, this.text.length, this.width / 2 - tsize, this.height / 2 + 5);
        }
        this.drawBorder(true);
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.debug("[addActionListener]: " + l);
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected void processEvent(AWTEvent e) {
        this.debug("[processEvent]: " + e);
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        if (e instanceof MouseEvent) {
            this.processMouseEvent((MouseEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 502) {
            this.mouseIsDown = false;
            this.paint(this.getGraphics());
            this.processEvent(new ActionEvent(this, 1001, this.actionCommand));
        } else if (e.getID() == 501) {
            this.mouseIsDown = true;
            Graphics g = this.getGraphics();
            int border = this.getBorder();
            if (!this.txtButton) {
                if (this.hasExplicitSize()) {
                    g.drawImage(this.getGrayImage(), border, border, this.getWidth() - 2 * border, this.getHeight() - 2 * border, this);
                } else {
                    g.drawImage(this.getGrayImage(), border, border, this);
                }
            }
            this.drawBorder(false);
        } else if (e.getID() == 505 && this.mouseIsDown) {
            this.paint(this.getGraphics());
        }
        super.processMouseEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        this.debug("Action Event occurred.");
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    protected void setText(String t) {
        if (this.txtButton) {
            this.text = new char[t.length()];
            t.getChars(0, t.length(), this.text, 0);
            this.paint(this.getGraphics());
            this.validate();
        }
    }

    public int getDarkness() {
        return this.darkness;
    }

    public void setDarkness(int darkness) {
        this.darkness = darkness;
    }

    public Image getGrayImage() {
        return this.grayImage;
    }

    public void setGrayImage(Image grayImage) {
        this.grayImage = grayImage;
    }

    public void drawBorder(boolean isUp) {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.setColor(this.getBorderColor());
        int left = 0;
        int top = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        int border = this.getBorder();
        int i = 0;
        while (i < border) {
            g.draw3DRect(left, top, width, height, isUp);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
            ++i;
        }
    }

    private void setBorders() {
        this.setBorder(4);
        this.setBorderColor(defaultBorderColor);
    }

    private void createGrayImage(Graphics g) {
        GrayFilter filter = new GrayFilter(this.darkness);
        FilteredImageSource producer = new FilteredImageSource(this.getImage().getSource(), filter);
        this.grayImage = this.createImage(producer);
        int border = this.getBorder();
        if (this.hasExplicitSize()) {
            this.prepareImage(this.grayImage, this.getWidth() - 2 * border, this.getHeight() - 2 * border, this);
        } else {
            this.prepareImage(this.grayImage, this);
        }
        super.paint(g);
    }
}

