/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpegSegmentReader {
    @NotNull
    private final JpegSegmentData _segmentData;
    private static final byte SEGMENT_SOS = -38;
    private static final byte MARKER_EOI = -39;
    public static final byte SEGMENT_APP0 = -32;
    public static final byte SEGMENT_APP1 = -31;
    public static final byte SEGMENT_APP2 = -30;
    public static final byte SEGMENT_APP3 = -29;
    public static final byte SEGMENT_APP4 = -28;
    public static final byte SEGMENT_APP5 = -27;
    public static final byte SEGMENT_APP6 = -26;
    public static final byte SEGMENT_APP7 = -25;
    public static final byte SEGMENT_APP8 = -24;
    public static final byte SEGMENT_APP9 = -23;
    public static final byte SEGMENT_APPA = -22;
    public static final byte SEGMENT_APPB = -21;
    public static final byte SEGMENT_APPC = -20;
    public static final byte SEGMENT_APPD = -19;
    public static final byte SEGMENT_APPE = -18;
    public static final byte SEGMENT_APPF = -17;
    public static final byte SEGMENT_SOI = -40;
    public static final byte SEGMENT_DQT = -37;
    public static final byte SEGMENT_DHT = -60;
    public static final byte SEGMENT_SOF0 = -64;
    public static final byte SEGMENT_COM = -2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JpegSegmentReader(@NotNull File file2) throws JpegProcessingException, IOException {
        if (file2 == null) {
            throw new NullPointerException();
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file2);
            this._segmentData = this.readSegments(new BufferedInputStream(inputStream), false);
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
    }

    public JpegSegmentReader(@NotNull byte[] fileContents) throws JpegProcessingException {
        if (fileContents == null) {
            throw new NullPointerException();
        }
        BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(fileContents));
        this._segmentData = this.readSegments(stream, false);
    }

    public JpegSegmentReader(@NotNull InputStream inputStream, boolean waitForBytes) throws JpegProcessingException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this._segmentData = this.readSegments(bufferedInputStream, waitForBytes);
    }

    @Nullable
    public byte[] readSegment(byte segmentMarker) {
        return this.readSegment(segmentMarker, 0);
    }

    @Nullable
    public byte[] readSegment(byte segmentMarker, int occurrence) {
        return this._segmentData.getSegment(segmentMarker, occurrence);
    }

    @NotNull
    public Iterable<byte[]> readSegments(byte segmentMarker) {
        return this._segmentData.getSegments(segmentMarker);
    }

    public final int getSegmentCount(byte segmentMarker) {
        return this._segmentData.getSegmentCount(segmentMarker);
    }

    @NotNull
    public final JpegSegmentData getSegmentData() {
        return this._segmentData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private JpegSegmentData readSegments(@NotNull BufferedInputStream jpegInputStream, boolean waitForBytes) throws JpegProcessingException {
        JpegSegmentData segmentData = new JpegSegmentData();
        try {
            boolean hasValidHeader;
            int offset = 0;
            byte[] headerBytes = new byte[2];
            if (jpegInputStream.read(headerBytes, 0, 2) != 2) {
                throw new JpegProcessingException("not a jpeg file");
            }
            boolean bl = hasValidHeader = (headerBytes[0] & 0xFF) == 255 && (headerBytes[1] & 0xFF) == 216;
            if (!hasValidHeader) {
                throw new JpegProcessingException("not a jpeg file");
            }
            offset += 2;
            while (true) {
                if (!this.checkForBytesOnStream(jpegInputStream, 4, waitForBytes)) {
                    throw new JpegProcessingException("stream ended before segment header could be read");
                }
                byte segmentIdentifier = (byte)(jpegInputStream.read() & 0xFF);
                if ((segmentIdentifier & 0xFF) != 255) {
                    throw new JpegProcessingException("expected jpeg segment start identifier 0xFF at offset " + offset + ", not 0x" + Integer.toHexString(segmentIdentifier & 0xFF));
                }
                ++offset;
                byte thisSegmentMarker = (byte)(jpegInputStream.read() & 0xFF);
                ++offset;
                byte[] segmentLengthBytes = new byte[2];
                if (jpegInputStream.read(segmentLengthBytes, 0, 2) != 2) {
                    throw new JpegProcessingException("Jpeg data ended unexpectedly.");
                }
                offset += 2;
                int segmentLength = segmentLengthBytes[0] << 8 & 0xFF00 | segmentLengthBytes[1] & 0xFF;
                if (!this.checkForBytesOnStream(jpegInputStream, segmentLength -= 2, waitForBytes)) {
                    throw new JpegProcessingException("segment size would extend beyond file stream length");
                }
                if (segmentLength < 0) {
                    throw new JpegProcessingException("segment size would be less than zero");
                }
                byte[] segmentBytes = new byte[segmentLength];
                if (jpegInputStream.read(segmentBytes, 0, segmentLength) != segmentLength) {
                    throw new JpegProcessingException("Jpeg data ended unexpectedly.");
                }
                offset += segmentLength;
                if ((thisSegmentMarker & 0xFF) == 218) {
                    JpegSegmentData jpegSegmentData = segmentData;
                    return jpegSegmentData;
                }
                if ((thisSegmentMarker & 0xFF) == 217) {
                    JpegSegmentData jpegSegmentData = segmentData;
                    return jpegSegmentData;
                }
                segmentData.addSegment(thisSegmentMarker, segmentBytes);
                continue;
                break;
            }
        }
        catch (IOException ioe) {
            throw new JpegProcessingException("IOException processing Jpeg file: " + ioe.getMessage(), ioe);
        }
        finally {
            try {
                if (jpegInputStream != null) {
                    jpegInputStream.close();
                }
            }
            catch (IOException ioe) {
                throw new JpegProcessingException("IOException processing Jpeg file: " + ioe.getMessage(), ioe);
            }
        }
    }

    private boolean checkForBytesOnStream(@NotNull BufferedInputStream stream, int bytesNeeded, boolean waitForBytes) throws IOException {
        if (!waitForBytes) {
            return bytesNeeded <= stream.available();
        }
        for (int count = 40; count > 0; --count) {
            if (bytesNeeded <= stream.available()) {
                return true;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return false;
    }
}

