/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import codecLib.mpa.Decoder;
import codecLib.mpa.FrameInfo;
import codecLib.mpa.MPADException;
import codecLib.mpa.OutputConverter;
import com.sun.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    private int pendingDataSize = 0;
    private static final int OUTSIZE = 32768;
    private byte[] pendingData = new byte[32768];
    private Decoder decoder = null;
    private FrameInfo info = null;
    private boolean expectingSameInputBuffer = false;
    private long accumTS = 0L;
    private AudioFormat aFormat = null;
    float[][] fsamp = new float[12][1152];
    int[] fsampOffset = new int[12];
    int MAXOUTFRAMESIZE = 27648;
    int MIMINFRAMESIZE = 13;
    int outFrameSize = 0;

    public JavaDecoder() {
        this.inputFormats = new Format[]{new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1)};
    }

    public String getName() {
        return "MPEG Layer 3 Decoder";
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        if (input instanceof AudioFormat) {
            AudioFormat af = (AudioFormat)input;
            this.outputFormats = new Format[]{new AudioFormat("LINEAR", af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels(), 1, 1)};
        } else {
            this.outputFormats = new Format[0];
        }
        return this.outputFormats;
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (this.decoder != null) {
            this.close();
        }
        try {
            this.decoder = new Decoder();
            this.pendingDataSize = 0;
            this.expectingSameInputBuffer = false;
            this.accumTS = 0L;
            this.aFormat = (AudioFormat)this.outputFormat;
            return;
        }
        catch (Throwable e2) {
            System.out.println("mpa JavaDecoder: open " + e2);
            throw new ResourceUnavailableException("could not open " + this.getName());
        }
    }

    public synchronized void close() {
        if (this.decoder != null) {
            this.decoder = null;
        }
        if (this.info != null) {
            this.info = null;
        }
    }

    public synchronized void reset() {
        if (this.decoder != null) {
            this.close();
            try {
                this.open();
            }
            catch (ResourceUnavailableException rue) {
                System.err.println("MP3 Decoder: " + rue);
            }
        }
    }

    public synchronized int process(Buffer in, Buffer out) {
        if (this.isEOM(in)) {
            this.propagateEOM(out);
            return 0;
        }
        Object inObject = in.getData();
        Object outObject = out.getData();
        if (outObject == null) {
            outObject = new byte[32768];
            out.setData(outObject);
        }
        if (!(inObject instanceof byte[]) || !(outObject instanceof byte[])) {
            return 1;
        }
        byte[] inData = (byte[])inObject;
        byte[] outData = (byte[])outObject;
        int inLength = in.getLength();
        int inOffset = in.getOffset();
        int outDataSize = outData.length;
        int outOffset = 0;
        int pendingDataOffset = 0;
        int byteCount = 0;
        if (!this.expectingSameInputBuffer && this.pendingDataSize + inLength <= this.pendingData.length) {
            System.arraycopy(inData, inOffset, this.pendingData, this.pendingDataSize, inLength);
            this.pendingDataSize += inLength;
        }
        if (this.decoder != null) {
            while (outDataSize - outOffset >= this.MAXOUTFRAMESIZE && this.pendingDataSize >= this.MIMINFRAMESIZE) {
                if (this.info == null) {
                    this.info = new FrameInfo();
                    try {
                        this.decoder.getNextFrameInfo(this.info, this.pendingData, pendingDataOffset, this.pendingDataSize);
                        this.outFrameSize = this.info.getNumberOfSamples() * this.info.getNumberOfChannels() * 2;
                    }
                    catch (MPADException e2) {
                        this.info = null;
                        break;
                    }
                }
                try {
                    byteCount = this.decoder.decode(this.fsamp, this.fsampOffset, this.pendingData, pendingDataOffset, this.pendingDataSize);
                }
                catch (MPADException e3) {
                    if (e3.getState() == -10) {
                        return 1;
                    }
                    try {
                        this.decoder.getCurrFrameInfo(this.info);
                    }
                    catch (MPADException e2) {
                        this.info = null;
                        break;
                    }
                    if (e3.getState() == -9) {
                        byteCount = this.info.getHeaderOffset() + this.info.getFrameLength();
                        pendingDataOffset += byteCount;
                        this.pendingDataSize -= byteCount;
                        continue;
                    }
                    this.info = null;
                    break;
                }
                if (this.info.getNumberOfChannels() == 1) {
                    OutputConverter.convert(outData, outOffset, this.fsamp[0], this.fsampOffset[0], this.info.getNumberOfSamples());
                } else {
                    OutputConverter.convert(outData, outOffset, this.fsamp[0], this.fsampOffset[0], this.fsamp[1], this.fsampOffset[1], this.info.getNumberOfSamples());
                }
                outOffset += this.outFrameSize;
                pendingDataOffset += byteCount;
                this.pendingDataSize -= byteCount;
            }
        }
        if (pendingDataOffset != 0) {
            System.arraycopy(this.pendingData, pendingDataOffset, this.pendingData, 0, this.pendingDataSize);
        }
        out.setLength(outOffset);
        out.setFormat(this.outputFormat);
        if (this.aFormat != null && this.accumTS != 0L && in.getTimeStamp() > 0L) {
            out.setTimeStamp(in.getTimeStamp() + this.aFormat.computeDuration(this.accumTS));
        }
        if (this.pendingDataSize > 1024) {
            this.expectingSameInputBuffer = true;
            this.accumTS += (long)out.getLength();
            return 2;
        }
        this.accumTS = 0L;
        this.expectingSameInputBuffer = false;
        return 0;
    }
}

