/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LeicaSCNReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeicaSCNReader.class);
    private static final String SCHEMA_2010_03 = "http://www.leica-microsystems.com/scn/2010/03/10";
    private static final String SCHEMA_2010_10 = "http://www.leica-microsystems.com/scn/2010/10/01";
    LeicaSCNHandler handler;

    public LeicaSCNReader() {
        super("Leica SCN", new String[]{"scn"});
        this.domains = new String[]{"Histology"};
        this.suffixNecessary = false;
        this.suffixSufficient = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        block22: {
            if (super.isThisType(name, open) && open) {
                RandomAccessInputStream stream = null;
                try {
                    stream = new RandomAccessInputStream(name);
                    TiffParser tiffParser = new TiffParser(stream);
                    if (!tiffParser.isValidHeader()) {
                        boolean bl = false;
                        return bl;
                    }
                    String imageDescription = tiffParser.getComment();
                    if (imageDescription == null) break block22;
                    try {
                        LeicaSCNHandler handler = new LeicaSCNHandler();
                        XMLTools.parseXML(imageDescription, (DefaultHandler)handler);
                        boolean bl = true;
                        return bl;
                    }
                    catch (Exception se) {
                        try {
                            LOGGER.debug("XML parsing failed", se);
                        }
                        catch (IOException e) {
                            LOGGER.debug("I/O exception during isThisType() evaluation.", e);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.debug("I/O exception during stream closure.", e);
                    }
                }
            }
        }
        return false;
    }

    private int imageIFD(int no) {
        int s = this.getCoreIndex();
        Image i = this.handler.imageMap.get(s);
        int[] dims = this.getZCTCoords(no);
        int dz = dims[0];
        int dc = dims[1];
        int dr = s - this.getParent(s);
        return i.pixels.lookupDimension((int)dz, (int)dc, (int)dr).ifd;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        int ifd = this.imageIFD(no);
        this.tiffParser.getSamples((IFD)this.ifds.get(ifd), buf, x, y, w, h);
        return buf;
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        int originalIndex = this.getCoreIndex();
        Image i = this.handler.imageMap.get(this.getCoreIndex());
        this.setCoreIndex(this.getParent(originalIndex) + i.imageThumbnail);
        byte[] thumb = FormatTools.openThumbBytes(this, no);
        this.setCoreIndex(originalIndex);
        return thumb;
    }

    @Override
    public int getThumbSizeX() {
        int originalIndex = this.getCoreIndex();
        Image i = this.handler.imageMap.get(this.getCoreIndex());
        this.setCoreIndex(this.getParent(originalIndex) + i.imageThumbnail);
        int size = super.getThumbSizeX();
        this.setCoreIndex(originalIndex);
        return size;
    }

    @Override
    public int getThumbSizeY() {
        int originalIndex = this.getCoreIndex();
        Image i = this.handler.imageMap.get(this.getCoreIndex());
        this.setCoreIndex(this.getParent(originalIndex) + i.imageThumbnail);
        int size = super.getThumbSizeY();
        this.setCoreIndex(originalIndex);
        return size;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        this.handler = null;
        if (!fileOnly) {
            // empty if block
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.imageIFD(0))).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.imageIFD(0))).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    protected void initCoreMetadata(int s, int resolution) throws FormatException, IOException {
        Dimension dimension;
        ImageCollection c = this.handler.collection;
        Image i = this.handler.imageMap.get(s);
        if (c == null || i == null) {
            throw new FormatException("Error setting core metadata for image number " + s);
        }
        CoreMetadata ms = (CoreMetadata)this.core.get(s);
        if (resolution == 0) {
            ms.resolutionCount = i.pixels.sizeR;
        }
        if ((dimension = i.pixels.lookupDimension(0, 0, resolution)) == null) {
            throw new FormatException("No dimension information for subresolution=" + resolution);
        }
        IFD ifd = (IFD)this.ifds.get(dimension.ifd);
        PhotoInterp pi = ifd.getPhotometricInterpretation();
        int samples = ifd.getSamplesPerPixel();
        ms.rgb = samples > 1 || pi == PhotoInterp.RGB;
        ms.sizeX = (int)dimension.sizeX;
        ms.sizeY = (int)dimension.sizeY;
        ms.sizeZ = i.pixels.sizeZ;
        ms.sizeT = 1;
        int n = ms.sizeC = ms.rgb ? samples : i.pixels.sizeC;
        if (ifd.getImageWidth() != (long)ms.sizeX || ifd.getImageLength() != (long)ms.sizeY) {
            throw new FormatException("IFD dimensions do not match XML dimensions for image " + s + ": x=" + ifd.getImageWidth() + ", " + ms.sizeX + ", y=" + ifd.getImageLength() + ", " + ms.sizeY);
        }
        ms.orderCertain = true;
        ms.littleEndian = ifd.isLittleEndian();
        ms.indexed = pi == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
        ms.imageCount = i.pixels.sizeZ * i.pixels.sizeC;
        ms.pixelType = ifd.getPixelType();
        ms.metadataComplete = true;
        ms.interleaved = false;
        ms.falseColor = false;
        ms.dimensionOrder = "XYCZT";
        ms.thumbnail = i.imageThumbnail == resolution;
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.tiffParser.setDoCaching(true);
        String imageDescription = this.tiffParser.getComment();
        this.handler = new LeicaSCNHandler();
        if (imageDescription != null) {
            try {
                XMLTools.parseXML(imageDescription, (DefaultHandler)this.handler);
            }
            catch (Exception se) {
                throw new FormatException("Failed to parse XML", se);
            }
        }
        int count = this.handler.count();
        this.ifds = this.tiffParser.getIFDs();
        if (this.ifds.size() < count) {
            count = this.ifds.size();
        }
        this.core.clear();
        int resolution = 0;
        int parent = 0;
        for (int i = 0; i < count; ++i) {
            if (resolution == 0) {
                parent = i;
            }
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            this.tiffParser.fillInIFD((IFD)this.ifds.get(this.handler.IFDMap.get(i)));
            this.initCoreMetadata(i, resolution);
            if (++resolution != ((CoreMetadata)this.core.get((int)parent)).resolutionCount) continue;
            resolution = 0;
        }
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        HashMap<String, Integer> instrumentIDs = new HashMap<String, Integer>();
        int instrumentidno = 0;
        HashMap<String, String> objectives = new HashMap<String, String>();
        int objectiveidno = 0;
        int parent = 0;
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            int coreIndex = this.seriesToCoreIndex(s);
            ImageCollection c = this.handler.collection;
            Image i = this.handler.imageMap.get(coreIndex);
            int subresolution = coreIndex - parent;
            if (!this.hasFlattenedResolutions()) {
                subresolution = 0;
            }
            if (((CoreMetadata)this.core.get((int)s)).resolutionCount > 1) {
                parent = s;
            } else if (((CoreMetadata)this.core.get((int)parent)).resolutionCount - 1 == subresolution) {
                parent = s + 1;
            }
            Dimension dimension = i.pixels.lookupDimension(0, 0, subresolution);
            if (dimension == null) {
                throw new FormatException("No dimension information for subresolution=" + subresolution);
            }
            double sizeX = (double)i.vSizeX / 1000.0;
            double sizeY = (double)i.vSizeY / 1000.0;
            Length offsetX = new Length(i.vOffsetX, UNITS.REFERENCEFRAME);
            Length offsetY = new Length(i.vOffsetY, UNITS.REFERENCEFRAME);
            double sizeZ = (double)i.vSpacingZ / 1000.0;
            store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX(sizeX / (double)dimension.sizeX), s);
            store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY(sizeY / (double)dimension.sizeY), s);
            store.setPixelsPhysicalSizeZ(FormatTools.getPhysicalSizeZ(sizeZ), s);
            if (instrumentIDs.get(i.devModel) == null) {
                String instrumentID = MetadataTools.createLSID("Instrument", instrumentidno);
                instrumentIDs.put(i.devModel, instrumentidno);
                store.setInstrumentID(instrumentID, instrumentidno);
                ++instrumentidno;
            }
            int inst = (Integer)instrumentIDs.get(i.devModel);
            String objectiveName = i.devModel + ":" + i.objMag;
            if (objectives.get(objectiveName) == null) {
                String objectiveID = MetadataTools.createLSID("Objective", inst, objectiveidno);
                objectives.put(objectiveName, objectiveID);
                store.setObjectiveID(objectiveID, inst, objectiveidno);
                Double mag = Double.parseDouble(i.objMag);
                store.setObjectiveNominalMagnification(mag, inst, objectiveidno);
                store.setObjectiveCalibratedMagnification(mag, inst, objectiveidno);
                store.setObjectiveLensNA(new Double(i.illumNA), inst, objectiveidno);
                ++objectiveidno;
            }
            store.setImageInstrumentRef(MetadataTools.createLSID("Instrument", inst), s);
            store.setObjectiveSettingsID((String)objectives.get(objectiveName), s);
            if (i.illumSource.equals("brightfield")) {
                store.setChannelIlluminationType(IlluminationType.TRANSMITTED, s, 0);
            } else {
                store.setChannelIlluminationType(IlluminationType.OTHER, s, 0);
                LOGGER.debug("Unknown illumination source {}", (Object)i.illumSource);
            }
            CoreMetadata ms = (CoreMetadata)this.core.get(s);
            for (int q = 0; q < ms.imageCount; ++q) {
                store.setPlanePositionX(offsetX, s, q);
                store.setPlanePositionY(offsetY, s, q);
            }
            store.setImageName(i.name + " (R" + subresolution + ")", s);
            store.setImageDescription("Collection " + c.name, s);
            store.setImageAcquisitionDate(new Timestamp(i.creationDate), s);
            this.addSeriesMeta("collection.name", c.name);
            this.addSeriesMeta("collection.uuid", c.uuid);
            this.addSeriesMeta("collection.barcode", c.barcode);
            this.addSeriesMeta("collection.ocr", c.ocr);
            this.addSeriesMeta("creationDate", i.creationDate);
            this.addSeriesMeta("device.model for image", i.devModel);
            this.addSeriesMeta("device.version for image", i.devVersion);
            this.addSeriesMeta("view.sizeX for image", i.vSizeX);
            this.addSeriesMeta("view.sizeY for image", i.vSizeY);
            this.addSeriesMeta("view.offsetX for image", i.vOffsetX);
            this.addSeriesMeta("view.offsetY for image", i.vOffsetY);
            this.addSeriesMeta("view.spacingZ for image", i.vSpacingZ);
            this.addSeriesMeta("scanSettings.objectiveSettings.objective for image", i.objMag);
            this.addSeriesMeta("scanSettings.illuminationSettings.numericalAperture for image", i.illumNA);
            this.addSeriesMeta("scanSettings.illuminationSettings.illuminationSource for image", i.illumSource);
        }
    }

    private int getParent(int coreIndex) {
        int resCount;
        for (int parent = 0; parent < this.core.size(); parent += resCount) {
            resCount = ((CoreMetadata)this.core.get((int)parent)).resolutionCount;
            if (parent + resCount <= coreIndex) continue;
            return parent;
        }
        return -1;
    }

    class Dimension {
        long sizeX = 0L;
        long sizeY = 0L;
        int z = 0;
        int c = 0;
        int r = 0;
        int ifd = 0;

        Dimension(Attributes attrs) {
            String s = attrs.getValue("r");
            if (s != null) {
                this.r = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("z")) != null) {
                this.z = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("c")) != null) {
                this.c = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("sizeX")) != null) {
                this.sizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.sizeY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("ifd")) != null) {
                this.ifd = Integer.parseInt(s);
            }
        }
    }

    class Pixels {
        ArrayList<Dimension> dims = new ArrayList();
        long sizeX;
        long sizeY;
        int sizeZ;
        int sizeC;
        int sizeR;
        int lastIFD;

        Pixels(Attributes attrs) {
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.sizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.sizeY = Long.parseLong(s);
            }
        }

        public Dimension lookupDimension(int z, int c, int resolution) {
            for (Dimension d : this.dims) {
                if (d.z != z || d.c != c || d.r != resolution) continue;
                return d;
            }
            return null;
        }
    }

    class Image {
        int imageNumStart;
        int imageNumEnd;
        int imageThumbnail;
        long thumbSizeX;
        String name;
        String uuid;
        String creationDate;
        String devModel;
        String devVersion;
        Pixels pixels;
        long vSizeX;
        long vSizeY;
        long vOffsetX;
        long vOffsetY;
        long vSpacingZ;
        String objMag;
        String illumNA;
        String illumSource;

        Image(Attributes attrs) {
            this.name = attrs.getValue("name");
            this.uuid = attrs.getValue("uuid");
        }

        void setView(Attributes attrs) {
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.vSizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.vSizeY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("offsetX")) != null) {
                this.vOffsetX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("offsetY")) != null) {
                this.vOffsetY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("spacingZ")) != null) {
                this.vSpacingZ = Long.parseLong(s);
            }
        }
    }

    class ImageCollection {
        String name;
        String uuid;
        long sizeX;
        long sizeY;
        String barcode;
        String ocr;
        ArrayList<Image> images;

        ImageCollection(Attributes attrs) {
            this.name = attrs.getValue("name");
            this.uuid = attrs.getValue("uuid");
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.sizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.sizeY = Long.parseLong(s);
            }
            this.barcode = attrs.getValue("barcode");
            this.ocr = attrs.getValue("ocr");
            this.images = new ArrayList();
        }
    }

    class LeicaSCNHandler
    extends DefaultHandler {
        boolean valid = false;
        public ImageCollection collection;
        public Image currentImage;
        public int seriesIndex;
        public ArrayList<Integer> IFDMap = new ArrayList();
        public ArrayList<Image> imageMap = new ArrayList();
        public Deque<String> nameStack = new ArrayDeque<String>();
        public String cdata;
        public int resolutionCount = 0;

        LeicaSCNHandler() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (!this.nameStack.isEmpty() && this.nameStack.peek().equals(qName)) {
                this.nameStack.pop();
            }
            if (qName.equals("image")) {
                this.currentImage.imageNumStart = this.seriesIndex;
                this.seriesIndex += this.currentImage.pixels.sizeR * this.currentImage.pixels.sizeC * this.currentImage.pixels.sizeZ;
                this.currentImage.imageNumEnd = this.seriesIndex - 1;
                this.resolutionCount += this.currentImage.pixels.sizeR;
                this.currentImage = null;
            } else if (qName.equals("creationDate")) {
                this.currentImage.creationDate = this.cdata;
            } else if (qName.equals("pixels")) {
                Pixels p = this.currentImage.pixels;
                int sizeC = 0;
                int sizeR = 0;
                int sizeZ = 0;
                for (Dimension d : p.dims) {
                    if (d.c > sizeC) {
                        sizeC = d.c;
                    }
                    if (d.r > sizeR) {
                        sizeR = d.r;
                    }
                    if (d.z <= sizeZ) continue;
                    sizeZ = d.z;
                }
                p.sizeC = ++sizeC;
                p.sizeR = ++sizeR;
                p.sizeZ = ++sizeZ;
                for (Dimension d : p.dims) {
                    if (d.r != 0 && this.currentImage.thumbSizeX <= d.sizeX) continue;
                    this.currentImage.thumbSizeX = d.sizeX;
                    this.currentImage.imageThumbnail = d.r;
                }
                for (int cr = 0; cr < sizeR; ++cr) {
                    this.imageMap.add(this.currentImage);
                    for (int cc = 0; cc < sizeC; ++cc) {
                        for (int cz = 0; cz < sizeZ; ++cz) {
                            this.IFDMap.add(p.lookupDimension((int)cz, (int)cc, (int)cr).ifd);
                        }
                    }
                }
            } else if (qName.equals("objective")) {
                this.currentImage.objMag = this.cdata;
            } else if (qName.equals("numericalAperture")) {
                this.currentImage.illumNA = this.cdata;
            } else if (qName.equals("illuminationSource")) {
                this.currentImage.illumSource = this.cdata;
            }
            this.cdata = null;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String s = new String(ch, start, length);
            this.cdata = this.cdata == null ? s : this.cdata + s;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.cdata = null;
            if (qName.equals("scn")) {
                String ns = attributes.getValue("xmlns");
                if (ns == null) {
                    throw new SAXException("Invalid Leica SCN XML");
                }
                if (!ns.equals(LeicaSCNReader.SCHEMA_2010_03) && !ns.equals(LeicaSCNReader.SCHEMA_2010_10)) {
                    LOGGER.warn("Unknown Leica SCN XML schema: " + ns + "; this file may not be read correctly");
                }
                this.valid = true;
                this.seriesIndex = 0;
            }
            if (!this.valid) {
                throw new SAXException("Invalid Leica SCN XML");
            }
            if (qName.equals("collection")) {
                this.collection = new ImageCollection(attributes);
            } else if (qName.equals("image")) {
                this.currentImage = new Image(attributes);
                this.collection.images.add(this.currentImage);
            } else if (qName.equals("device")) {
                this.currentImage.devModel = attributes.getValue("model");
                this.currentImage.devVersion = attributes.getValue("version");
            } else if (qName.equals("pixels")) {
                if (this.currentImage.pixels != null) throw new SAXException("Invalid Leica SCN XML: Multiple pixels elements for single image");
                this.currentImage.pixels = new Pixels(attributes);
            } else if (qName.equals("dimension")) {
                this.currentImage.pixels.dims.add(new Dimension(attributes));
            } else if (qName.equals("view")) {
                this.currentImage.setView(attributes);
            }
            this.nameStack.push(qName);
        }

        int count() {
            return this.resolutionCount;
        }
    }
}

