/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class ImagesToStack
implements PlugIn {
    private static final int rgb = 33;
    private static final int COPY_CENTER = 0;
    private static final int COPY_TOP_LEFT = 1;
    private static final int SCALE_SMALL = 2;
    private static final int SCALE_LARGE = 3;
    private static final String[] methods = new String[]{"Copy (center)", "Copy (top-left)", "Scale (smallest)", "Scale (largest)"};
    private static int method = 0;
    private static boolean bicubic;
    private static boolean keep;
    private static boolean titlesAsLabels;
    private String filter;
    private int width;
    private int height;
    private int maxWidth;
    private int maxHeight;
    private int minWidth;
    private int minHeight;
    private int minSize;
    private int maxSize;
    private boolean allInvertedLuts;
    private Calibration cal2;
    private int stackType;
    private ImagePlus[] image;
    private String name = "Stack";

    public void run(String arg) {
        this.convertImagesToStack();
    }

    public void convertImagesToStack() {
        boolean scale = false;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error("No images are open.");
            return;
        }
        int count = 0;
        int stackCount = 0;
        this.image = new ImagePlus[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp.getStackSize() == 1) {
                this.image[count++] = imp;
                continue;
            }
            ++stackCount;
        }
        if (count < 2) {
            String msg = "";
            if (stackCount > 1) {
                msg = "\n \nUse the Image>Stacks>Tools>Concatenate\ncommand to combine stacks.";
            }
            IJ.error("Images to Stack", "There must be at least two open 2D images." + msg);
            return;
        }
        this.filter = null;
        count = this.findMinMaxSize(count);
        boolean sizesDiffer = this.width != this.minWidth || this.height != this.minHeight;
        boolean showDialog = true;
        String macroOptions = Macro.getOptions();
        if (IJ.macroRunning() && macroOptions == null) {
            if (sizesDiffer) {
                IJ.error("Images are not all the same size");
                return;
            }
            showDialog = false;
        }
        if (showDialog) {
            GenericDialog gd = new GenericDialog("Images to Stack");
            if (sizesDiffer) {
                String msg = "The " + count + " images differ in size (smallest=" + this.minWidth + "x" + this.minHeight + ",\nlargest=" + this.maxWidth + "x" + this.maxHeight + "). They will be converted\nto a stack using the specified method.";
                gd.setInsets(0, 0, 5);
                gd.addMessage(msg);
                gd.addChoice("Method:", methods, methods[method]);
            }
            gd.addStringField("Name:", this.name, 12);
            gd.addStringField("Title Contains:", "", 12);
            if (sizesDiffer) {
                gd.addCheckbox("Bicubic Interpolation", bicubic);
            }
            gd.addCheckbox("Use Titles as Labels", titlesAsLabels);
            gd.addCheckbox("Keep Source Images", keep);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            if (sizesDiffer) {
                method = gd.getNextChoiceIndex();
            }
            this.name = gd.getNextString();
            this.filter = gd.getNextString();
            if (sizesDiffer) {
                bicubic = gd.getNextBoolean();
            }
            titlesAsLabels = gd.getNextBoolean();
            keep = gd.getNextBoolean();
            if (this.filter != null && (this.filter.equals("") || this.filter.equals("*"))) {
                this.filter = null;
            }
            if (this.filter != null && (count = this.findMinMaxSize(count)) == 0) {
                IJ.error("Images to Stack", "None of the images have a title containing \"" + this.filter + "\"");
            }
        } else {
            keep = false;
        }
        if (method == 2) {
            this.width = this.minWidth;
            this.height = this.minHeight;
        } else if (method == 3) {
            this.width = this.maxWidth;
            this.height = this.maxHeight;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        ImageStack stack = new ImageStack(this.width, this.height);
        FileInfo fi = this.image[0].getOriginalFileInfo();
        if (fi != null && fi.directory == null) {
            fi = null;
        }
        for (int i = 0; i < count; ++i) {
            FileInfo fi2;
            String info;
            String label;
            ImageProcessor ip = this.image[i].getProcessor();
            boolean invertedLut = ip.isInvertedLut();
            if (ip == null) break;
            if (ip.getMin() < min) {
                min = ip.getMin();
            }
            if (ip.getMax() > max) {
                max = ip.getMax();
            }
            String string = label = titlesAsLabels ? this.image[i].getTitle() : null;
            if (label != null && (info = (String)this.image[i].getProperty("Info")) != null) {
                label = label + "\n" + info;
            }
            if (fi != null && (fi2 = this.image[i].getOriginalFileInfo()) != null && !fi.directory.equals(fi2.directory)) {
                fi = null;
            }
            switch (this.stackType) {
                case 16: {
                    ip = ip.convertToShort(false);
                    break;
                }
                case 32: {
                    ip = ip.convertToFloat();
                    break;
                }
                case 33: {
                    ip = ip.convertToRGB();
                    break;
                }
            }
            if (invertedLut && !this.allInvertedLuts) {
                if (keep) {
                    ip = ip.duplicate();
                }
                ip.invert();
            }
            if (ip.getWidth() != this.width || ip.getHeight() != this.height) {
                switch (method) {
                    case 0: 
                    case 1: {
                        ImageProcessor ip2 = null;
                        switch (this.stackType) {
                            case 8: {
                                ip2 = new ByteProcessor(this.width, this.height);
                                break;
                            }
                            case 16: {
                                ip2 = new ShortProcessor(this.width, this.height);
                                break;
                            }
                            case 32: {
                                ip2 = new FloatProcessor(this.width, this.height);
                                break;
                            }
                            case 33: {
                                ip2 = new ColorProcessor(this.width, this.height);
                            }
                        }
                        int xoff = 0;
                        int yoff = 0;
                        if (method == 0) {
                            xoff = (this.width - ip.getWidth()) / 2;
                            yoff = (this.height - ip.getHeight()) / 2;
                        }
                        ip2.insert(ip, xoff, yoff);
                        ip = ip2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        ip.setInterpolationMethod(bicubic ? 2 : 1);
                        ip.resetRoi();
                        ip = ip.resize(this.width, this.height);
                    }
                }
            } else if (keep) {
                ip = ip.duplicate();
            }
            stack.addSlice(label, ip);
            if (i == 0 && invertedLut && !this.allInvertedLuts) {
                stack.setColorModel(null);
            }
            if (keep) continue;
            this.image[i].changes = false;
            this.image[i].close();
        }
        if (stack.getSize() == 0) {
            return;
        }
        ImagePlus imp = new ImagePlus(this.name, stack);
        if (this.stackType == 16 || this.stackType == 32) {
            imp.getProcessor().setMinAndMax(min, max);
        }
        if (this.cal2 != null) {
            imp.setCalibration(this.cal2);
        }
        if (fi != null) {
            fi.fileName = "";
            fi.nImages = imp.getStackSize();
            imp.setFileInfo(fi);
        }
        imp.show();
    }

    final int findMinMaxSize(int count) {
        int index = 0;
        this.stackType = 8;
        this.width = 0;
        this.height = 0;
        this.cal2 = this.image[0].getCalibration();
        this.maxWidth = 0;
        this.maxHeight = 0;
        this.minWidth = Integer.MAX_VALUE;
        this.minHeight = Integer.MAX_VALUE;
        this.minSize = Integer.MAX_VALUE;
        this.allInvertedLuts = true;
        this.maxSize = 0;
        for (int i = 0; i < count; ++i) {
            int size;
            int type;
            if (this.exclude(this.image[i].getTitle())) continue;
            if (this.image[i].getType() == 3) {
                this.stackType = 33;
            }
            if (!this.image[i].getProcessor().isInvertedLut()) {
                this.allInvertedLuts = false;
            }
            if ((type = this.image[i].getBitDepth()) == 24) {
                type = 33;
            }
            if (type > this.stackType) {
                this.stackType = type;
            }
            int w = this.image[i].getWidth();
            int h = this.image[i].getHeight();
            if (w > this.width) {
                this.width = w;
            }
            if (h > this.height) {
                this.height = h;
            }
            if ((size = w * h) < this.minSize) {
                this.minSize = size;
                this.minWidth = w;
                this.minHeight = h;
            }
            if (size > this.maxSize) {
                this.maxSize = size;
                this.maxWidth = w;
                this.maxHeight = h;
            }
            Calibration cal = this.image[i].getCalibration();
            if (!this.image[i].getCalibration().equals(this.cal2)) {
                this.cal2 = null;
            }
            this.image[index++] = this.image[i];
        }
        return index;
    }

    final boolean exclude(String title) {
        return this.filter != null && title != null && title.indexOf(this.filter) == -1;
    }

    static {
        titlesAsLabels = true;
    }
}

